/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.taobao.weex.analyzer.core.HandlerThreadWrapper;
import com.taobao.weex.analyzer.view.IOverlayView;

public abstract class AbstractLoopTask
implements IOverlayView.ITask,
Runnable {
    private boolean isStop = true;
    private static final int DEFAULT_DELAY_MILLIS = 500;
    protected int mDelayMillis;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    private HandlerThreadWrapper mHandlerThreadWrapper;
    private final boolean isRunInMainThread;

    public AbstractLoopTask(boolean runInMainThread) {
        this.mDelayMillis = 500;
        this.isRunInMainThread = runInMainThread;
    }

    public AbstractLoopTask(boolean runInMainThread, int delayMillis) {
        this.isRunInMainThread = runInMainThread;
        this.mDelayMillis = delayMillis;
    }

    @Override
    public void run() {
        if (this.isStop) {
            return;
        }
        try {
            this.onRun();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isRunInMainThread) {
            this.mUIHandler.postDelayed((Runnable)this, (long)this.mDelayMillis);
        } else if (this.mHandlerThreadWrapper != null && this.mHandlerThreadWrapper.isAlive()) {
            this.mHandlerThreadWrapper.getHandler().postDelayed((Runnable)this, (long)this.mDelayMillis);
        }
    }

    @Override
    public void start() {
        if (!this.isStop) {
            this.stop();
        }
        this.isStop = false;
        try {
            this.onStart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isRunInMainThread) {
            this.mUIHandler.post((Runnable)this);
        } else {
            if (this.mHandlerThreadWrapper == null) {
                this.mHandlerThreadWrapper = new HandlerThreadWrapper("wx-analyzer-" + this.getClass().getSimpleName());
            } else if (!this.mHandlerThreadWrapper.isAlive()) {
                this.mHandlerThreadWrapper = new HandlerThreadWrapper("wx-analyzer-" + this.getClass().getSimpleName());
            } else {
                this.mHandlerThreadWrapper.getHandler().removeCallbacksAndMessages(null);
            }
            this.mHandlerThreadWrapper.getHandler().post((Runnable)this);
        }
    }

    @Override
    public void stop() {
        this.isStop = true;
        this.onStop();
        if (this.mHandlerThreadWrapper != null) {
            this.mHandlerThreadWrapper.quit();
            this.mHandlerThreadWrapper = null;
        }
        this.mUIHandler.removeCallbacksAndMessages(null);
    }

    protected void onStart() {
    }

    protected abstract void onRun();

    protected abstract void onStop();

    protected void runOnUIThread(final @NonNull Runnable runnable) {
        if (this.mUIHandler != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

