/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DeviceCheck {
    private static final String SELECT_RUNTIME_PROPERTY = "persist.sys.dalvik.vm.lib";
    private static final String LIB_DALVIK = "libdvm.so";
    private static final String LIB_ART = "libart.so";
    private static final String LIB_ART_D = "libartd.so";
    private static boolean isCheckedDeviceSupport = false;
    private static boolean isDeviceSupportable = false;

    private static boolean isDalvikMode() {
        String vmMode = DeviceCheck.getCurrentRuntimeValue();
        return "Dalvik".equals(vmMode);
    }

    private static String getCurrentRuntimeValue() {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            try {
                Method get = systemProperties.getMethod("get", String.class, String.class);
                if (get == null) {
                    return "WTF?!";
                }
                try {
                    String value = (String)get.invoke(systemProperties, SELECT_RUNTIME_PROPERTY, "Dalvik");
                    if (LIB_DALVIK.equals(value)) {
                        return "Dalvik";
                    }
                    if (LIB_ART.equals(value)) {
                        return "ART";
                    }
                    if (LIB_ART_D.equals(value)) {
                        return "ART debug build";
                    }
                    return value;
                }
                catch (IllegalAccessException e) {
                    return "IllegalAccessException";
                }
                catch (IllegalArgumentException e) {
                    return "IllegalArgumentException";
                }
                catch (InvocationTargetException e) {
                    return "InvocationTargetException";
                }
            }
            catch (NoSuchMethodException e) {
                return "SystemProperties.get(String key, String def) method is not found";
            }
        }
        catch (ClassNotFoundException e) {
            return "SystemProperties class is not found";
        }
    }

    private static boolean isSupportSDKVersion() {
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 20) {
            return true;
        }
        return Build.VERSION.SDK_INT == 10 || Build.VERSION.SDK_INT == 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isX86CPU() {
        Process process = null;
        String abi = null;
        InputStreamReader ir = null;
        BufferedReader input = null;
        try {
            process = Runtime.getRuntime().exec("getprop ro.product.cpu.abi");
            ir = new InputStreamReader(process.getInputStream());
            input = new BufferedReader(ir);
            abi = input.readLine();
            if (abi.contains("x86")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Exception e) {}
            }
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isDeviceSupport(Context context) {
        try {
            if (isCheckedDeviceSupport) {
                boolean bl = isDeviceSupportable;
                return bl;
            }
            isDeviceSupportable = !DeviceCheck.isX86CPU() && !DeviceCheck.isYunOS();
        }
        finally {
            Log.d((String)"hotpatch", (String)("device support is " + isDeviceSupportable + "checked" + isCheckedDeviceSupport));
            isCheckedDeviceSupport = true;
        }
        return isDeviceSupportable;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static boolean isYunOS() {
        String s1 = null;
        String s2 = null;
        try {
            Method m = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
            s1 = (String)m.invoke(null, "ro.yunos.version");
            s2 = (String)m.invoke(null, "java.vm.name");
        }
        catch (NoSuchMethodException a) {
        }
        catch (ClassNotFoundException b) {
        }
        catch (IllegalAccessException c) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return s2 != null && s2.toLowerCase().contains("lemur") || s1 != null && s1.trim().length() > 0;
    }
}

