/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.PreferenceViewHolderProxy;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.takisoft.fix.support.v7.preference.R;
import java.lang.reflect.Field;
import java.util.List;

class PreferenceGroupAdapter
extends android.support.v7.preference.PreferenceGroupAdapter {
    protected List mPreferenceLayouts;
    protected Field fieldResId;
    protected Field fieldWidgetResId;

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        super(preferenceGroup);
        try {
            Field preferenceLayoutsField = android.support.v7.preference.PreferenceGroupAdapter.class.getDeclaredField("mPreferenceLayouts");
            preferenceLayoutsField.setAccessible(true);
            this.mPreferenceLayouts = (List)preferenceLayoutsField.get((Object)this);
            this.getReflectionFields();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getReflectionFields() {
        try {
            Class<?>[] classes;
            for (Class<?> aClass : classes = android.support.v7.preference.PreferenceGroupAdapter.class.getDeclaredClasses()) {
                if (!"PreferenceLayout".equals(aClass.getSimpleName())) continue;
                this.fieldResId = aClass.getDeclaredField("resId");
                this.fieldWidgetResId = aClass.getDeclaredField("widgetResId");
                this.fieldResId.setAccessible(true);
                this.fieldWidgetResId.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NonNull
    private int[] getReflectedIds(Object pl) {
        int[] ids = new int[2];
        if (this.fieldResId == null || this.fieldWidgetResId == null) {
            this.getReflectionFields();
        }
        try {
            ids[0] = (Integer)this.fieldResId.get(pl);
            ids[1] = (Integer)this.fieldWidgetResId.get(pl);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            ids[0] = 0;
            ids[1] = 0;
        }
        return ids;
    }

    public PreferenceViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewGroup widgetFrame;
        if (Build.VERSION.SDK_INT >= 21) {
            return super.onCreateViewHolder(parent, viewType);
        }
        Object pl = this.mPreferenceLayouts.get(viewType);
        int[] reflIds = this.getReflectedIds(pl);
        if (reflIds[0] == 0 && reflIds[1] == 0) {
            return super.onCreateViewHolder(parent, viewType);
        }
        int resId = reflIds[0];
        int widgetResId = reflIds[1];
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        TypedArray a = parent.getContext().obtainStyledAttributes(null, R.styleable.BackgroundStyle);
        Drawable background = a.getDrawable(R.styleable.BackgroundStyle_android_selectableItemBackground);
        if (background == null) {
            background = parent.getContext().getResources().getDrawable(17301602);
        }
        a.recycle();
        View view = inflater.inflate(resId, parent, false);
        if (view.getBackground() == null) {
            int[] padding = new int[]{ViewCompat.getPaddingStart((View)view), view.getPaddingTop(), ViewCompat.getPaddingEnd((View)view), view.getPaddingBottom()};
            view.setBackgroundDrawable(background);
            ViewCompat.setPaddingRelative((View)view, (int)padding[0], (int)padding[1], (int)padding[2], (int)padding[3]);
        }
        if ((widgetFrame = (ViewGroup)view.findViewById(16908312)) != null) {
            if (widgetResId != 0) {
                inflater.inflate(widgetResId, widgetFrame);
            } else {
                widgetFrame.setVisibility(8);
            }
        }
        return new PreferenceViewHolderProxy(view);
    }
}

