/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.preference.PreferenceDialogFragmentCompat;
import com.takisoft.datetimepicker.TimePickerDialog;
import com.takisoft.datetimepicker.widget.TimePicker;
import com.takisoft.fix.support.v7.preference.TimePickerPreference;
import java.util.Calendar;
import java.util.Date;

public class TimePickerPreferenceDialogFragmentCompat
extends PreferenceDialogFragmentCompat
implements TimePickerDialog.OnTimeSetListener {
    private int pickedHour;
    private int pickedMinute;

    private TimePickerPreference getTimePickerPreference() {
        return (TimePickerPreference)this.getPreference();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        TimePickerPreference preference = this.getTimePickerPreference();
        Calendar cal = Calendar.getInstance();
        Date time = preference.getTime();
        Date pickerTime = preference.getPickerTime();
        if (time != null) {
            cal.setTime(time);
        } else if (pickerTime != null) {
            cal.setTime(pickerTime);
        }
        TimePickerDialog dialog = new TimePickerDialog((Context)this.getActivity(), (TimePickerDialog.OnTimeSetListener)this, cal.get(11), cal.get(12), preference.is24HourView());
        dialog.setButton(-1, preference.getPositiveButtonText(), (DialogInterface.OnClickListener)this);
        dialog.setButton(-2, preference.getNegativeButtonText(), (DialogInterface.OnClickListener)this);
        return dialog;
    }

    public void onClick(DialogInterface dialog, int which) {
        super.onClick(dialog, which);
        if (which == -1) {
            ((TimePickerDialog)this.getDialog()).onClick(dialog, which);
        }
    }

    public void onDialogClosed(boolean positiveResult) {
        TimePickerPreference preference = this.getTimePickerPreference();
        if (positiveResult) {
            preference.setTime(this.pickedHour, this.pickedMinute);
        }
    }

    public void onTimeSet(TimePicker timePicker, int hourOfDay, int minute) {
        this.pickedHour = hourOfDay;
        this.pickedMinute = minute;
        super.onClick((DialogInterface)this.getDialog(), -1);
    }
}

