/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.preference.PreferenceDialogFragmentCompat;
import com.takisoft.datetimepicker.DatePickerDialog;
import com.takisoft.datetimepicker.widget.DatePicker;
import com.takisoft.fix.support.v7.preference.DatePickerPreference;
import java.util.Calendar;
import java.util.Date;

public class DatePickerPreferenceDialogFragmentCompat
extends PreferenceDialogFragmentCompat
implements DatePickerDialog.OnDateSetListener {
    private int pickedYear;
    private int pickedMonth;
    private int pickedDay;

    private DatePickerPreference getDatePickerPreference() {
        return (DatePickerPreference)this.getPreference();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        DatePickerPreference preference = this.getDatePickerPreference();
        Calendar cal = Calendar.getInstance();
        Date date = preference.getDate();
        Date pickerDate = preference.getPickerDate();
        Date minDate = preference.getMinDate();
        Date maxDate = preference.getMaxDate();
        if (date != null) {
            cal.setTime(date);
        } else if (pickerDate != null) {
            cal.setTime(pickerDate);
        }
        DatePickerDialog dialog = new DatePickerDialog((Context)this.getActivity(), (DatePickerDialog.OnDateSetListener)this, cal.get(1), cal.get(2), cal.get(5));
        DatePicker picker = dialog.getDatePicker();
        if (minDate != null) {
            cal.setTime(minDate);
            picker.setMinDate(cal.getTimeInMillis());
        }
        if (maxDate != null) {
            cal.setTime(maxDate);
            picker.setMaxDate(cal.getTimeInMillis());
        }
        dialog.setButton(-1, preference.getPositiveButtonText(), (DialogInterface.OnClickListener)this);
        dialog.setButton(-2, preference.getNegativeButtonText(), (DialogInterface.OnClickListener)this);
        return dialog;
    }

    public void onClick(DialogInterface dialog, int which) {
        super.onClick(dialog, which);
        if (which == -1) {
            ((DatePickerDialog)this.getDialog()).onClick(dialog, which);
        }
    }

    public void onDialogClosed(boolean positiveResult) {
        DatePickerPreference preference = this.getDatePickerPreference();
        if (positiveResult) {
            preference.setDate(this.pickedYear, this.pickedMonth, this.pickedDay);
        }
    }

    public void onDateSet(DatePicker datePicker, int year, int month, int day) {
        this.pickedYear = year;
        this.pickedMonth = month;
        this.pickedDay = day;
        super.onClick((DialogInterface)this.getDialog(), -1);
    }
}

