/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.util;

import android.content.Context;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.text.format.DateFormat;
import com.takisoft.datetimepicker.R;
import java.util.Locale;

public class DateFormatFix {
    public static final String SKELETON_Hm = "Hm";
    public static final String SKELETON_hm = "hm";
    public static final String SKELETON_EMMMd = "EMMMd";
    public static final String SKELETON_EMMMMdy = "EMMMMdy";
    public static final String SKELETON_MMMMy = "MMMMy";

    public static String getBestDateTimePattern(Context context, Locale locale, String skeleton) {
        if (Build.VERSION.SDK_INT >= 18) {
            return DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton);
        }
        switch (skeleton) {
            case "Hm": {
                return context.getString(R.string.datetime_Hm);
            }
            case "hm": {
                return context.getString(R.string.datetime_hm);
            }
            case "EMMMd": {
                return context.getString(R.string.datetime_EMMMd);
            }
            case "EMMMMdy": {
                return context.getString(R.string.datetime_EMMMMdy);
            }
            case "MMMMy": {
                return context.getString(R.string.datetime_MMMMy);
            }
        }
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    public static String getBestDateTimePatternForced(Context context, Locale locale, String skeleton) {
        switch (skeleton) {
            case "Hm": {
                return context.getString(R.string.datetime_Hm);
            }
            case "hm": {
                return context.getString(R.string.datetime_hm);
            }
            case "EMMMd": {
                return context.getString(R.string.datetime_EMMMd);
            }
            case "EMMMMdy": {
                return context.getString(R.string.datetime_EMMMMdy);
            }
            case "MMMMy": {
                return context.getString(R.string.datetime_MMMMy);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static char[] getDateFormatOrder(Context context, Locale locale, String skeleton) {
        return DateFormat.getDateFormatOrder((Context)context);
    }
}

