/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.IBinder;
import android.support.v4.math.MathUtils;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.widget.TimePicker;
import com.takisoft.datetimepicker.widget.TimePickerClockDelegate;

public class TextInputTimePickerView
extends RelativeLayout {
    public static final int HOURS = 0;
    public static final int MINUTES = 1;
    public static final int AMPM = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private EditText mHourEditText;
    private EditText mMinuteEditText;
    private TextView mInputSeparatorView;
    private Spinner mAmPmSpinner;
    private TextView mErrorLabel;
    private TextView mHourLabel;
    private TextView mMinuteLabel;
    private boolean mIs24Hour;
    private boolean mHourFormatStartsAtZero;
    private OnValueTypedListener mListener;
    private boolean mErrorShowing;

    public TextInputTimePickerView(Context context) {
        this(context, null);
    }

    public TextInputTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextInputTimePickerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.attrHandler(context, attrs, defStyle, 0);
    }

    @TargetApi(value=21)
    public TextInputTimePickerView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.attrHandler(context, attrs, defStyle, defStyleRes);
    }

    private void attrHandler(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        TextInputTimePickerView.inflate((Context)context, (int)R.layout.time_picker_text_input_material, (ViewGroup)this);
        this.mHourEditText = (EditText)this.findViewById(R.id.input_hour);
        this.mMinuteEditText = (EditText)this.findViewById(R.id.input_minute);
        this.mInputSeparatorView = (TextView)this.findViewById(R.id.input_separator);
        this.mErrorLabel = (TextView)this.findViewById(R.id.label_error);
        this.mHourLabel = (TextView)this.findViewById(R.id.label_hour);
        this.mMinuteLabel = (TextView)this.findViewById(R.id.label_minute);
        this.mHourEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                TextInputTimePickerView.this.parseAndSetHourInternal(editable.toString());
            }
        });
        this.mMinuteEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                TextInputTimePickerView.this.parseAndSetMinuteInternal(editable.toString());
            }
        });
        this.mAmPmSpinner = (Spinner)this.findViewById(R.id.am_pm_spinner);
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        ArrayAdapter adapter = new ArrayAdapter(context, 0x1090009);
        adapter.add((Object)TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        adapter.add((Object)TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mAmPmSpinner.setAdapter((SpinnerAdapter)adapter);
        this.mAmPmSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
                if (position == 0) {
                    TextInputTimePickerView.this.mListener.onValueChanged(2, 0);
                } else {
                    TextInputTimePickerView.this.mListener.onValueChanged(2, 1);
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }

    void changeInputMethod(boolean show) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        IBinder token = this.getWindowToken();
        if (inputMethodManager != null && token != null && !show) {
            inputMethodManager.hideSoftInputFromWindow(token, 2);
        }
    }

    void setListener(OnValueTypedListener listener) {
        this.mListener = listener;
    }

    void setHourFormat(int maxCharLength) {
        this.mHourEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
        this.mMinuteEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
    }

    boolean validateInput() {
        boolean inputValid = this.parseAndSetHourInternal(this.mHourEditText.getText().toString()) && this.parseAndSetMinuteInternal(this.mMinuteEditText.getText().toString());
        this.setError(!inputValid);
        return inputValid;
    }

    void updateSeparator(String separatorText) {
        this.mInputSeparatorView.setText((CharSequence)separatorText);
    }

    private void setError(boolean enabled) {
        this.mErrorShowing = enabled;
        this.mErrorLabel.setVisibility(enabled ? 0 : 4);
        this.mHourLabel.setVisibility(enabled ? 4 : 0);
        this.mMinuteLabel.setVisibility(enabled ? 4 : 0);
    }

    void updateTextInputValues(int localizedHour, int minute, int amOrPm, boolean is24Hour, boolean hourFormatStartsAtZero) {
        String format = "%d";
        this.mIs24Hour = is24Hour;
        this.mHourFormatStartsAtZero = hourFormatStartsAtZero;
        this.mAmPmSpinner.setVisibility(is24Hour ? 4 : 0);
        if (amOrPm == 0) {
            this.mAmPmSpinner.setSelection(0);
        } else {
            this.mAmPmSpinner.setSelection(1);
        }
        this.mHourEditText.setText((CharSequence)String.format("%d", localizedHour));
        this.mMinuteEditText.setText((CharSequence)String.format("%d", minute));
        if (this.mErrorShowing) {
            this.validateInput();
        }
    }

    private boolean parseAndSetHourInternal(String input) {
        try {
            int hour = Integer.parseInt(input);
            if (!this.isValidLocalizedHour(hour)) {
                int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
                int maxHour = this.mIs24Hour ? 23 : 11 + minHour;
                this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(MathUtils.clamp((int)hour, (int)minHour, (int)maxHour)));
                return false;
            }
            this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(hour));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean parseAndSetMinuteInternal(String input) {
        try {
            int minutes = Integer.parseInt(input);
            if (minutes < 0 || minutes > 59) {
                this.mListener.onValueChanged(1, MathUtils.clamp((int)minutes, (int)0, (int)59));
                return false;
            }
            this.mListener.onValueChanged(1, minutes);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidLocalizedHour(int localizedHour) {
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        return localizedHour >= minHour && localizedHour <= maxHour;
    }

    private int getHourOfDayFromLocalizedHour(int localizedHour) {
        int hourOfDay = localizedHour;
        if (this.mIs24Hour) {
            if (!this.mHourFormatStartsAtZero && localizedHour == 24) {
                hourOfDay = 0;
            }
        } else {
            if (!this.mHourFormatStartsAtZero && localizedHour == 12) {
                hourOfDay = 0;
            }
            if (this.mAmPmSpinner.getSelectedItemPosition() == 1) {
                hourOfDay += 12;
            }
        }
        return hourOfDay;
    }

    static interface OnValueTypedListener {
        public void onValueChanged(int var1, int var2);
    }
}

