/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v7.content.res.AppCompatResources;
import android.text.SpannableStringBuilder;
import android.text.format.DateUtils;
import android.text.style.TtsSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.util.DateFormatFix;
import com.takisoft.datetimepicker.util.StateSet;
import com.takisoft.datetimepicker.util.Utils;
import com.takisoft.datetimepicker.widget.RadialTimePickerView;
import com.takisoft.datetimepicker.widget.TextInputTimePickerView;
import com.takisoft.datetimepicker.widget.TimePicker;
import com.takisoft.datetimepicker.widget.internal.NumericTextView;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;

class TimePickerClockDelegate
extends TimePicker.AbstractTimePickerDelegate {
    private static final long DELAY_COMMIT_MILLIS = 2000L;
    private static final int FROM_EXTERNAL_API = 0;
    private static final int FROM_RADIAL_PICKER = 1;
    private static final int FROM_INPUT_PICKER = 2;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int[] ATTRS_TEXT_COLOR = new int[]{16842904};
    private static final int[] ATTRS_DISABLED_ALPHA = new int[]{0x1010033};
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int HOURS_IN_HALF_DAY = 12;
    private final NumericTextView mHourView;
    private final NumericTextView mMinuteView;
    private final View mAmPmLayout;
    private final RadioButton mAmLabel;
    private final RadioButton mPmLabel;
    private final RadialTimePickerView mRadialTimePickerView;
    private final TextView mSeparatorView;
    private boolean mRadialPickerModeEnabled = true;
    private final ImageButton mRadialTimePickerModeButton;
    private final String mRadialTimePickerModeEnabledDescription;
    private final String mTextInputPickerModeEnabledDescription;
    private final View mRadialTimePickerHeader;
    private final View mTextInputPickerHeader;
    private final TextInputTimePickerView mTextInputPickerView;
    private final Calendar mTempCalendar;
    private final String mSelectHours;
    private final String mSelectMinutes;
    private boolean mIsEnabled = true;
    private boolean mAllowAutoAdvance;
    private int mCurrentHour;
    private int mCurrentMinute;
    private boolean mIs24Hour;
    private boolean mIsAmPmAtStart;
    private boolean mHourFormatShowLeadingZero;
    private boolean mHourFormatStartsAtZero;
    private CharSequence mLastAnnouncedText;
    private boolean mLastAnnouncedIsHour;
    private final RadialTimePickerView.OnValueSelectedListener mOnValueSelectedListener = new RadialTimePickerView.OnValueSelectedListener(){

        @Override
        public void onValueSelected(int pickerType, int newValue, boolean autoAdvance) {
            boolean valueChanged = false;
            switch (pickerType) {
                case 0: {
                    if (TimePickerClockDelegate.this.getHour() != newValue) {
                        valueChanged = true;
                    }
                    boolean isTransition = TimePickerClockDelegate.this.mAllowAutoAdvance && autoAdvance;
                    TimePickerClockDelegate.this.setHourInternal(newValue, 1, !isTransition);
                    if (!isTransition) break;
                    TimePickerClockDelegate.this.setCurrentItemShowing(1, true, false);
                    int localizedHour = TimePickerClockDelegate.this.getLocalizedHour(newValue);
                    if (Build.VERSION.SDK_INT < 16) break;
                    TimePickerClockDelegate.this.mDelegator.announceForAccessibility(localizedHour + ". " + TimePickerClockDelegate.this.mSelectMinutes);
                    break;
                }
                case 1: {
                    if (TimePickerClockDelegate.this.getMinute() != newValue) {
                        valueChanged = true;
                    }
                    TimePickerClockDelegate.this.setMinuteInternal(newValue, 1);
                }
            }
            if (TimePickerClockDelegate.this.mOnTimeChangedListener != null && valueChanged) {
                TimePickerClockDelegate.this.mOnTimeChangedListener.onTimeChanged(TimePickerClockDelegate.this.mDelegator, TimePickerClockDelegate.this.getHour(), TimePickerClockDelegate.this.getMinute());
            }
        }
    };
    private final TextInputTimePickerView.OnValueTypedListener mOnValueTypedListener = new TextInputTimePickerView.OnValueTypedListener(){

        @Override
        public void onValueChanged(int pickerType, int newValue) {
            switch (pickerType) {
                case 0: {
                    TimePickerClockDelegate.this.setHourInternal(newValue, 2, false);
                    break;
                }
                case 1: {
                    TimePickerClockDelegate.this.setMinuteInternal(newValue, 2);
                    break;
                }
                case 2: {
                    TimePickerClockDelegate.this.setAmOrPm(newValue);
                }
            }
        }
    };
    private final NumericTextView.OnValueChangedListener mDigitEnteredListener = new NumericTextView.OnValueChangedListener(){

        @Override
        public void onValueChanged(NumericTextView view, int value, boolean isValid, boolean isFinished) {
            NumericTextView nextFocusTarget;
            Runnable commitCallback;
            if (view == TimePickerClockDelegate.this.mHourView) {
                commitCallback = TimePickerClockDelegate.this.mCommitHour;
                nextFocusTarget = view.isFocused() ? TimePickerClockDelegate.this.mMinuteView : null;
            } else if (view == TimePickerClockDelegate.this.mMinuteView) {
                commitCallback = TimePickerClockDelegate.this.mCommitMinute;
                nextFocusTarget = null;
            } else {
                return;
            }
            view.removeCallbacks(commitCallback);
            if (isValid) {
                if (isFinished) {
                    commitCallback.run();
                    if (nextFocusTarget != null) {
                        nextFocusTarget.requestFocus();
                    }
                } else {
                    view.postDelayed(commitCallback, 2000L);
                }
            }
        }
    };
    private final Runnable mCommitHour = new Runnable(){

        @Override
        public void run() {
            TimePickerClockDelegate.this.setHour(TimePickerClockDelegate.this.mHourView.getValue());
        }
    };
    private final Runnable mCommitMinute = new Runnable(){

        @Override
        public void run() {
            TimePickerClockDelegate.this.setMinute(TimePickerClockDelegate.this.mMinuteView.getValue());
        }
    };
    private final View.OnFocusChangeListener mFocusListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean focused) {
            if (focused) {
                int i = v.getId();
                if (i == R.id.am_label) {
                    TimePickerClockDelegate.this.setAmOrPm(0);
                } else if (i == R.id.pm_label) {
                    TimePickerClockDelegate.this.setAmOrPm(1);
                } else if (i == R.id.hours) {
                    TimePickerClockDelegate.this.setCurrentItemShowing(0, true, true);
                } else if (i == R.id.minutes) {
                    TimePickerClockDelegate.this.setCurrentItemShowing(1, true, true);
                } else {
                    return;
                }
                TimePickerClockDelegate.this.tryVibrate();
            }
        }
    };
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.am_label) {
                TimePickerClockDelegate.this.setAmOrPm(0);
            } else if (i == R.id.pm_label) {
                TimePickerClockDelegate.this.setAmOrPm(1);
            } else if (i == R.id.hours) {
                TimePickerClockDelegate.this.setCurrentItemShowing(0, true, true);
            } else if (i == R.id.minutes) {
                TimePickerClockDelegate.this.setCurrentItemShowing(1, true, true);
            } else {
                return;
            }
            TimePickerClockDelegate.this.tryVibrate();
        }
    };

    public TimePickerClockDelegate(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        Drawable headerBg;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mSelectHours = res.getString(R.string.select_hours);
        this.mSelectMinutes = res.getString(R.string.select_minutes);
        int layoutResourceId = a.getResourceId(R.styleable.TimePicker_internalLayout, R.layout.time_picker_material);
        View mainView = inflater.inflate(layoutResourceId, (ViewGroup)delegator);
        mainView.setSaveFromParentEnabled(false);
        this.mRadialTimePickerHeader = mainView.findViewById(R.id.time_header);
        this.mRadialTimePickerHeader.setOnTouchListener((View.OnTouchListener)new NearestTouchDelegate());
        this.mHourView = (NumericTextView)mainView.findViewById(R.id.hours);
        this.mHourView.setOnClickListener(this.mClickListener);
        this.mHourView.setOnFocusChangeListener(this.mFocusListener);
        this.mHourView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mHourView.setAccessibilityDelegate(new ClickActionDelegate(context, R.string.select_hours));
        this.mSeparatorView = (TextView)mainView.findViewById(R.id.separator);
        this.mMinuteView = (NumericTextView)mainView.findViewById(R.id.minutes);
        this.mMinuteView.setOnClickListener(this.mClickListener);
        this.mMinuteView.setOnFocusChangeListener(this.mFocusListener);
        this.mMinuteView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mMinuteView.setAccessibilityDelegate(new ClickActionDelegate(context, R.string.select_minutes));
        this.mMinuteView.setRange(0, 59);
        this.mAmPmLayout = mainView.findViewById(R.id.ampm_layout);
        this.mAmPmLayout.setOnTouchListener((View.OnTouchListener)new NearestTouchDelegate());
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        this.mAmLabel = (RadioButton)this.mAmPmLayout.findViewById(R.id.am_label);
        this.mAmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        this.mAmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth((TextView)this.mAmLabel);
        this.mPmLabel = (RadioButton)this.mAmPmLayout.findViewById(R.id.pm_label);
        this.mPmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mPmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth((TextView)this.mPmLabel);
        ColorStateList headerTextColor = null;
        int timeHeaderTextAppearance = a.getResourceId(R.styleable.TimePicker_headerTimeTextAppearance, 0);
        if (timeHeaderTextAppearance != 0) {
            TypedArray textAppearance = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, timeHeaderTextAppearance);
            ColorStateList legacyHeaderTextColor = Utils.getColorStateList(this.mContext, textAppearance, 0);
            headerTextColor = this.applyLegacyColorFixes(legacyHeaderTextColor);
            textAppearance.recycle();
        }
        if (headerTextColor == null) {
            headerTextColor = Utils.getColorStateList(this.mContext, a, R.styleable.TimePicker_headerTextColor);
        }
        this.mTextInputPickerHeader = mainView.findViewById(R.id.input_header);
        if (headerTextColor != null) {
            this.mHourView.setTextColor(headerTextColor);
            this.mSeparatorView.setTextColor(headerTextColor);
            this.mMinuteView.setTextColor(headerTextColor);
            this.mAmLabel.setTextColor(headerTextColor);
            this.mPmLabel.setTextColor(headerTextColor);
        }
        if ((headerBg = a.getDrawable(R.styleable.TimePicker_headerBackground)) != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mRadialTimePickerHeader.setBackground(a.getDrawable(R.styleable.TimePicker_headerBackground));
                this.mTextInputPickerHeader.setBackground(a.getDrawable(R.styleable.TimePicker_headerBackground));
            } else {
                this.mRadialTimePickerHeader.setBackgroundDrawable(a.getDrawable(R.styleable.TimePicker_headerBackground));
                this.mTextInputPickerHeader.setBackgroundDrawable(a.getDrawable(R.styleable.TimePicker_headerBackground));
            }
        }
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(R.id.radial_picker);
        this.mRadialTimePickerView.applyAttributes(attrs, defStyleAttr, defStyleRes);
        this.mRadialTimePickerView.setOnValueSelectedListener(this.mOnValueSelectedListener);
        this.mTextInputPickerView = (TextInputTimePickerView)mainView.findViewById(R.id.input_mode);
        this.mTextInputPickerView.setListener(this.mOnValueTypedListener);
        this.mRadialTimePickerModeButton = (ImageButton)mainView.findViewById(R.id.toggle_mode);
        Drawable drawable2 = this.mRadialTimePickerModeButton.getDrawable();
        Drawable wrapped = DrawableCompat.wrap((Drawable)drawable2);
        TypedArray arr = context.obtainStyledAttributes(new int[]{R.attr.colorControlNormal});
        ColorStateList tintList = Utils.getColorStateList(this.mContext, arr, 0);
        arr.recycle();
        if (tintList != null) {
            DrawableCompat.setTintList((Drawable)wrapped, (ColorStateList)tintList);
        }
        this.mRadialTimePickerModeButton.setImageDrawable(wrapped);
        this.mRadialTimePickerModeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerClockDelegate.this.toggleRadialPickerMode();
            }
        });
        this.mRadialTimePickerModeEnabledDescription = context.getResources().getString(R.string.time_picker_radial_mode_description);
        this.mTextInputPickerModeEnabledDescription = context.getResources().getString(R.string.time_picker_text_input_mode_description);
        this.mAllowAutoAdvance = true;
        this.updateHourFormat();
        this.mTempCalendar = Calendar.getInstance(this.mLocale);
        int currentHour = this.mTempCalendar.get(11);
        int currentMinute = this.mTempCalendar.get(12);
        this.initialize(currentHour, currentMinute, this.mIs24Hour, 0);
    }

    private void toggleRadialPickerMode() {
        if (this.mRadialPickerModeEnabled) {
            this.mRadialTimePickerView.setVisibility(8);
            this.mRadialTimePickerHeader.setVisibility(8);
            this.mTextInputPickerHeader.setVisibility(0);
            this.mTextInputPickerView.setVisibility(0);
            this.mRadialTimePickerModeButton.setImageDrawable(Utils.tintDrawable(this.mContext, AppCompatResources.getDrawable((Context)this.mContext, (int)R.drawable.btn_clock_material), R.attr.colorControlNormal));
            this.mRadialTimePickerModeButton.setContentDescription((CharSequence)this.mRadialTimePickerModeEnabledDescription);
            this.mRadialPickerModeEnabled = false;
        } else {
            this.mRadialTimePickerView.setVisibility(0);
            this.mRadialTimePickerHeader.setVisibility(0);
            this.mTextInputPickerHeader.setVisibility(8);
            this.mTextInputPickerView.changeInputMethod(false);
            this.mTextInputPickerView.setVisibility(8);
            this.mRadialTimePickerModeButton.setImageDrawable(Utils.tintDrawable(this.mContext, AppCompatResources.getDrawable((Context)this.mContext, (int)R.drawable.btn_keyboard_key_material), R.attr.colorControlNormal));
            this.mRadialTimePickerModeButton.setContentDescription((CharSequence)this.mTextInputPickerModeEnabledDescription);
            this.updateTextInputPicker();
            this.mRadialPickerModeEnabled = true;
        }
    }

    @Override
    public boolean validateInput() {
        return this.mTextInputPickerView.validateInput();
    }

    private static void ensureMinimumTextWidth(TextView v) {
        v.measure(0, 0);
        int minWidth = v.getMeasuredWidth();
        v.setMinWidth(minWidth);
        v.setMinimumWidth(minWidth);
    }

    private void updateHourFormat() {
        String bestDateTimePattern = DateFormatFix.getBestDateTimePattern(this.mContext, this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean showLeadingZero = false;
        int hourFormat = 0;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            showLeadingZero = true;
            break;
        }
        this.mHourFormatShowLeadingZero = showLeadingZero;
        this.mHourFormatStartsAtZero = hourFormat == 75 || hourFormat == 72;
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        this.mHourView.setRange(minHour, maxHour);
        this.mHourView.setShowLeadingZeroes(this.mHourFormatShowLeadingZero);
        NumberFormat intFormat = DecimalFormat.getIntegerInstance(this.mLocale);
        intFormat.setGroupingUsed(false);
        int maxCharLength = 0;
        for (int i = 0; i < 10; ++i) {
            maxCharLength = Math.max(maxCharLength, intFormat.format(i).length());
        }
        this.mTextInputPickerView.setHourFormat(maxCharLength * 2);
    }

    static final CharSequence obtainVerbatim(String text) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new SpannableStringBuilder().append((CharSequence)text, (Object)new TtsSpan.VerbatimBuilder(text).build(), 0);
        }
        return text;
    }

    @Nullable
    private ColorStateList applyLegacyColorFixes(@Nullable ColorStateList color2) {
        int defaultColor;
        int activatedColor;
        if (color2 == null || Utils.colorHasState(color2, 16843518)) {
            return color2;
        }
        if (Utils.colorHasState(color2, 0x10100A1)) {
            activatedColor = color2.getColorForState(StateSet.get(10), 0);
            defaultColor = color2.getColorForState(StateSet.get(8), 0);
        } else {
            activatedColor = color2.getDefaultColor();
            TypedArray ta = this.mContext.obtainStyledAttributes(ATTRS_DISABLED_ALPHA);
            float disabledAlpha = ta.getFloat(0, 0.3f);
            defaultColor = this.multiplyAlphaComponent(activatedColor, disabledAlpha);
            ta.recycle();
        }
        if (activatedColor == 0 || defaultColor == 0) {
            return null;
        }
        int[][] stateSet = new int[][]{{16843518}, new int[0]};
        int[] colors = new int[]{activatedColor, defaultColor};
        return new ColorStateList((int[][])stateSet, colors);
    }

    private int multiplyAlphaComponent(int color2, float alphaMod) {
        int srcRgb = color2 & 0xFFFFFF;
        int srcAlpha = color2 >> 24 & 0xFF;
        int dstAlpha = (int)((float)srcAlpha * alphaMod + 0.5f);
        return srcRgb | dstAlpha << 24;
    }

    private void initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mCurrentHour = hourOfDay;
        this.mCurrentMinute = minute;
        this.mIs24Hour = is24HourView;
        this.updateUI(index);
    }

    private void updateUI(int index) {
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mCurrentHour, false);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mCurrentMinute, false);
        this.updateRadialPicker(index);
        this.updateTextInputPicker();
        this.mDelegator.invalidate();
    }

    private void updateTextInputPicker() {
        this.mTextInputPickerView.updateTextInputValues(this.getLocalizedHour(this.mCurrentHour), this.mCurrentMinute, this.mCurrentHour < 12 ? 0 : 1, this.mIs24Hour, this.mHourFormatStartsAtZero);
    }

    private void updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mCurrentHour, this.mCurrentMinute, this.mIs24Hour);
        this.setCurrentItemShowing(index, false, true);
    }

    private void updateHeaderAmPm() {
        if (this.mIs24Hour) {
            this.mAmPmLayout.setVisibility(8);
        } else {
            String dateTimePattern = DateFormatFix.getBestDateTimePattern(this.mContext, this.mLocale, "hm");
            boolean isAmPmAtStart = dateTimePattern.startsWith("a");
            this.setAmPmAtStart(isAmPmAtStart);
            this.updateAmPmLabelStates(this.mCurrentHour < 12 ? 0 : 1);
        }
    }

    private void setAmPmAtStart(boolean isAmPmAtStart) {
        if (this.mIsAmPmAtStart != isAmPmAtStart) {
            this.mIsAmPmAtStart = isAmPmAtStart;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mAmPmLayout.getLayoutParams();
            int[] rules = params.getRules();
            if (rules[1] != 0 || rules[0] != 0) {
                if (isAmPmAtStart) {
                    params.addRule(1, 0);
                    params.addRule(0, this.mHourView.getId());
                } else {
                    params.addRule(0, 0);
                    params.addRule(1, this.mMinuteView.getId());
                }
            }
            this.mAmPmLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @Override
    public void setHour(int hour) {
        this.setHourInternal(hour, 0, true);
    }

    private void setHourInternal(int hour, int source, boolean announce) {
        if (this.mCurrentHour == hour) {
            return;
        }
        this.mCurrentHour = hour;
        this.updateHeaderHour(hour, announce);
        this.updateHeaderAmPm();
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentHour(hour);
            this.mRadialTimePickerView.setAmOrPm(hour < 12 ? 0 : 1);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public int getHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24Hour) {
            return currentHour;
        }
        if (this.mRadialTimePickerView.getAmOrPm() == 1) {
            return currentHour % 12 + 12;
        }
        return currentHour % 12;
    }

    @Override
    public void setMinute(int minute) {
        this.setMinuteInternal(minute, 0);
    }

    private void setMinuteInternal(int minute, int source) {
        if (this.mCurrentMinute == minute) {
            return;
        }
        this.mCurrentMinute = minute;
        this.updateHeaderMinute(minute, true);
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentMinute(minute);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public int getMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    @Override
    public void setIs24Hour(boolean is24Hour) {
        if (this.mIs24Hour != is24Hour) {
            this.mIs24Hour = is24Hour;
            this.mCurrentHour = this.getHour();
            this.updateHourFormat();
            this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
        }
    }

    @Override
    public boolean is24Hour() {
        return this.mIs24Hour;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmLabel.setEnabled(enabled);
        this.mPmLabel.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        return new TimePicker.AbstractTimePickerDelegate.SavedState(superState, this.getHour(), this.getMinute(), this.is24Hour(), this.getCurrentItemShowing());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof TimePicker.AbstractTimePickerDelegate.SavedState) {
            TimePicker.AbstractTimePickerDelegate.SavedState ss = (TimePicker.AbstractTimePickerDelegate.SavedState)state;
            this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
            this.mRadialTimePickerView.invalidate();
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24Hour ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getHour());
        this.mTempCalendar.set(12, this.getMinute());
        String selectedTime = DateUtils.formatDateTime((Context)this.mContext, (long)this.mTempCalendar.getTimeInMillis(), (int)flags);
        String selectionMode = this.mRadialTimePickerView.getCurrentItemShowing() == 0 ? this.mSelectHours : this.mSelectMinutes;
        event.getText().add(selectedTime + " " + selectionMode);
    }

    @Override
    public View getHourView() {
        return this.mHourView;
    }

    @Override
    public View getMinuteView() {
        return this.mMinuteView;
    }

    @Override
    public View getAmView() {
        return this.mAmLabel;
    }

    @Override
    public View getPmView() {
        return this.mPmLabel;
    }

    private int getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
        if (this.mAutoFillChangeListener != null) {
            this.mAutoFillChangeListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private void updateAmPmLabelStates(int amOrPm) {
        boolean isAm = amOrPm == 0;
        this.mAmLabel.setActivated(isAm);
        this.mAmLabel.setChecked(isAm);
        boolean isPm = amOrPm == 1;
        this.mPmLabel.setActivated(isPm);
        this.mPmLabel.setChecked(isPm);
    }

    private int getLocalizedHour(int hourOfDay) {
        if (!this.mIs24Hour) {
            hourOfDay %= 12;
        }
        if (!this.mHourFormatStartsAtZero && hourOfDay == 0) {
            hourOfDay = this.mIs24Hour ? 24 : 12;
        }
        return hourOfDay;
    }

    private void updateHeaderHour(int hourOfDay, boolean announce) {
        int localizedHour = this.getLocalizedHour(hourOfDay);
        this.mHourView.setValue(localizedHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mHourView.getText(), true);
        }
    }

    private void updateHeaderMinute(int minuteOfHour, boolean announce) {
        this.mMinuteView.setValue(minuteOfHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mMinuteView.getText(), false);
        }
    }

    private void updateHeaderSeparator() {
        String bestDateTimePattern = DateFormatFix.getBestDateTimePattern(this.mContext, this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
        int hIndex = TimePickerClockDelegate.lastIndexOfAny(bestDateTimePattern, hourFormats);
        String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
        this.mSeparatorView.setText((CharSequence)separatorText);
        this.mTextInputPickerView.updateSeparator(separatorText);
    }

    private static int lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void tryAnnounceForAccessibility(CharSequence text, boolean isHour) {
        if (this.mLastAnnouncedIsHour != isHour || !text.equals(this.mLastAnnouncedText)) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mDelegator.announceForAccessibility(text);
            }
            this.mLastAnnouncedText = text;
            this.mLastAnnouncedIsHour = isHour;
        }
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            if (announce && Build.VERSION.SDK_INT >= 16) {
                this.mDelegator.announceForAccessibility(this.mSelectHours);
            }
        } else if (announce && Build.VERSION.SDK_INT >= 16) {
            this.mDelegator.announceForAccessibility(this.mSelectMinutes);
        }
        this.mHourView.setActivated(index == 0);
        this.mMinuteView.setActivated(index == 1);
    }

    private void setAmOrPm(int amOrPm) {
        this.updateAmPmLabelStates(amOrPm);
        if (this.mRadialTimePickerView.setAmOrPm(amOrPm)) {
            this.mCurrentHour = this.getHour();
            this.updateTextInputPicker();
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
            }
        }
    }

    private static class NearestTouchDelegate
    implements View.OnTouchListener {
        private View mInitialTouchTarget;

        private NearestTouchDelegate() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            View child;
            int actionMasked = motionEvent.getActionMasked();
            if (actionMasked == 0) {
                this.mInitialTouchTarget = view instanceof ViewGroup ? this.findNearestChild((ViewGroup)view, (int)motionEvent.getX(), (int)motionEvent.getY()) : null;
            }
            if ((child = this.mInitialTouchTarget) == null) {
                return false;
            }
            float offsetX = view.getScrollX() - child.getLeft();
            float offsetY = view.getScrollY() - child.getTop();
            motionEvent.offsetLocation(offsetX, offsetY);
            boolean handled = child.dispatchTouchEvent(motionEvent);
            motionEvent.offsetLocation(-offsetX, -offsetY);
            if (actionMasked == 1 || actionMasked == 3) {
                this.mInitialTouchTarget = null;
            }
            return handled;
        }

        private View findNearestChild(ViewGroup v, int x, int y) {
            View bestChild = null;
            int bestDist = Integer.MAX_VALUE;
            int count = v.getChildCount();
            for (int i = 0; i < count; ++i) {
                int dY;
                View child = v.getChildAt(i);
                int dX = x - (child.getLeft() + child.getWidth() / 2);
                int dist = dX * dX + (dY = y - (child.getTop() + child.getHeight() / 2)) * dY;
                if (bestDist <= dist) continue;
                bestChild = child;
                bestDist = dist;
            }
            return bestChild;
        }
    }

    private static class ClickActionDelegate
    extends View.AccessibilityDelegate {
        private final AccessibilityNodeInfoCompat.AccessibilityActionCompat mClickAction;

        public ClickActionDelegate(Context context, int resId) {
            this.mClickAction = new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)context.getString(resId));
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info).addAction(this.mClickAction);
        }
    }
}

