/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.icu.text.DisplayContext;
import android.icu.text.SimpleDateFormat;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.takisoft.datetimepicker.R;
import com.takisoft.datetimepicker.util.DateFormatFix;
import com.takisoft.datetimepicker.util.StateSet;
import com.takisoft.datetimepicker.util.Utils;
import com.takisoft.datetimepicker.widget.CalendarView;
import com.takisoft.datetimepicker.widget.DatePicker;
import com.takisoft.datetimepicker.widget.DayPickerView;
import com.takisoft.datetimepicker.widget.YearPickerView;
import java.text.Format;
import java.util.Calendar;
import java.util.Locale;

class DatePickerCalendarDelegate
extends DatePicker.AbstractDatePickerDelegate {
    private static final int USE_LOCALE = 0;
    private static final int UNINITIALIZED = -1;
    private static final int VIEW_MONTH_DAY = 0;
    private static final int VIEW_YEAR = 1;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int[] ATTRS_TEXT_COLOR = new int[]{16842904};
    private static final int[] ATTRS_DISABLED_ALPHA = new int[]{0x1010033};
    private Format mYearFormat;
    private Format mMonthDayFormat;
    private Format mAccessibilityEventFormat;
    private ViewGroup mContainer;
    private TextView mHeaderYear;
    private TextView mHeaderMonthDay;
    private ViewAnimator mAnimator;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private String mSelectDay;
    private String mSelectYear;
    private DatePicker.OnDateChangedListener mDateChangedListener;
    private int mCurrentView = -1;
    private final Calendar mCurrentDate;
    private final Calendar mTempDate;
    private final Calendar mMinDate;
    private final Calendar mMaxDate;
    private int mFirstDayOfWeek = 0;
    private final DayPickerView.OnDaySelectedListener mOnDaySelectedListener = new DayPickerView.OnDaySelectedListener(){

        @Override
        public void onDaySelected(DayPickerView view, Calendar day) {
            DatePickerCalendarDelegate.this.mCurrentDate.setTimeInMillis(day.getTimeInMillis());
            DatePickerCalendarDelegate.this.onDateChanged(true, true);
        }
    };
    private final YearPickerView.OnYearSelectedListener mOnYearSelectedListener = new YearPickerView.OnYearSelectedListener(){

        @Override
        public void onYearChanged(YearPickerView view, int year) {
            int month;
            int daysInMonth;
            int day = DatePickerCalendarDelegate.this.mCurrentDate.get(5);
            if (day > (daysInMonth = DatePickerCalendarDelegate.getDaysInMonth(month = DatePickerCalendarDelegate.this.mCurrentDate.get(2), year))) {
                DatePickerCalendarDelegate.this.mCurrentDate.set(5, daysInMonth);
            }
            DatePickerCalendarDelegate.this.mCurrentDate.set(1, year);
            DatePickerCalendarDelegate.this.onDateChanged(true, true);
            DatePickerCalendarDelegate.this.setCurrentView(0);
            DatePickerCalendarDelegate.this.mHeaderYear.requestFocus();
        }
    };
    private final View.OnClickListener mOnHeaderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            DatePickerCalendarDelegate.this.tryVibrate();
            int i = v.getId();
            if (i == R.id.date_picker_header_year) {
                DatePickerCalendarDelegate.this.setCurrentView(1);
            } else if (i == R.id.date_picker_header_date) {
                DatePickerCalendarDelegate.this.setCurrentView(0);
            }
        }
    };

    public DatePickerCalendarDelegate(DatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        Drawable headerBg;
        Locale locale = this.mCurrentLocale;
        this.mCurrentDate = Calendar.getInstance(locale);
        this.mTempDate = Calendar.getInstance(locale);
        this.mMinDate = Calendar.getInstance(locale);
        this.mMaxDate = Calendar.getInstance(locale);
        this.mMinDate.set(1900, 0, 1);
        this.mMaxDate.set(2100, 11, 31);
        Resources res = this.mDelegator.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        int layoutResourceId = a.getResourceId(R.styleable.DatePicker_internalLayout, R.layout.date_picker_material);
        this.mContainer = (ViewGroup)inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, false);
        this.mDelegator.addView((View)this.mContainer);
        ViewGroup header = (ViewGroup)this.mContainer.findViewById(R.id.date_picker_header);
        this.mHeaderYear = (TextView)header.findViewById(R.id.date_picker_header_year);
        this.mHeaderYear.setOnClickListener(this.mOnHeaderClickListener);
        this.mHeaderMonthDay = (TextView)header.findViewById(R.id.date_picker_header_date);
        this.mHeaderMonthDay.setOnClickListener(this.mOnHeaderClickListener);
        ColorStateList headerTextColor = null;
        int monthHeaderTextAppearance = a.getResourceId(R.styleable.DatePicker_headerMonthTextAppearance, 0);
        if (monthHeaderTextAppearance != 0) {
            TypedArray textAppearance = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, monthHeaderTextAppearance);
            ColorStateList legacyHeaderTextColor = textAppearance.getColorStateList(0);
            headerTextColor = this.applyLegacyColorFixes(legacyHeaderTextColor);
            textAppearance.recycle();
        }
        if (headerTextColor == null) {
            headerTextColor = Utils.getColorStateList(context, a, R.styleable.DatePicker_headerTextColor);
        }
        if (headerTextColor != null) {
            this.mHeaderYear.setTextColor(headerTextColor);
            this.mHeaderMonthDay.setTextColor(headerTextColor);
        }
        if ((headerBg = a.getDrawable(R.styleable.DatePicker_headerBackground)) != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                header.setBackground(headerBg);
            } else {
                header.setBackgroundDrawable(headerBg);
            }
        }
        a.recycle();
        this.mAnimator = (ViewAnimator)this.mContainer.findViewById(R.id.animator);
        this.mDayPickerView = (DayPickerView)this.mAnimator.findViewById(R.id.date_picker_day_picker);
        this.mDayPickerView.setFirstDayOfWeek(this.mFirstDayOfWeek);
        this.mDayPickerView.setMinDate(this.mMinDate.getTimeInMillis());
        this.mDayPickerView.setMaxDate(this.mMaxDate.getTimeInMillis());
        this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
        this.mDayPickerView.setOnDaySelectedListener(this.mOnDaySelectedListener);
        this.mYearPickerView = (YearPickerView)this.mAnimator.findViewById(R.id.date_picker_year_picker);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
        this.mYearPickerView.setYear(this.mCurrentDate.get(1));
        this.mYearPickerView.setOnYearSelectedListener(this.mOnYearSelectedListener);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mSelectYear = res.getString(R.string.select_year);
        this.onLocaleChanged(this.mCurrentLocale);
        this.setCurrentView(0);
    }

    @Nullable
    private ColorStateList applyLegacyColorFixes(@Nullable ColorStateList color) {
        int defaultColor;
        int activatedColor;
        if (color == null || Utils.colorHasState(color, 16843518)) {
            return color;
        }
        if (Utils.colorHasState(color, 0x10100A1)) {
            activatedColor = color.getColorForState(StateSet.get(10), 0);
            defaultColor = color.getColorForState(StateSet.get(8), 0);
        } else {
            activatedColor = color.getDefaultColor();
            TypedArray ta = this.mContext.obtainStyledAttributes(ATTRS_DISABLED_ALPHA);
            float disabledAlpha = ta.getFloat(0, 0.3f);
            defaultColor = this.multiplyAlphaComponent(activatedColor, disabledAlpha);
            ta.recycle();
        }
        if (activatedColor == 0 || defaultColor == 0) {
            return null;
        }
        int[][] stateSet = new int[][]{{16843518}, new int[0]};
        int[] colors = new int[]{activatedColor, defaultColor};
        return new ColorStateList((int[][])stateSet, colors);
    }

    private int multiplyAlphaComponent(int color, float alphaMod) {
        int srcRgb = color & 0xFFFFFF;
        int srcAlpha = color >> 24 & 0xFF;
        int dstAlpha = (int)((float)srcAlpha * alphaMod + 0.5f);
        return srcRgb | dstAlpha << 24;
    }

    @Override
    protected void onLocaleChanged(Locale locale) {
        TextView headerYear = this.mHeaderYear;
        if (headerYear == null) {
            return;
        }
        String datePattern = DateFormatFix.getBestDateTimePattern(this.mContext, locale, "EMMMd");
        if (Build.VERSION.SDK_INT >= 24) {
            this.mMonthDayFormat = new SimpleDateFormat(datePattern, locale);
            ((SimpleDateFormat)this.mMonthDayFormat).setContext(DisplayContext.CAPITALIZATION_FOR_STANDALONE);
            this.mYearFormat = new SimpleDateFormat("y", locale);
        } else {
            this.mMonthDayFormat = new java.text.SimpleDateFormat(datePattern, locale);
            this.mYearFormat = new java.text.SimpleDateFormat("y", locale);
        }
        this.mAccessibilityEventFormat = null;
        this.onCurrentDateChanged(false);
    }

    private void onCurrentDateChanged(boolean announce) {
        if (this.mHeaderYear == null) {
            return;
        }
        String year = this.mYearFormat.format(this.mCurrentDate.getTime());
        this.mHeaderYear.setText((CharSequence)year);
        String monthDay = this.mMonthDayFormat.format(this.mCurrentDate.getTime());
        this.mHeaderMonthDay.setText((CharSequence)monthDay);
        if (announce) {
            long millis = this.mCurrentDate.getTimeInMillis();
            int flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.mContext, (long)millis, (int)20);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mAnimator.announceForAccessibility((CharSequence)fullDateText);
            }
        }
    }

    private void setCurrentView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
                if (this.mCurrentView != viewIndex) {
                    this.mHeaderMonthDay.setActivated(true);
                    this.mHeaderYear.setActivated(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                if (Build.VERSION.SDK_INT < 16) break;
                this.mAnimator.announceForAccessibility((CharSequence)this.mSelectDay);
                break;
            }
            case 1: {
                int year = this.mCurrentDate.get(1);
                this.mYearPickerView.setYear(year);
                this.mYearPickerView.post(new Runnable(){

                    @Override
                    public void run() {
                        DatePickerCalendarDelegate.this.mYearPickerView.requestFocus();
                        View selected = DatePickerCalendarDelegate.this.mYearPickerView.getSelectedView();
                        if (selected != null) {
                            selected.requestFocus();
                        }
                    }
                });
                if (this.mCurrentView != viewIndex) {
                    this.mHeaderMonthDay.setActivated(false);
                    this.mHeaderYear.setActivated(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                if (Build.VERSION.SDK_INT < 16) break;
                this.mAnimator.announceForAccessibility((CharSequence)this.mSelectYear);
            }
        }
    }

    @Override
    public void init(int year, int monthOfYear, int dayOfMonth, DatePicker.OnDateChangedListener callBack) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, monthOfYear);
        this.mCurrentDate.set(5, dayOfMonth);
        this.onDateChanged(false, false);
        this.mDateChangedListener = callBack;
    }

    @Override
    public void updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        this.onDateChanged(false, true);
    }

    private void onDateChanged(boolean fromUser, boolean callbackToClient) {
        int year = this.mCurrentDate.get(1);
        if (callbackToClient && this.mDateChangedListener != null) {
            int monthOfYear = this.mCurrentDate.get(2);
            int dayOfMonth = this.mCurrentDate.get(5);
            this.mDateChangedListener.onDateChanged(this.mDelegator, year, monthOfYear, dayOfMonth);
        }
        this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
        this.mYearPickerView.setYear(year);
        this.onCurrentDateChanged(fromUser);
        if (fromUser) {
            this.tryVibrate();
        }
    }

    @Override
    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    @Override
    public int getMonth() {
        return this.mCurrentDate.get(2);
    }

    @Override
    public int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    @Override
    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) == this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.before(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(minDate);
            this.onDateChanged(false, true);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.setMinDate(minDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    @Override
    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) == this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.after(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(maxDate);
            this.onDateChanged(false, true);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.setMaxDate(maxDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mDayPickerView.setFirstDayOfWeek(firstDayOfWeek);
    }

    @Override
    public int getFirstDayOfWeek() {
        if (this.mFirstDayOfWeek != 0) {
            return this.mFirstDayOfWeek;
        }
        return this.mCurrentDate.getFirstDayOfWeek();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mContainer.setEnabled(enabled);
        this.mDayPickerView.setEnabled(enabled);
        this.mYearPickerView.setEnabled(enabled);
        this.mHeaderYear.setEnabled(enabled);
        this.mHeaderMonthDay.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.mContainer.isEnabled();
    }

    @Override
    public CalendarView getCalendarView() {
        throw new UnsupportedOperationException("Not supported by calendar-mode DatePicker");
    }

    @Override
    public void setCalendarViewShown(boolean shown) {
    }

    @Override
    public boolean getCalendarViewShown() {
        return false;
    }

    @Override
    public void setSpinnersShown(boolean shown) {
    }

    @Override
    public boolean getSpinnersShown() {
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        int year = this.mCurrentDate.get(1);
        int month = this.mCurrentDate.get(2);
        int day = this.mCurrentDate.get(5);
        int listPosition = -1;
        int listPositionOffset = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionOffset = this.mYearPickerView.getFirstPositionOffset();
        }
        return new DatePicker.AbstractDatePickerDelegate.SavedState(superState, year, month, day, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, listPosition, listPositionOffset);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof DatePicker.AbstractDatePickerDelegate.SavedState) {
            DatePicker.AbstractDatePickerDelegate.SavedState ss = (DatePicker.AbstractDatePickerDelegate.SavedState)state;
            this.mCurrentDate.set(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
            this.mMinDate.setTimeInMillis(ss.getMinDate());
            this.mMaxDate.setTimeInMillis(ss.getMaxDate());
            this.onCurrentDateChanged(false);
            int currentView = ss.getCurrentView();
            this.setCurrentView(currentView);
            int listPosition = ss.getListPosition();
            if (listPosition != -1) {
                if (currentView == 0) {
                    this.mDayPickerView.setPosition(listPosition);
                } else if (currentView == 1) {
                    int listPositionOffset = ss.getListPositionOffset();
                    this.mYearPickerView.setSelectionFromTop(listPosition, listPositionOffset);
                }
            }
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityEventFormat == null) {
            String pattern = DateFormatFix.getBestDateTimePattern(this.mContext, this.mCurrentLocale, "EMMMMdy");
            this.mAccessibilityEventFormat = Build.VERSION.SDK_INT >= 24 ? new SimpleDateFormat(pattern) : new java.text.SimpleDateFormat(pattern, this.mCurrentLocale);
        }
        String text = this.mAccessibilityEventFormat.format(this.mCurrentDate.getTime());
        event.getText().add(text);
    }

    public CharSequence getAccessibilityClassName() {
        return DatePicker.class.getName();
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private void tryVibrate() {
    }
}

