/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.Taboola;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.SessionData;
import com.taboola.android.utils.Logger;

public abstract class VerificationTest {
    private static final String TAG = VerificationTest.class.getSimpleName();
    private int id;
    private boolean isMandatory;

    public VerificationTest(int id, boolean isMandatory) {
        this.id = id;
        this.isMandatory = isMandatory;
    }

    public int getId() {
        return this.id;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public Bundle getKibanaBundle(String integrationType, String testName, String testOutput) {
        SessionData sessionData = Taboola.getTaboolaImpl().getIntegrationVerifier().getSessionData();
        Bundle kibanaBundle = new Bundle();
        try {
            kibanaBundle.putString("sdk_type", integrationType);
            kibanaBundle.putString("test_name", testName);
            kibanaBundle.putBoolean("is_mandatory", this.isMandatory);
            kibanaBundle.putString("test_output", testOutput);
            kibanaBundle.putString("publisher_id", sessionData.getPublisherId());
            kibanaBundle.putString("session_id", sessionData.getSessionId());
        }
        catch (Exception e) {
            Logger.e(TAG, "getKibanaBundle | e = " + e.getLocalizedMessage());
        }
        return kibanaBundle;
    }

    public abstract void execute(@Nullable Context var1, @Nullable Bundle var2, @NonNull TestResults var3);

    public abstract VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle var1);

    public static interface TestResults {
        public void onSuccess();

        public void onFail(boolean var1);

        public void onUnavailable();
    }
}

