/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.fsd;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.fsd.FSDManager;
import com.taboola.android.global_components.fsd.FSDReceiver;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

class FSDScheduler {
    private static final String TAG = FSDScheduler.class.getSimpleName();
    private FSDManager mFsdManager = Taboola.getTaboolaImpl().getFsdManager();
    private int mFirstScheduleTimeInHours = this.mFsdManager.getFirstScheduleTimeInHours(this.mFirstScheduleTimeInHours);
    private int mNextScheduleTimeAfterSuccessInDays = this.mFsdManager.getNextScheduleTimeAfterSuccessInDays(this.mNextScheduleTimeAfterSuccessInDays);
    private int mNextScheduleTimeAfterFailInDays = this.mFsdManager.getNextScheduleTimeAfterFailInDays(this.mNextScheduleTimeAfterFailInDays);
    private int mNumberOfRetries = this.mFsdManager.getNumberOfRetries(this.mNumberOfRetries);
    private int mRetriesIntervalTimeInHours = this.mFsdManager.getRetriesIntervalTimeInHours(this.mRetriesIntervalTimeInHours);
    private int mPercentageAllowedForStatistics = this.mFsdManager.getAllowedPercentageForStatistics(this.mPercentageAllowedForStatistics);

    FSDScheduler() {
    }

    void schedule(Context context) {
        try {
            if (context == null || this.mFsdManager == null) {
                return;
            }
            Calendar scheduleTime = Calendar.getInstance();
            long fsdLastSuccessTimestamp = SharedPrefUtil.getFsdSuccess(context, 0L);
            long fsdLastFailureTimestamp = SharedPrefUtil.getFsdFail(context, 0);
            long fsdNextRunTimestamp = SharedPrefUtil.getFsdNext(context, 0L);
            if (fsdNextRunTimestamp == 0L) {
                int randomNum = new Random().nextInt(101);
                Logger.d(TAG, "Random: " + randomNum);
                if (randomNum < this.mPercentageAllowedForStatistics) {
                    SharedPrefUtil.setFsdStatsEnabled(context, true);
                    this.mFsdManager.createAndSendFirstTimeLog(scheduleTime);
                } else {
                    SharedPrefUtil.setFsdStatsEnabled(context, false);
                }
                Logger.d(TAG, "schedule(): first time ever.");
                scheduleTime.add(11, new Random().nextInt(this.mFirstScheduleTimeInHours + 1));
            } else if (fsdLastFailureTimestamp == fsdLastSuccessTimestamp) {
                Logger.d(TAG, "schedule(): Alarm already set but did not fire yet");
                scheduleTime.setTimeInMillis(fsdNextRunTimestamp);
            } else if (System.currentTimeMillis() >= fsdNextRunTimestamp) {
                if (fsdLastSuccessTimestamp > fsdLastFailureTimestamp) {
                    Logger.d(TAG, "schedule(): Last time was success flow");
                    if (this.isDebugMode(context)) {
                        scheduleTime.add(13, 30);
                    } else {
                        scheduleTime.add(5, this.mNextScheduleTimeAfterSuccessInDays);
                    }
                } else {
                    int retries = SharedPrefUtil.getFsdRetries(context, 0);
                    if (retries <= this.mNumberOfRetries) {
                        Logger.d(TAG, "schedule(): Last time was failure - let's retry.");
                        if (retries == 1) {
                            scheduleTime.add(11, 1);
                        } else {
                            scheduleTime.add(11, this.mRetriesIntervalTimeInHours);
                        }
                    } else {
                        Logger.d(TAG, "schedule(): Last time was failure and num of retires exceeded!");
                        this.mFsdManager.addStats(System.currentTimeMillis(), "fsd_err_maxre", new String[0]);
                        SharedPrefUtil.setFsdRetry(context, 0);
                        scheduleTime.add(5, this.mNextScheduleTimeAfterFailInDays);
                    }
                }
            } else {
                this.mFsdManager.sendFsdStatsToKibana();
                scheduleTime.setTimeInMillis(fsdNextRunTimestamp);
            }
            if (this.isDebugMode(context)) {
                scheduleTime.setTimeInMillis(System.currentTimeMillis());
                scheduleTime.add(13, 30);
            }
            SharedPrefUtil.setFsdNext(context, scheduleTime.getTimeInMillis());
            Intent intent = FSDScheduler.getFSDIntent(context);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
            Logger.d(TAG, "Alarm set to: " + new Date(scheduleTime.getTimeInMillis()));
            this.scheduleFSD(context, scheduleTime, pendingIntent);
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }

    @NonNull
    static Intent getFSDIntent(Context ctx) {
        Intent intent = new Intent();
        intent.setClass(ctx, FSDReceiver.class);
        return intent;
    }

    private void scheduleFSD(Context ctx, Calendar c, PendingIntent pendingIntent) {
        AlarmManager am = (AlarmManager)ctx.getSystemService("alarm");
        if (am != null) {
            Logger.d(TAG, "Alarm set to run in " + (c.getTimeInMillis() - System.currentTimeMillis()) / 1000L + " seconds @ " + c.getTime());
            int ALARM_TYPE = 0;
            if (Build.VERSION.SDK_INT >= 23) {
                am.setExactAndAllowWhileIdle(ALARM_TYPE, c.getTimeInMillis(), pendingIntent);
            } else if (Build.VERSION.SDK_INT >= 19) {
                am.setExact(ALARM_TYPE, c.getTimeInMillis(), pendingIntent);
            } else {
                am.set(ALARM_TYPE, c.getTimeInMillis(), pendingIntent);
            }
        } else {
            Logger.d(TAG, "setFsdAlarm() | Alarm Manager is null");
        }
    }

    static void cancelScheduler(Context context) {
        try {
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            if (am != null) {
                am.cancel(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)FSDScheduler.getFSDIntent(context), (int)0x8000000));
            } else {
                Logger.d(TAG, "cancelScheduledFSD() | Alarm Manager is null");
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }

    private boolean isDebugMode(Context context) {
        if (this.mFsdManager == null || context == null) {
            return false;
        }
        return this.mFsdManager.getIsInDebugMode(false) && context.getPackageName().equals("com.taboola.testingsample");
    }
}

