/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.configuration;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.configuration.ConfigError;
import com.taboola.android.global_components.configuration.TaboolaConfigResponse;
import com.taboola.android.global_components.eventsmanager.EventsManager;
import com.taboola.android.global_components.gueh.GlobalUncaughtExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager {
    public static final String PUBLISHER = "publisher";
    public static final String KILL_SWITCH_ERROR_MESSAGE = "INTERNAL_1";
    public static final String TABOOLA_CONFIG = "taboolaConfig";
    public static final String KILL_SWITCH_KEY = "killSwitch";
    private static final String TAG = "ConfigManager";
    private static final String PLACEMENT_DEFAULT_KEY = "placementDefault";
    private static final String PLACEMENT_UNKNOWN_KEY = "placementUnknown";
    private static final String CONFIGURATION_URL_PATTERN = "https://cdn.taboola.com/mobile-config/%s/confV1_0/taboolaConfig.json?ui=%s&appv=%s&sdkv=%s&osv=%s";
    private static final String MASK_CONFIG_UID_PREFIX = "tci";
    private NetworkManager mNetworkManager;
    private Context mApplicationContext = TaboolaContextManager.getInstance().getApplicationContext();
    private JSONObject mCachedResponse;

    public ConfigManager(NetworkManager networkManager, final GlobalUncaughtExceptionHandler globalExceptionHandler, final EventsManager eventsManager) {
        this.mNetworkManager = networkManager;
        this.getConfigFromRemote(new TaboolaConfigResponse(){

            @Override
            public void onSuccess(HttpResponse response) {
                ConfigManager.this.loadConfig();
                ConfigManager.this.initializeFeaturesGlobal(globalExceptionHandler, eventsManager);
            }

            @Override
            public void onFail(ConfigError error) {
                Logger.e(ConfigManager.TAG, "TaboolaImpl | internalGlobalInit | TaboolaConfigResponse error: " + error);
            }
        });
    }

    public void initializeFeaturesGlobal(GlobalUncaughtExceptionHandler globalExceptionHandler, EventsManager eventsManager) {
        if (globalExceptionHandler != null) {
            globalExceptionHandler.toggle(this.getConfigValue("setGUEH", true));
        } else {
            Logger.e(TAG, "Trying to setup GUEH but it's null.");
        }
        if (eventsManager != null) {
            eventsManager.toggleEventsManager(this.getConfigValue("eventsManagerEnable", true));
            eventsManager.setsQueueMaxSize(this.getConfigValue("eventsManagerMaxQueue", eventsManager.getQueueMaxSize()));
        } else {
            Logger.e(TAG, "Trying to setup EventsManager, but it's null.");
        }
    }

    public boolean loadConfig() {
        return this.loadConfig(false);
    }

    private boolean loadConfig(boolean shouldLoadConfigIfAlreadyExists) {
        if (shouldLoadConfigIfAlreadyExists || this.mCachedResponse == null) {
            String config = SharedPrefUtil.getConfig(this.mApplicationContext);
            if (TextUtils.isEmpty((CharSequence)config)) {
                Logger.e(TAG, "Cached configuration is empty");
                return false;
            }
            this.mCachedResponse = this.parseJson(config);
        }
        return this.mCachedResponse != null;
    }

    public boolean reloadConfig() {
        return this.loadConfig(true);
    }

    public void setConfigDataFromRemoteWithPublisher(String publisherId) {
        String lastKnownPublisherId = SharedPrefUtil.getConfigPublisherId(this.mApplicationContext);
        if (TextUtils.isEmpty((CharSequence)lastKnownPublisherId)) {
            lastKnownPublisherId = "";
        }
        if (!TextUtils.isEmpty((CharSequence)publisherId) && !publisherId.equals(lastKnownPublisherId)) {
            SharedPrefUtil.setConfigPublisherId(this.mApplicationContext, publisherId);
            this.getConfigFromRemote();
        }
    }

    private void getConfigFromRemote() {
        this.getConfigFromRemote(null);
    }

    private void getConfigFromRemote(final TaboolaConfigResponse callback) {
        String configUrl;
        String publisher = SharedPrefUtil.getConfigPublisherId(this.mApplicationContext);
        if (TextUtils.isEmpty((CharSequence)publisher)) {
            Logger.d(TAG, "getConfigFromRemote | publisher is N/A. Will not fetch configuration.");
            return;
        }
        Log.d((String)TAG, (String)("getConfigFromRemote | publisher = " + publisher));
        HttpManager httpManager = this.mNetworkManager.getHttpManager();
        String configUid = SharedPrefUtil.getConfigUniqueId(this.mApplicationContext);
        if (TextUtils.isEmpty((CharSequence)configUid)) {
            configUid = UUID.randomUUID().toString();
            SharedPrefUtil.setConfigUniqueId(this.mApplicationContext, configUid);
        }
        try {
            configUrl = this.createConfigurationUrl(publisher, configUid);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onFail(new ConfigError(e.getMessage()));
            }
            return;
        }
        Logger.d(TAG, "getConfigFromRemote: " + configUrl);
        httpManager.get(configUrl, new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(HttpResponse response) {
                try {
                    new JSONObject(response.mMessage);
                }
                catch (JSONException e) {
                    ConfigManager.this.saveConfig("");
                    if (callback != null) {
                        callback.onFail(new ConfigError(e.getMessage()));
                    }
                    return;
                }
                ConfigManager.this.saveConfig(response.mMessage);
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

            @Override
            public void onError(HttpError error) {
                if (callback != null) {
                    callback.onFail(new ConfigError(error.mMessage));
                }
            }
        });
    }

    private String createConfigurationUrl(String publisher, String configUid) throws Exception {
        try {
            if (TextUtils.isEmpty((CharSequence)publisher)) {
                throw new Exception("Unable to create configuration URL");
            }
            return String.format(CONFIGURATION_URL_PATTERN, publisher, this.maskConfigUid(configUid), Uri.encode((String)SdkDetailsHelper.getAppVersion(this.mApplicationContext)), Uri.encode((String)"2.8.3"), Uri.encode((String)Build.VERSION.RELEASE));
        }
        catch (Exception e) {
            throw new Exception("Unable to create configuration URL");
        }
    }

    private String maskConfigUid(String configUid) {
        if (TextUtils.isEmpty((CharSequence)configUid)) {
            return "";
        }
        if (configUid.length() >= MASK_CONFIG_UID_PREFIX.length()) {
            return MASK_CONFIG_UID_PREFIX + configUid.substring(MASK_CONFIG_UID_PREFIX.length());
        }
        return configUid;
    }

    private void saveConfig(String config) {
        Logger.d(TAG, config);
        SharedPrefUtil.saveConfig(this.mApplicationContext, config);
    }

    @Nullable
    private JSONObject parseJson(String config) {
        try {
            JSONObject configJson = new JSONObject(config);
            return configJson.optJSONObject(TABOOLA_CONFIG);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("parseJson | JSONException: " + e.getMessage()));
            return null;
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)("parseJson | NullPointerException: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("parseJson | error: " + e.getMessage()));
            return null;
        }
    }

    public boolean getConfigValue(String placement, String key, boolean defaultValue) {
        String configValue = this.getConfigValue(placement, key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(configValue);
    }

    public String getConfigValue(String key, String defaultValue) {
        return this.getConfigValue(null, key, defaultValue);
    }

    public boolean getConfigValue(String key, boolean defaultValue) {
        return this.getConfigValue(null, key, defaultValue);
    }

    public String getConfigValue(String placement, String key, String defaultValue) {
        try {
            if (this.mCachedResponse != null) {
                String returnedValue;
                JSONObject placementJson = null;
                if (placement != null) {
                    placementJson = this.mCachedResponse.optJSONObject(placement);
                }
                if (placementJson != null && !TextUtils.isEmpty((CharSequence)(returnedValue = placementJson.optString(key, null)))) {
                    return returnedValue;
                }
                JSONObject defaultPlacementJson = this.mCachedResponse.optJSONObject(PLACEMENT_DEFAULT_KEY);
                if (defaultPlacementJson != null) {
                    return defaultPlacementJson.optString(key, defaultValue);
                }
            }
            return defaultValue;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getConfigValue | error: " + e.getMessage()));
            return defaultValue;
        }
    }

    public int getConfigValue(String key, int defaultValue) {
        String configValue = this.getConfigValue(null, key, String.valueOf(defaultValue));
        return Integer.valueOf(configValue);
    }

    public int getConfigValue(String placement, String key, int defaultValue) {
        String configValue = this.getConfigValue(placement, key, String.valueOf(defaultValue));
        return Integer.valueOf(configValue);
    }

    public void set(String key, String value) {
        this.set(null, key, value);
    }

    public void set(String key, boolean value) {
        this.set(key, String.valueOf(value));
    }

    public void set(String placement, String key, boolean value) {
        this.set(placement, key, String.valueOf(value));
    }

    public void set(String placement, String key, String value) {
        try {
            if (this.mCachedResponse == null) {
                this.mCachedResponse = new JSONObject();
            }
            if (!TextUtils.isEmpty((CharSequence)placement)) {
                JSONObject placementJson = this.mCachedResponse.optJSONObject(placement);
                if (placementJson == null) {
                    placementJson = new JSONObject();
                }
                placementJson.put(key, (Object)value);
                this.mCachedResponse.put(placement, (Object)placementJson);
            } else {
                JSONObject placementUnknownJson = this.mCachedResponse.optJSONObject(PLACEMENT_UNKNOWN_KEY);
                if (placementUnknownJson == null) {
                    placementUnknownJson = new JSONObject();
                }
                placementUnknownJson.put(key, (Object)value);
                this.mCachedResponse.put(PLACEMENT_UNKNOWN_KEY, (Object)placementUnknownJson);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("set | Error: " + e.getMessage()));
        }
    }

    @Nullable
    public String getConfigurationAsJsonString() {
        if (this.mCachedResponse == null) {
            return null;
        }
        try {
            return this.mCachedResponse.toString();
        }
        catch (Exception e) {
            Logger.e(TAG, "getConfigurationAsJsonString | " + e.getMessage());
            return "";
        }
    }
}

