/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsoluteLayout;
import com.taboola.android.CCTabHandler;
import com.taboola.android.GLHelper;
import com.taboola.android.OnScrollChangedListenerImpl;
import com.taboola.android.R;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.TaboolaWebView;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.configuration.PropertyResolver;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestIDs;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams_STD;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.listeners.TaboolaDetectAdEventsListener;
import com.taboola.android.listeners.TaboolaEventListener;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.listeners.TaboolaUserActionListener;
import com.taboola.android.utils.AssetUtil;
import com.taboola.android.utils.CcpaUtil;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.StringUtil;
import com.taboola.android.utils.TaboolaSerializable;
import com.taboola.android.utils.VisibilityUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

@Keep
public class TaboolaWidget
extends TaboolaWebView
implements TaboolaInterfaceComponent {
    private static final String TAG = TaboolaWidget.class.getSimpleName();
    private static final String HTML_TEMPLATE_FILE_NAME = "template.html";
    public static final int INVALID_HEIGHT = -3;
    public static final int DUMMY_HEIGHT = 2;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final String ABOUT_BLANK_URL = "about:blank";
    private static int sMaxWidgetSizeGpu = 0;
    private CCTabHandler mCCTabHandler = null;
    private TaboolaEventListener mEventListener;
    private TaboolaDetectAdEventsListener mTaboolaDetectAdEventsListener;
    private MediationEventListener mMediationEventListener;
    private boolean mHasDispatchedLoadEvent = false;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private boolean mShouldKeepDependencies = false;
    private boolean shouldCheckCacheSize = false;
    private boolean mIsItemClickEnabled;
    private String mPublisher;
    private String mMode;
    private String mPlacement;
    private String mPageType;
    private String mTargetType;
    private String mPageId;
    private String mPageUrl;
    private String mWidgetStyle;
    private String mFramework;
    private String mViewID;
    private String mProgressBarColor;
    private float mProgressBarDuration = -1.0f;
    @Nullable
    private String mMediatedVia;
    private boolean mIsScrollEnabled;
    private boolean mIsAutoResizeHeight;
    private int mWidgetMaxHeight;
    private int mScreenMaxHeight;
    private Handler mInvalidationHandler;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private OnScrollChangedListenerImpl mScrollChangedListenerImpl;
    private boolean shouldIgnoreScrollEvents = false;
    private OnAttachStateChangeListenerImpl mOnAttachStateChangeListener;
    private HashMap<String, String> mFetchContentParams = new HashMap();
    private Integer mInitialHeight;
    private boolean mForceHeightMode;
    private boolean mShouldForceHeight;
    private boolean mShouldHideScrollBars;
    private boolean mShouldAllowFileAccessInWebview = false;
    private boolean mDisableLocationCollection;
    private boolean mShouldKeepViewId = true;
    private boolean mShouldAutoCollapseOnError = true;
    private boolean mShouldMobileLoaderSendDetailedErrorCodes = false;
    private boolean mCheckHiddenWidget = true;
    private List<Map> mPassedActionList;
    private int mOrientation;
    private ConfigManager mConfigManager;
    private AdvertisingIdInfo mAdvertisingIdInfo;
    private HashMap<String, String> mWebViewExtraProperties;
    private String mUserId;
    private Runnable mRedoResizeForGpu;
    private String mCcpaOptout;

    public TaboolaWidget(Context context) {
        super(context);
        this.initWidgetSettings();
    }

    public TaboolaWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWidgetSettings();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    public TaboolaWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWidgetSettings();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    private void initWidgetSettings() {
        this.mCCTabHandler = new CCTabHandler(this.getContext());
        this.mWebViewExtraProperties = new HashMap();
        this.mConfigManager = Taboola.getTaboolaImpl().loadAndGetConfigManager();
        this.mAdvertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
        TaboolaJs.getInstance().setLogLevel(Logger.getLogLevel());
        this.updateMaxGPUSize();
        this.setDefValues();
        this.setSaveEnabled(true);
        this.setWillNotDraw(false);
        this.setBackgroundColor(0);
        this.getSettings().setLoadsImagesAutomatically(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setUseWideViewPort(true);
        this.setWebViewClient(this.getWebViewClient());
        this.setWebChromeClient(this.getWebChromeClient());
        this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        this.getSettings().setCacheMode(-1);
        this.getSettings().setAllowFileAccess(this.mShouldAllowFileAccessInWebview);
        this.setLayerType(0, null);
        if (Build.VERSION.SDK_INT >= 19 && Logger.getLogLevel() <= 3) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        Logger.d(TAG, "initWebView :: initialized WebView");
        this.initTaboolaJS();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initTaboolaJS() {
        Context context = this.getContext();
        TaboolaJs.getInstance().init(context.getApplicationContext(), true);
        CookieManager.getInstance().setAcceptCookie(true);
        this.updateScrollBehaviour();
        TaboolaJs.getInstance().registerWebView(this, new OnRenderListener(){

            @Override
            public void onRenderSuccessful(WebView webView, String placementName, int height) {
                if (Build.VERSION.SDK_INT <= 19) {
                    TaboolaWidget.this.startInvalidationOnScrollEvents();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaWidget.this.invalidateWebView();
                        }
                    }, 3000L);
                }
                Logger.d(TAG, "onRenderSuccessful: " + placementName);
                TaboolaWidget.this.dispatchLoadSuccessful();
            }

            @Override
            public void onRenderFailed(WebView webView, String placementName, String errorMessage) {
                Logger.e(TAG, "onRenderFailed: " + placementName + " " + errorMessage);
                TaboolaWidget.this.dispatchLoadFailed(errorMessage);
            }
        });
        TaboolaJs.getInstance().setOnResizeListener(this, new OnResizeListener(){

            @Override
            public void onResize(WebView webView, String placementName, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.resizeWidget(heightPx);
            }

            @Override
            public void onOrientationChange(WebView webView, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.onOrientationChange(heightPx);
            }
        });
    }

    protected void onOrientationChange(int heightPx) {
        Log.d((String)TAG, (String)("onOrientationChange() called with: heightPx = [" + heightPx + "]"));
        this.mOrientation = 0;
        this.calculateWidgetMaxHeight();
        this.resizeWidget(heightPx);
        this.post(new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidate();
                TaboolaJs.getInstance().scrollToTop(TaboolaWidget.this);
                if (TaboolaWidget.this.mScrollviewParent != null) {
                    TaboolaWidget.this.mScrollviewParent.scrollTo(0, 0);
                }
            }
        });
    }

    @Override
    protected void clearDependencies() {
        super.clearDependencies();
        this.mShouldKeepDependencies = false;
        if (this.mOnAttachStateChangeListener != null) {
            this.mOnAttachStateChangeListener.clear();
            this.mOnAttachStateChangeListener = null;
        }
        if (this.mScrollChangedListenerImpl != null) {
            this.mScrollChangedListenerImpl.removeListener(this.mOnScrollChangedListener);
        }
        this.clearScrollChangeListener();
        TaboolaJs.getInstance().unregisterWebView(this);
        TaboolaJs.getInstance().setOnClickListener(this, null);
        TaboolaJs.getInstance().setTaboolaUserActionListener(null);
        if (IntegrationVerifier.isEnabled()) {
            Taboola.getTaboolaImpl().getIntegrationVerifier().getTestsManager().getMethodCallOrderTracker().clearTrackedMethods(1);
            Taboola.getTaboolaImpl().getIntegrationVerifier().clearStatusReport();
        }
        this.mEventListener = null;
        this.mTaboolaDetectAdEventsListener = null;
        this.mMediationEventListener = null;
        this.updateContent(null);
    }

    private void parseXmlAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TaboolaWidget, 0, 0);
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_autoResizeHeight, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scrollEnabled, this.mIsScrollEnabled));
        this.setProgressBarEnabled(a.getBoolean(R.styleable.TaboolaWidget_progressBarEnabled, this.mProgressBarEnabled));
        this.setProgressBarColor(a.getColor(R.styleable.TaboolaWidget_progressBarColor, -1));
        this.setProgressBarDuration(a.getFloat(R.styleable.TaboolaWidget_progressBarDuration, this.mProgressBarDuration));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_itemClickEnabled, this.mIsItemClickEnabled));
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_auto_resize_height, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scroll_enabled, this.mIsScrollEnabled));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_item_click_enabled, this.mIsItemClickEnabled));
        String publisher = a.getString(R.styleable.TaboolaWidget_tb_publisher);
        String mode = a.getString(R.styleable.TaboolaWidget_tb_mode);
        String placement = a.getString(R.styleable.TaboolaWidget_tb_placement);
        String pageType = a.getString(R.styleable.TaboolaWidget_tb_page_type);
        String targetType = a.getString(R.styleable.TaboolaWidget_tb_target_type);
        String pageUrl = a.getString(R.styleable.TaboolaWidget_tb_url);
        if (publisher != null) {
            this.setPublisher(publisher);
        }
        if (mode != null) {
            this.setMode(mode);
        }
        if (placement != null) {
            this.setPlacement(placement);
        }
        if (pageType != null) {
            this.setPageType(pageType);
        }
        if (targetType != null) {
            this.setTargetType(targetType);
        }
        if (pageUrl != null) {
            this.setPageUrl(pageUrl);
        }
        a.recycle();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Logger.d(TAG, "onAttachedToWindow");
        this.notifyUpdateHeight();
        this.mCCTabHandler.bindCustomTabsService();
        if (this.mScrollviewParent != null && this.mOnAttachStateChangeListener == null) {
            this.mOnAttachStateChangeListener = new OnAttachStateChangeListenerImpl(this);
            this.mScrollviewParent.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.mOnAttachStateChangeListener);
            this.mShouldKeepDependencies = true;
        }
        this.calculateWidgetMaxHeight();
        if (IntegrationVerifier.isEnabled() && this.mInitialHeight != null) {
            Bundle bundle = new Bundle();
            bundle.putInt("WidgetLayoutParamsVerif.heightParam", this.mInitialHeight.intValue());
            Taboola.getTaboolaImpl().getIntegrationVerifier().verify(new VerificationRequest(bundle, new TestIDs(12)));
        }
    }

    public void notifyUpdateHeight() {
        TaboolaJs.getInstance().notifyUpdateHeight(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.mShouldKeepDependencies) {
            this.clearDependencies();
        }
        Logger.d(TAG, "onDetachedFromWindow");
        this.mCCTabHandler.unbindCustomTabsService();
        super.onDetachedFromWindow();
    }

    public void onDestroy() {
        this.clearDependencies();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mCCTabHandler.isChromeTabLaunched() && visibility == 0) {
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdClosed();
            }
            this.mCCTabHandler.setChromeTabLaunched(false);
        }
    }

    public TaboolaWidget fetchContent() {
        Point size;
        if (Taboola.getTaboolaImpl().isKillSwitchEnabled(this.getPlacement())) {
            this.dispatchLoadFailed("INTERNAL_1");
            Logger.e(TAG, "fetchContent | INTERNAL_1");
            return this;
        }
        if (this.mInitialHeight == null) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            boolean hasLayoutParams = layoutParams != null;
            this.mInitialHeight = hasLayoutParams ? layoutParams.height : -3;
            if (this.mInitialHeight < 0) {
                if (hasLayoutParams) {
                    layoutParams.height = 2;
                } else {
                    layoutParams = new ViewGroup.LayoutParams(-1, 2);
                }
                this.setLayoutParams(layoutParams);
            }
        }
        if (TaboolaJs.getInstance().isSdkMonitorEnabled() && (size = TaboolaJs.getInstance().getWidgetMonitorSize()) != null) {
            int height = size.y;
            int width = size.x;
            ViewGroup.LayoutParams params = this.getLayoutParams();
            if (params != null) {
                params.height = height;
                params.width = width;
            } else {
                params = new ViewGroup.LayoutParams(width, height);
            }
            this.setLayoutParams(params);
        }
        if (IntegrationVerifier.isEnabled()) {
            Taboola.getTaboolaImpl().getIntegrationVerifier().getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(1, "fetchContent");
            Bundle crawlUrlBundle = new Bundle();
            crawlUrlBundle.putSerializable("crawlingUrlTest_key_crawling_url", (Serializable)((Object)this.mPageUrl));
            crawlUrlBundle.putInt("integration_verifier_key_integrationType", 1);
            Taboola.getTaboolaImpl().getIntegrationVerifier().verify(new VerificationRequest(this.getContext(), crawlUrlBundle, new TestIDs(8)));
        }
        if (!this.mShouldKeepViewId || this.mViewID == null) {
            this.setViewId(null);
        }
        Logger.d(TAG, "publisher[" + this.mPublisher + "] mode[" + this.mMode + "] placement[" + this.mPlacement + "] pageType[" + this.mPageType + "] pageUrl[" + this.mPageUrl + "] viewID[" + this.mViewID + "]");
        this.initJsExtraProperties();
        if (IntegrationVerifier.isEnabled()) {
            this.verifyConfigParams();
        }
        this.notifyFetchContent();
        String prevUrl = this.getUrl();
        if (TextUtils.equals((CharSequence)ABOUT_BLANK_URL, (CharSequence)prevUrl)) {
            prevUrl = null;
        }
        if (this.mIsOnline && !TextUtils.isEmpty((CharSequence)prevUrl) && this.mShouldKeepViewId) {
            this.mHasDispatchedLoadEvent = false;
            this.reload();
        } else if (this.hasMinimalAttributes()) {
            this.clearWebView();
            this.mHasDispatchedLoadEvent = false;
            this.loadWebView();
        } else {
            String message = "Required parameters are not set";
            Logger.e(TAG, message);
            this.dispatchLoadFailed(message);
        }
        return this;
    }

    private void initJsExtraProperties() {
        this.mWebViewExtraProperties.put("isUsedInTaboolaWidget", "true");
        this.mWebViewExtraProperties.put("mediatedVia", this.mMediatedVia);
        this.mWebViewExtraProperties.put("allowNonOrganicClickOverride", this.mShouldAllowNonOrganicClickOverride ? "true" : "false");
        if (!TextUtils.isEmpty((CharSequence)this.mCcpaOptout)) {
            this.mWebViewExtraProperties.put("cdns", this.mCcpaOptout);
        }
        if (this.mEnableHorizontalScroll) {
            this.mWebViewExtraProperties.put("enableHorizontalScroll", "true");
        }
        try {
            if (this.mPassedActionList != null) {
                JSONArray jsonArray = new JSONArray(this.mPassedActionList);
                this.mWebViewExtraProperties.put("initActions", jsonArray.toString());
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "unable to pass actions", e);
        }
        String clKey = PropertyResolver.resolve(ExtraProperty.DISABLE_LOCATION_COLLECTION);
        if (!this.mWebViewExtraProperties.containsKey(clKey)) {
            this.mWebViewExtraProperties.put(clKey, String.valueOf(this.mDisableLocationCollection));
        }
        this.mWebViewExtraProperties.put(PropertyResolver.resolve(ExtraProperty.AUTO_COLLAPSE_ON_ERROR), String.valueOf(this.mShouldAutoCollapseOnError));
        this.mWebViewExtraProperties.put(PropertyResolver.resolve(ExtraProperty.DETAILED_ERROR_CODES), String.valueOf(this.mShouldMobileLoaderSendDetailedErrorCodes));
        this.mWebViewExtraProperties.put(PropertyResolver.resolve(ExtraProperty.VISIBLE_CHECK_HIDDEN_WIDGET), String.valueOf(this.mCheckHiddenWidget));
        TaboolaJs.getInstance().setExtraProperties(this, this.mWebViewExtraProperties, this.getPlacement());
    }

    private void verifyConfigParams() {
        Bundle verifyJsParamsBundle = new Bundle();
        verifyJsParamsBundle.putSerializable("publisherConfigurationTest_key_configuration_params", (Serializable)new PublisherConfigParams_STD(this.mPublisher, this.mMode, this.mPlacement, this.mPageType, this.mTargetType));
        verifyJsParamsBundle.putInt("integration_verifier_key_integrationType", 1);
        Taboola.getTaboolaImpl().getIntegrationVerifier().verify(new VerificationRequest(verifyJsParamsBundle, new TestIDs(6, 7)));
    }

    private void notifyFetchContent() {
        if (TaboolaJs.getInstance().isSdkMonitorEnabled()) {
            this.mFetchContentParams.put("publisher", this.mPublisher);
            this.mFetchContentParams.put("mode", this.mMode);
            this.mFetchContentParams.put("placement", this.mPlacement);
            this.mFetchContentParams.put("pageType", this.mPageType);
            this.mFetchContentParams.put("targetType", this.mTargetType);
            this.mFetchContentParams.put("pageId", this.mPageId);
            this.mFetchContentParams.put("pageUrl", this.mPageUrl);
            this.mFetchContentParams.put("viewID", this.mViewID);
            this.mFetchContentParams.put("framework", this.mFramework);
            this.mFetchContentParams.put("customTabsSupported", String.valueOf(this.mCCTabHandler.isCustomTabsSupported()));
            this.mFetchContentParams.put("progressBarColor", this.mProgressBarColor);
            this.mFetchContentParams.put("progressBarEnabled", String.valueOf(this.mProgressBarEnabled));
            if (this.mScrollviewParent != null) {
                this.mFetchContentParams.put("scrollviewParent", this.mScrollviewParent.getClass().getSimpleName());
            }
            this.mFetchContentParams.put("shouldInterceptScroll", String.valueOf(this.mShouldInterceptScroll));
            this.mFetchContentParams.put("enableHorizontalScroll", String.valueOf(this.mEnableHorizontalScroll));
            this.mFetchContentParams.put("isAutoResizeHeight", String.valueOf(this.mIsAutoResizeHeight));
            this.mFetchContentParams.put("maxScreenHeight", String.valueOf(this.mScreenMaxHeight));
            this.mFetchContentParams.put("maxWidgetSizeGpu", String.valueOf(sMaxWidgetSizeGpu));
            this.mFetchContentParams.put("isScrollEnabled", String.valueOf(this.mIsScrollEnabled));
            if (this.getLayoutParams() != null) {
                ViewGroup.LayoutParams params = this.getLayoutParams();
                String output = params.getClass().getCanonicalName() + "= { width=" + MonitorUtils.sizeToString(params.width) + ", height=" + MonitorUtils.sizeToString(params.height) + " }";
                this.mFetchContentParams.put("layoutParams", output);
            }
            if (this.mUserId != null) {
                this.mFetchContentParams.put("unified_id", this.mUserId);
            }
            TaboolaJs.getInstance().sendFetchContentParamsToMonitor(this, this.mPlacement, this.mFetchContentParams);
        }
    }

    public TaboolaWidget refresh() {
        this.fetchContent();
        return this;
    }

    public TaboolaWidget reset() {
        this.setDefValues();
        this.clearWebView();
        return this;
    }

    private void clearWebView() {
        this.loadUrl(ABOUT_BLANK_URL);
        this.clearHistory();
    }

    private void loadWebView() {
        if (this.mIsOnline) {
            this.loadWebViewOnline();
            return;
        }
        String baseUrl = "https://cdn.taboola.com/mobile-sdk/init/";
        String html = String.format(AssetUtil.getHtmlTemplateFileContent(this.getContext(), HTML_TEMPLATE_FILE_NAME), this.mPublisher, this.mWidgetStyle, this.mPageType, this.mPageId, this.mPageUrl, this.mMode, this.mPlacement, this.mFramework, this.mTargetType, this.mPublisher, this.mViewID);
        Logger.d(TAG, "loadWebView html:\n" + html);
        this.mHasDispatchedLoadEvent = false;
        this.loadDataWithBaseURL(baseUrl, html, "text/html", "utf-8", null);
    }

    private void dispatchLoadSuccessful() {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidReceiveAd(this);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdLoaded();
            }
            this.postGlobalNotification("TABOOLA_DID_RECEIVE_AD", this, null);
        }
    }

    private void dispatchLoadFailed(String description) {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidFailAd(description);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdFailedToLoad(description);
            }
            this.postGlobalNotification("TABOOLA_DID_FAIL_AD", this, description);
        }
    }

    private void postGlobalNotification(String message, TaboolaWidget taboolaWidget, @Nullable Object value) {
        Intent intent = new Intent("com.taboola.android.GLOBAL_NOTIFICATIONS_KEY");
        intent.putExtra("GLOBAL_NOTIFICATIONS_MESSAGES_KEY", message);
        TaboolaSerializable taboolaSerializable = new TaboolaSerializable();
        taboolaSerializable.setTaboolaWidget(taboolaWidget);
        intent.putExtra("GLOBAL_NOTIFICATIONS_WIDGET_KEY", (Serializable)taboolaSerializable);
        switch (message) {
            case "TABOOLA_VIEW_RESIZED": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", ((Integer)value).intValue());
                break;
            }
            case "TABOOLA_DID_FAIL_AD": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", (String)value);
            }
        }
        LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
        Logger.d(TAG, "post global notification " + message);
    }

    private void resizeWidget(int heightPx) {
        Integer viewHeight;
        Logger.d(TAG, "resizeWidget(" + heightPx + ")");
        if (sMaxWidgetSizeGpu == 0) {
            Logger.d(TAG, "resizeWidget: postponing resizing until max widget size is resolved");
            this.scheduleResizeWidget(heightPx);
            return;
        }
        this.removeCallbacks(this.mRedoResizeForGpu);
        boolean forceAutoResize = false;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (this.mInitialHeight < 0) {
            viewHeight = this.mInitialHeight;
            forceAutoResize = true;
        } else {
            viewHeight = layoutParams != null ? Integer.valueOf(layoutParams.height) : null;
        }
        int heightLimit = viewHeight != null && viewHeight > 0 ? Math.min(viewHeight, this.mWidgetMaxHeight) : this.mWidgetMaxHeight;
        int actualHeightPx = heightPx;
        if (heightPx > heightLimit) {
            actualHeightPx = heightLimit;
            forceAutoResize = true;
            this.setScrollEnabled(true);
        }
        if (forceAutoResize || this.isAutoResizeHeight()) {
            ViewGroup.LayoutParams params = layoutParams;
            int previousHeight = 0;
            if (params != null) {
                previousHeight = params.height;
            }
            if (actualHeightPx == previousHeight) {
                Log.d((String)TAG, (String)String.format("resizeWidget() for placement \"%s\" is same height as before: %d", StringUtil.getSafeString(this.getPlacement()), actualHeightPx));
                return;
            }
            Logger.d(TAG, "resized widget height to " + actualHeightPx + " px, was before " + (params != null ? Integer.valueOf(params.height) : "no param"));
            if (params != null) {
                params.height = actualHeightPx;
            } else {
                params = new ViewGroup.LayoutParams(-1, actualHeightPx);
            }
            this.setLayoutParams(params);
            this.postGlobalNotification("TABOOLA_VIEW_RESIZED", this, actualHeightPx);
            if (this.getTaboolaEventListener() != null) {
                this.getTaboolaEventListener().taboolaViewResizeHandler(this, actualHeightPx);
            }
        }
        if (this.shouldCheckCacheSize && this.isCacheTooSmall(actualHeightPx)) {
            this.setLayerType(0, null);
            this.shouldCheckCacheSize = false;
            this.fetchContent();
        }
    }

    private void scheduleResizeWidget(final int heightPx) {
        this.removeCallbacks(this.mRedoResizeForGpu);
        this.mRedoResizeForGpu = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.resizeWidget(heightPx);
            }
        };
        this.postDelayed(this.mRedoResizeForGpu, 500L);
    }

    private boolean isCacheTooSmall(int heightPx) {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        if (wm != null) {
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            long bmpSize = metrics.widthPixels * heightPx * 4;
            long maxCache = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumDrawingCacheSize();
            return bmpSize > maxCache;
        }
        return false;
    }

    private boolean onItemClick(String clickUrl, boolean isOrganic) {
        Logger.d(TAG, "onItemClick() inner called with: clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdClicked();
        }
        this.postGlobalNotification("TABOOLA_ITEM_DID_CLICK", this, null);
        if (this.isItemClickEnabled() && this.getTaboolaEventListener() != null) {
            Logger.d(TAG, "onItemClick() passed to listener with: clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
            return this.getTaboolaEventListener().taboolaViewItemClickHandler(clickUrl, isOrganic);
        }
        return true;
    }

    public WebViewClient getWebViewClient() {
        WebViewClient webViewClient = new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                TaboolaWidget.this.dispatchLoadFailed(description);
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError error) {
                this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), req.getUrl().toString());
            }
        };
        Logger.d(TAG, "getWebViewClient :: initialized");
        return webViewClient;
    }

    public WebChromeClient getWebChromeClient() {
        return new WebChromeClient(){
            private final String TAG = WebChromeClient.class.getSimpleName();

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Logger.d(this.TAG, "onJsAlert :: " + message);
                return super.onJsAlert(view, url, message, result);
            }

            public boolean onConsoleMessage(ConsoleMessage cm) {
                Logger.d(this.TAG, cm.message() + ", source: " + cm.sourceId() + " From line " + cm.lineNumber());
                return true;
            }
        };
    }

    public String getOptionalWidgetStyle() {
        return this.mWidgetStyle;
    }

    public TaboolaWidget setOptionalWidgetStyle(String newCSSStyle) {
        this.mWidgetStyle = newCSSStyle;
        return this;
    }

    public TaboolaWidget setMediatedVia(String mediatedVia) {
        this.mMediatedVia = mediatedVia;
        return this;
    }

    public boolean isScrollEnabled() {
        return this.mIsScrollEnabled;
    }

    public TaboolaWidget setScrollEnabled(boolean isScrollEnabled) {
        this.mIsScrollEnabled = isScrollEnabled;
        this.updateScrollBehaviour();
        return this;
    }

    public boolean isAutoResizeHeight() {
        return this.mIsAutoResizeHeight;
    }

    public TaboolaWidget setAutoResizeHeight(boolean shouldAutoResizeHeight) {
        this.mIsAutoResizeHeight = shouldAutoResizeHeight;
        return this;
    }

    public void setInterceptScroll(boolean shouldInterceptScroll) {
        this.mShouldInterceptScroll = shouldInterceptScroll;
        if (this.mShouldInterceptScroll) {
            this.setAutoResizeHeight(false);
            this.setScrollEnabled(true);
        }
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public TaboolaWidget setPublisher(String publisherId) {
        if (publisherId != null && !publisherId.isEmpty()) {
            this.mPublisher = publisherId;
            this.mConfigManager.setConfigDataFromRemoteWithPublisher(this.mPublisher);
            if (IntegrationVerifier.isEnabled()) {
                Taboola.getTaboolaImpl().getIntegrationVerifier().getSessionData().setPublisherId(this.mPublisher);
            }
        }
        return this;
    }

    public TaboolaWidget setViewId(String viewID) {
        this.mViewID = !TextUtils.isEmpty((CharSequence)viewID) ? viewID : Long.toString(System.currentTimeMillis());
        return this;
    }

    public TaboolaWidget setTag(@NonNull String tag) {
        TaboolaJs.getInstance().setTag(this, tag);
        return this;
    }

    public String getMode() {
        return this.mMode;
    }

    public TaboolaWidget setMode(String mode) {
        if (mode != null && !mode.isEmpty()) {
            this.mMode = mode;
        }
        return this;
    }

    public String getPlacement() {
        return this.mPlacement;
    }

    public TaboolaWidget setPlacement(String placement) {
        if (placement != null && !placement.isEmpty()) {
            this.mPlacement = placement;
            this.initializeFeatures(this.mPlacement);
        }
        return this;
    }

    public String getPageType() {
        return this.mPageType;
    }

    public TaboolaWidget setPageType(String pageType) {
        if (pageType != null && !pageType.isEmpty()) {
            this.mPageType = pageType;
        }
        return this;
    }

    public String getTargetType() {
        return this.mPageType;
    }

    public TaboolaWidget setTargetType(String targetType) {
        if (targetType != null && !targetType.isEmpty()) {
            this.mTargetType = targetType;
        }
        return this;
    }

    public String getPageUrl() {
        return this.mPageUrl;
    }

    public TaboolaWidget setPageUrl(String pageUrl) {
        if (pageUrl != null && !pageUrl.isEmpty()) {
            this.mPageUrl = pageUrl;
        }
        return this;
    }

    public String getPageId() {
        return this.mPageId;
    }

    public TaboolaWidget setPageId(String pageId) {
        if (pageId != null && !pageId.isEmpty()) {
            this.mPageId = pageId;
        }
        return this;
    }

    public TaboolaWidget setProgressBarEnabled(boolean isEnabled) {
        this.mProgressBarEnabled = isEnabled;
        return this;
    }

    public TaboolaWidget setProgressBarColor(@ColorInt int progressColor) {
        if (progressColor != -1) {
            this.mProgressBarColor = StringUtil.colorToHexString(progressColor);
        }
        return this;
    }

    public TaboolaWidget setProgressBarDuration(float duration) {
        if (duration >= 0.0f) {
            this.mProgressBarDuration = duration;
        } else {
            Logger.w(TAG, "setProgressBarDuration | Duration cannot be negative. Using default duration: " + this.mProgressBarDuration);
        }
        return this;
    }

    public void showProgressBar() {
        if (this.mProgressBarEnabled) {
            TaboolaJs.getInstance().showProgressBar(this);
        } else {
            Logger.w(TAG, "progress bar is manually disabled");
        }
    }

    public TaboolaEventListener getTaboolaEventListener() {
        return this.mEventListener;
    }

    public TaboolaWidget setTaboolaEventListener(TaboolaEventListener eventListener) {
        this.mEventListener = eventListener;
        this.updateClickListener();
        return this;
    }

    public TaboolaWidget setTaboolaUserActionListener(TaboolaUserActionListener listener) {
        TaboolaJs.getInstance().setTaboolaUserActionListener(listener);
        return this;
    }

    private void updateClickListener() {
        TaboolaJs.getInstance().setOnClickListener(this, new TaboolaOnClickListener(){

            @Override
            public boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic) {
                Logger.d(TAG, "onItemClick() called from TaboolaWidget with: placementName = [" + placementName + "], itemId = [" + itemId + "], clickUrl = [" + clickUrl + "], isOrganic = [" + isOrganic + "]");
                return TaboolaWidget.this.onItemClick(clickUrl, isOrganic);
            }
        });
    }

    public TaboolaWidget setTaboolaDetectAdEventsListener(TaboolaDetectAdEventsListener taboolaDetectAdEventsListener) {
        this.mTaboolaDetectAdEventsListener = taboolaDetectAdEventsListener;
        return this;
    }

    public TaboolaWidget setMediationEventListener(MediationEventListener mediationEventListener) {
        this.mMediationEventListener = mediationEventListener;
        return this;
    }

    public void setLogLevel(int logLevel) {
        TaboolaJs.getInstance().setLogLevel(logLevel);
    }

    public int getTextZoom() {
        return this.getSettings().getTextZoom();
    }

    public TaboolaWidget setTextZoom(int textZoom) {
        this.getSettings().setTextZoom(textZoom);
        return this;
    }

    @Deprecated
    public boolean isItemClickEnabled() {
        return this.mIsItemClickEnabled;
    }

    @Deprecated
    public void setItemClickEnabled(boolean mIsItemClickEnabled) {
        this.mIsItemClickEnabled = mIsItemClickEnabled;
    }

    public TaboolaWidget setExtraProperties(HashMap<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(Taboola.getTaboolaImpl().getIntegrationVerifier(), 1, extraProperties);
        if (extraProperties == null || extraProperties.isEmpty()) {
            return this;
        }
        Iterator<String> iterator = extraProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = extraProperties.get(key);
            boolean shouldRemoved = value != null;
            this.mFetchContentParams.put(key, value);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case UNRECOGNIZABLE: {
                    Logger.d(TAG, "setExtraProperties key = " + key + " will be sent to rbox");
                    shouldRemoved = false;
                    break;
                }
                case ALLOW_NON_ORGANIC_OVERRIDE_PROP: {
                    this.mShouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue(this.mPlacement, "allowNonOrganicClickOverride", Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldAllowNonOrganicClickOverride);
                    break;
                }
                case USE_ONLINE_TEMPLATE: {
                    this.mIsOnline = this.mConfigManager.getConfigValue(this.mPlacement, "useOnlineTemplate", Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mIsOnline);
                    break;
                }
                case KEEP_DEPENDENCIES_PROP: {
                    this.mShouldKeepDependencies = this.mConfigManager.getConfigValue(this.mPlacement, "keepDependencies", Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldKeepDependencies);
                    break;
                }
                case ENABLE_HORIZONTAL_SCROLL_PROP: {
                    this.mEnableHorizontalScroll = this.mConfigManager.getConfigValue(this.mPlacement, "enableHorizontalScroll", Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mEnableHorizontalScroll);
                    break;
                }
                case FORCE_FIXED_HEIGHT: {
                    this.mShouldForceHeight = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldForceHeight);
                    this.mWebViewExtraProperties.put(key, String.valueOf(this.mShouldForceHeight));
                    break;
                }
                case HIDE_SCROLLING_BARS: {
                    this.mShouldHideScrollBars = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldHideScrollBars);
                    this.syncScrollBarsWithFlag();
                    break;
                }
                case ALLOW_FILE_ACCESS: {
                    this.mShouldAllowFileAccessInWebview = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldAllowFileAccessInWebview);
                    this.getSettings().setAllowFileAccess(this.mShouldAllowFileAccessInWebview);
                    break;
                }
                case CCPA_DNS: {
                    String ccpaDefValue = CcpaUtil.validateAndReturnCcpaValue(value);
                    this.mCcpaOptout = this.mConfigManager.getConfigValue(this.mPlacement, key, ccpaDefValue);
                    this.mConfigManager.set(this.mPlacement, key, this.mCcpaOptout);
                    break;
                }
                case DISABLE_LOCATION_COLLECTION: {
                    this.mDisableLocationCollection = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mDisableLocationCollection);
                    this.mWebViewExtraProperties.put(key, String.valueOf(this.mDisableLocationCollection));
                    break;
                }
                case KEEP_VIEW_ID: {
                    this.mShouldKeepViewId = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldKeepViewId);
                    break;
                }
                case AUTO_COLLAPSE_ON_ERROR: {
                    this.mShouldAutoCollapseOnError = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldAutoCollapseOnError);
                    this.mWebViewExtraProperties.put(key, String.valueOf(this.mShouldAutoCollapseOnError));
                    break;
                }
                case DETAILED_ERROR_CODES: {
                    this.mShouldMobileLoaderSendDetailedErrorCodes = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mShouldMobileLoaderSendDetailedErrorCodes);
                    this.mWebViewExtraProperties.put(key, String.valueOf(this.mShouldMobileLoaderSendDetailedErrorCodes));
                    break;
                }
                case VISIBLE_CHECK_HIDDEN_WIDGET: {
                    this.mCheckHiddenWidget = this.mConfigManager.getConfigValue(this.mPlacement, key, Boolean.parseBoolean(value));
                    this.mConfigManager.set(this.mPlacement, key, this.mCheckHiddenWidget);
                    this.mWebViewExtraProperties.put(key, String.valueOf(this.mCheckHiddenWidget));
                    break;
                }
                default: {
                    shouldRemoved = false;
                }
            }
            if (shouldRemoved) {
                iterator.remove();
                continue;
            }
            this.mConfigManager.set(this.mPlacement, key, this.mConfigManager.getConfigValue(this.mPlacement, key, value));
        }
        this.mWebViewExtraProperties.put("isUsedInTaboolaWidget", "true");
        this.mWebViewExtraProperties.putAll(extraProperties);
        return this;
    }

    private void syncScrollBarsWithFlag() {
        this.setVerticalScrollBarEnabled(!this.mShouldHideScrollBars);
        this.setHorizontalScrollBarEnabled(!this.mShouldHideScrollBars);
    }

    @Deprecated
    public TaboolaWidget setOptionalPageCommands(HashMap<String, String> arrCommands) {
        return this.setExtraProperties(arrCommands);
    }

    @Deprecated
    public TaboolaWidget setOptionalModeCommands(HashMap<String, String> arrCommands) {
        return this.setExtraProperties(arrCommands);
    }

    @Deprecated
    public void pushCommands(HashMap<String, String> arrCommands) {
        this.setExtraProperties(arrCommands);
    }

    private void setDefValues() {
        this.mPublisher = "";
        this.mMode = "";
        this.mPlacement = "";
        this.mPageType = "";
        this.mTargetType = "mix";
        this.mPageId = "auto";
        this.mPageUrl = "";
        this.mWidgetStyle = "";
        this.mFramework = "mobile-sdk";
        this.mIsScrollEnabled = false;
        this.mIsItemClickEnabled = true;
        this.mIsAutoResizeHeight = true;
        this.mShouldForceHeight = true;
        if (!this.mShouldKeepViewId) {
            this.setViewId(null);
        }
        Logger.d(TAG, "setDefValues :: initialize fields with default values");
    }

    private boolean hasMinimalAttributes() {
        return !TextUtils.isEmpty((CharSequence)this.mPublisher) && !TextUtils.isEmpty((CharSequence)this.mMode) && !TextUtils.isEmpty((CharSequence)this.mPlacement) && !TextUtils.isEmpty((CharSequence)this.mPageUrl) && !TextUtils.isEmpty((CharSequence)this.mPageType);
    }

    private void updateMaxGPUSize() {
        Logger.d(TAG, "updateMaxGPUSize :: called");
        try {
            if (this.mScreenMaxHeight == 0) {
                this.mScreenMaxHeight = SdkDetailsHelper.getDisplayHeight(this.getContext());
                Logger.d(TAG, "mScreenMaxHeight " + this.mScreenMaxHeight);
            }
            this.mWidgetMaxHeight = this.mScreenMaxHeight;
            if (sMaxWidgetSizeGpu == 0) {
                sMaxWidgetSizeGpu = GLHelper.getCachedMaxWidgetSize(this.getContext());
                if (sMaxWidgetSizeGpu != 0) {
                    this.mWidgetMaxHeight = Math.min(sMaxWidgetSizeGpu, SdkDetailsHelper.getDisplayHeight(this.getContext()) * 2);
                } else {
                    this.invalidateWebView();
                    GLHelper.getMaxWidgetSize(this, new GLHelper.onMaxWidgetSizeRetrievedCallback(){

                        @Override
                        public void onMaxWidgetSizeRetrieved(int size) {
                            sMaxWidgetSizeGpu = size;
                            TaboolaWidget.this.mWidgetMaxHeight = Math.min(sMaxWidgetSizeGpu, SdkDetailsHelper.getDisplayHeight(TaboolaWidget.this.getContext()) * 2);
                            Logger.d(TAG, "onMaxWidgetSizeRetrieved(): mWidgetMaxHeight = [" + TaboolaWidget.this.mWidgetMaxHeight + "], sMaxWidgetSizeGpu = [" + sMaxWidgetSizeGpu + "]");
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.mWidgetMaxHeight = 500;
            Log.e((String)TAG, (String)("updateMaxGPUSize: " + e.getMessage()));
        }
    }

    private void updateScrollBehaviour() {
        if (!this.mShouldHideScrollBars) {
            this.setVerticalScrollBarEnabled(this.mIsScrollEnabled);
        }
        Logger.d(TAG, "updateScrollBehaviour :: scroll enabled " + this.mIsScrollEnabled + ", scroll shown: " + !this.mShouldHideScrollBars);
    }

    private void clearScrollChangeListener() {
        if (this.mScrollChangedListenerImpl != null) {
            this.mScrollChangedListenerImpl.clear();
            this.mScrollChangedListenerImpl = null;
        }
    }

    private void stopInvalidationOnScrollEvents() {
    }

    private void startInvalidationOnScrollEvents() {
        if (this.mInvalidationHandler == null) {
            this.mInvalidationHandler = new Handler();
        }
        long delayMillisShort = 500L;
        long delayMillisLong = 5000L;
        final Runnable shortScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.shouldIgnoreScrollEvents = false;
                TaboolaWidget.this.invalidateWebView();
            }
        };
        final Runnable longScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidateWebView();
            }
        };
        if (this.mScrollChangedListenerImpl == null) {
            this.mScrollChangedListenerImpl = new OnScrollChangedListenerImpl((View)this);
        } else {
            this.mScrollChangedListenerImpl.removeListener(this.mOnScrollChangedListener);
        }
        if (this.mOnScrollChangedListener == null) {
            this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    if (!TaboolaWidget.this.shouldIgnoreScrollEvents) {
                        TaboolaWidget.this.shouldIgnoreScrollEvents = true;
                        if (TaboolaWidget.this.mInvalidationHandler != null) {
                            TaboolaWidget.this.mInvalidationHandler.postDelayed(shortScrollRunnable, 500L);
                            TaboolaWidget.this.mInvalidationHandler.postDelayed(longScrollRunnable, 5000L);
                        }
                    }
                }
            };
        }
        this.mScrollChangedListenerImpl.addListener(this.mOnScrollChangedListener);
    }

    public void invalidateWebView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidate();
                Logger.d(TAG, "invalidateWebView executed");
            }
        });
    }

    private void calculateWidgetMaxHeight() {
        int orientation = this.getResources().getConfiguration().orientation;
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.mScreenMaxHeight = SdkDetailsHelper.getDisplayHeight(this.getContext()) * 2;
            Logger.d(TAG, "calculateWidgetMaxHeight() called, mScreenMaxHeight = [" + this.mScreenMaxHeight + "]");
            if (sMaxWidgetSizeGpu > 0) {
                this.mWidgetMaxHeight = Math.min(sMaxWidgetSizeGpu, this.mScreenMaxHeight);
                Logger.d(TAG, "calculateWidgetMaxHeight() called, mWidgetMaxHeight = [" + this.mWidgetMaxHeight + "]");
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mShouldForceHeight) {
            this.calculateWidgetMaxHeight();
            int[] calcArr = this.calculateMeasureSize(widthMeasureSpec, heightMeasureSpec);
            int heightLimit = this.mWidgetMaxHeight > 0 ? this.mWidgetMaxHeight : this.mScreenMaxHeight;
            int measuredHeightPixels = calcArr[1];
            if (measuredHeightPixels > heightLimit) {
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                Logger.d(TAG, "onMeasure() called before with: heightMeasureSpec = [" + heightMeasureSpec + "], heightSpecMode = " + MonitorUtils.measureSpecToString(heightSpecMode) + "], heightLimit = [" + heightLimit + "], measuredHeightPixels = [" + measuredHeightPixels + "]");
                int measuredHeight = heightLimit;
                int measuredWidth = calcArr[0];
                this.setMeasuredDimension(measuredWidth, measuredHeight);
                Logger.d(TAG, "onMeasure(): setMeasuredDimension called with: measuredWidth = [" + measuredWidth + "], measuredHeight = [" + measuredHeight + "]");
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measuredHeight, (int)heightSpecMode);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @NonNull
    int[] calculateMeasureSize(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)child.getLayoutParams();
            int childRight = lp.x + child.getMeasuredWidth();
            int childBottom = lp.y + child.getMeasuredHeight();
            maxWidth = Math.max(maxWidth, childRight);
            maxHeight = Math.max(maxHeight, childBottom);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        int measuredWidth = TaboolaWidget.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)0);
        int measuredHeight = TaboolaWidget.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)0);
        return new int[]{measuredWidth, measuredHeight};
    }

    private void loadWebViewOnline() {
        try {
            this.mHasDispatchedLoadEvent = false;
            String baseUrl = "https://cdn.taboola.com/shared/templateJS.html?pageType=" + Uri.encode((String)this.mPageType) + "&pageId=" + Uri.encode((String)this.mPageId) + "&publisher=" + Uri.encode((String)this.mPublisher) + "&DIV_ID=taboola&targetType=" + Uri.encode((String)this.mTargetType) + "&styleRules=" + Uri.encode((String)this.mWidgetStyle) + "&viewID=" + this.mViewID + "&pageUrl=" + Uri.encode((String)this.mPageUrl) + "&placement=" + Uri.encode((String)this.mPlacement) + "&mode=" + Uri.encode((String)this.mMode);
            if (this.mProgressBarEnabled) {
                if (!TextUtils.isEmpty((CharSequence)this.mProgressBarColor)) {
                    baseUrl = baseUrl + "&pcolor=" + Uri.encode((String)this.mProgressBarColor);
                }
                if (this.mProgressBarDuration != -1.0f) {
                    baseUrl = baseUrl + "&pduration=" + this.mProgressBarDuration;
                }
            }
            this.loadUrl(baseUrl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("loadWebView failed " + e.toString()), (Throwable)e);
        }
    }

    public void updateAction(int actionType, String actionString) {
        TaboolaJs.getInstance().updatePassedAction(actionType, actionString, this);
    }

    public TaboolaWidget setAction(int actionType, String data) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("action", String.valueOf(actionType));
        tempMap.put("data", data);
        if (this.mPassedActionList == null) {
            this.mPassedActionList = new ArrayList<Map>();
        }
        this.mPassedActionList.add(tempMap);
        return this;
    }

    public TaboolaWidget setUserId(String userId) {
        this.mUserId = userId;
        TaboolaJs.getInstance().setUserId(this, userId);
        return this;
    }

    public void updateContent(TaboolaUpdateContentListener updateContentListener) {
        TaboolaJs.getInstance().updateContent(this, updateContentListener);
    }

    private void initializeFeatures(String placement) {
        if (!TextUtils.isEmpty((CharSequence)placement)) {
            this.mShouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue(placement, "allowNonOrganicClickOverride", this.mShouldAllowNonOrganicClickOverride);
            this.mIsOnline = this.mConfigManager.getConfigValue(placement, "useOnlineTemplate", this.mIsOnline);
            this.mShouldKeepDependencies = this.mConfigManager.getConfigValue(placement, "keepDependencies", this.mShouldKeepDependencies);
            Log.d((String)"AutomationLog", (String)("initializeFeatures mShouldKeepDependencies is = " + this.mShouldKeepDependencies));
            this.mEnableHorizontalScroll = this.mConfigManager.getConfigValue(placement, "enableHorizontalScroll", this.mEnableHorizontalScroll);
            this.mShouldHideScrollBars = this.mConfigManager.getConfigValue(placement, "hideScrollingBars", this.mShouldHideScrollBars);
            this.syncScrollBarsWithFlag();
            this.mCcpaOptout = this.mConfigManager.getConfigValue(placement, "cdns", null);
            this.mDisableLocationCollection = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.DISABLE_LOCATION_COLLECTION), this.mDisableLocationCollection);
            this.mShouldKeepViewId = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.KEEP_VIEW_ID), this.mShouldKeepViewId);
            this.mShouldForceHeight = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.FORCE_FIXED_HEIGHT), this.mShouldForceHeight);
            this.mShouldAllowFileAccessInWebview = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.ALLOW_FILE_ACCESS), this.mShouldAllowFileAccessInWebview);
            this.getSettings().setAllowFileAccess(this.mShouldAllowFileAccessInWebview);
            if (this.mAdvertisingIdInfo != null) {
                if (this.mWebViewExtraProperties == null) {
                    this.mWebViewExtraProperties = new HashMap();
                }
                this.mWebViewExtraProperties.put("user_opt_out", this.mAdvertisingIdInfo.isLimitedAdTrackingEnabled() ? "true" : "false");
            }
            this.mShouldAutoCollapseOnError = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.AUTO_COLLAPSE_ON_ERROR), this.mShouldAutoCollapseOnError);
            this.mShouldMobileLoaderSendDetailedErrorCodes = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.DETAILED_ERROR_CODES), this.mShouldMobileLoaderSendDetailedErrorCodes);
            this.mCheckHiddenWidget = this.mConfigManager.getConfigValue(placement, PropertyResolver.resolve(ExtraProperty.VISIBLE_CHECK_HIDDEN_WIDGET), this.mCheckHiddenWidget);
        }
    }

    static class OnAttachStateChangeListenerImpl
    implements View.OnAttachStateChangeListener {
        WeakReference<TaboolaWidget> mWidgetWeakReference;

        OnAttachStateChangeListenerImpl(TaboolaWidget taboolaWidget) {
            if (this.mWidgetWeakReference == null) {
                this.mWidgetWeakReference = new WeakReference<TaboolaWidget>(taboolaWidget);
            }
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            if (this.mWidgetWeakReference != null && this.mWidgetWeakReference.get() != null) {
                ((TaboolaWidget)this.mWidgetWeakReference.get()).clearDependencies();
            }
        }

        public void clear() {
            this.mWidgetWeakReference.clear();
            this.mWidgetWeakReference = null;
        }
    }
}

