/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;

public class CCTabHandler {
    private static final String TAG = CCTabHandler.class.getSimpleName();
    private static final String CUSTOM_TAB_PACKAGE_NAME = "com.android.chrome";
    private Context mContext;
    private boolean mIsCustomTabsSupported;
    private boolean mIsChromeTabLaunched = false;
    private boolean mIsContextActivity = false;
    private CustomTabsClient mCustomTabsClient = null;
    private CustomTabsSession mCustomTabsSession = null;
    private CustomTabsServiceConnection mCustomTabsServiceConnection = null;

    public CCTabHandler(Context context) {
        if (!OnClickHelper.areChromeCustomTabsSupported(context)) {
            this.mIsCustomTabsSupported = false;
            Logger.d(TAG, "CCTabHelper cannot be activated without CCTab code compiled with app.");
        } else {
            this.mIsCustomTabsSupported = true;
            this.mContext = context;
            this.mIsContextActivity = context instanceof Activity;
            if (!this.mIsContextActivity) {
                Logger.w(TAG, "Widget should be created using Activity context if possible");
            }
        }
    }

    public void bindCustomTabsService() {
        if (this.mIsCustomTabsSupported) {
            try {
                this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

                    public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                        CCTabHandler.this.mCustomTabsClient = client;
                        if (CCTabHandler.this.mCustomTabsClient != null) {
                            CCTabHandler.this.mCustomTabsClient.warmup(0L);
                        }
                    }

                    public void onServiceDisconnected(ComponentName name) {
                        CCTabHandler.this.mCustomTabsClient = null;
                    }
                };
                CustomTabsClient.bindCustomTabsService((Context)this.mContext, (String)CUSTOM_TAB_PACKAGE_NAME, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
            }
            catch (Exception e) {
                Logger.e(TAG, "bindCustomTabsService :: failed bind custom tab service : " + e.toString());
            }
        }
    }

    public void unbindCustomTabsService() {
        if (this.mIsCustomTabsSupported) {
            if (this.mCustomTabsServiceConnection == null) {
                return;
            }
            if (this.mIsContextActivity) {
                try {
                    this.mContext.unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
                }
                catch (Exception e) {
                    Logger.e(TAG, "unbindCustomTabsService :: failed to unbind custom tab service : " + e.toString());
                }
            }
            this.mCustomTabsServiceConnection = null;
            this.mCustomTabsSession = null;
            this.mCustomTabsClient = null;
        }
    }

    private CustomTabsSession getSession() {
        if (this.mIsCustomTabsSupported) {
            if (this.mCustomTabsClient == null) {
                this.mCustomTabsSession = null;
            } else if (this.mCustomTabsSession == null) {
                this.mCustomTabsSession = this.mCustomTabsClient.newSession(null);
            }
        }
        return this.mCustomTabsSession;
    }

    private void openUrlInTabsOrBrowser(String url, @Nullable MediationEventListener mediationEventListener) {
        if (this.mIsCustomTabsSupported) {
            try {
                if (this.mIsCustomTabsSupported && this.mIsContextActivity) {
                    this.openChromeTab(url, mediationEventListener);
                } else {
                    this.openNativeBrowser(url, mediationEventListener);
                }
            }
            catch (Exception e) {
                Logger.e(TAG, "openUrlInTabsOrBrowser :: failed to open url " + e.toString());
            }
        }
    }

    private void openChromeTab(String url, @Nullable MediationEventListener mediationEventListener) {
        if (this.mIsCustomTabsSupported) {
            if (this.mIsChromeTabLaunched) {
                return;
            }
            if (mediationEventListener != null) {
                mediationEventListener.onAdOpened();
            }
            Logger.d(TAG, "openChromeTab :: opening ad in a ChromeTab");
            this.mIsChromeTabLaunched = true;
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.getSession());
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl(this.mContext, Uri.parse((String)url));
        }
    }

    private void openNativeBrowser(String url, @Nullable MediationEventListener mediationEventListener) {
        if (this.mIsCustomTabsSupported) {
            if (mediationEventListener != null) {
                mediationEventListener.onAdLeftApplication();
            }
            Logger.d(TAG, "openNativeBrowser :: opening add");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            if (!this.mIsContextActivity) {
                intent.addFlags(0x10000000);
                Logger.d(TAG, "Widget is not using Activity context, so browser will be opened with Intent.FLAG_ACTIVITY_NEW_TASK flag");
            }
            this.mContext.startActivity(intent);
        }
    }

    public boolean isCustomTabsSupported() {
        return this.mIsCustomTabsSupported;
    }

    public boolean isChromeTabLaunched() {
        return this.mIsChromeTabLaunched;
    }

    public void setChromeTabLaunched(boolean isChromeTabLaunched) {
        this.mIsChromeTabLaunched = isChromeTabLaunched;
    }
}

