package com.taboola.android.js;

import android.support.annotation.Keep;
import android.webkit.WebView;

/**
 * Listener to be called when recommendations have succeeded or failed
 * (called separately for each placement)
 */
@Keep
public interface OnRenderListener {
    /**
     *
     * @param webView the view showing Taboola recommendations
     * @param placementName the name of the placement
     * @param height css screen
     */
    void onRenderSuccessful(WebView webView, String placementName, int height);

    void onRenderFailed(WebView webView, String placementName, String errorMessage);
}