/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.time_window.TimeWindowUtil;

@RequiresApi(api=21)
public class ScheduledNotificationRenderingRestrictionsUtil {
    private static final String TAG = ScheduledNotificationRenderingRestrictionsUtil.class.getSimpleName();
    private final Context context;
    private final SharedLocalStorage sharedLocalStorage;
    private final ScheduledNotificationsLocalStorage notificationLocalStore;
    private final TBScheduledNotificationAnalyticsManager analyticsManager;

    public ScheduledNotificationRenderingRestrictionsUtil(@NonNull Context context, @NonNull SharedLocalStorage sharedLocalStorage, @NonNull ScheduledNotificationsLocalStorage notificationLocalStore, @NonNull TBScheduledNotificationAnalyticsManager analyticsManager) {
        this.context = context;
        this.sharedLocalStorage = sharedLocalStorage;
        this.notificationLocalStore = notificationLocalStore;
        this.analyticsManager = analyticsManager;
    }

    public boolean isNotificationRenderingRestricted(ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups engagementGroup) {
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups.NotificationsConfig config = engagementGroup.getNotificationsConfig();
        if (!this.areNetworkRestrictionsMet(config.isShouldFetchOnlyOverWifi())) {
            Log.i((String)TAG, (String)("isNotificationRenderingRestricted: shouldFetchOnlyOverWifi = " + config.isShouldFetchOnlyOverWifi()));
            return true;
        }
        if (this.isNotificationBlockedByUser()) {
            Log.i((String)TAG, (String)"isNotificationRenderingRestricted: user blocked notifications on the system lvl");
            return true;
        }
        if (ScheduledNotificationRenderingRestrictionsUtil.isTriggerPerDayMaxCountReached(config.getMaxRenderCountPerDay(), this.notificationLocalStore.getCountOfRenderedNotificationsToday())) {
            Log.i((String)TAG, (String)"isNotificationRenderingRestricted: notification is not shown because of max shown notification limit was reached");
            return true;
        }
        if (!ScheduledNotificationRenderingRestrictionsUtil.didIntervalPass(this.notificationLocalStore.getLastShownNotificationTimestamp(), config.getMinIntervalBetweenRenderMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"isNotificationRenderingRestricted: notification is not shown because min interval between renders not reached");
            return true;
        }
        if (TimeWindowUtil.isBlockedByAllowedTimeWindows(config.getAllowedTimeWindows())) {
            Log.i((String)TAG, (String)"isNotificationRenderingRestricted: Notification is not shown because of allow time windows set in the config");
            return true;
        }
        return false;
    }

    public boolean didJobTriggerIntervalPass(long jobTriggerIntervalMs) {
        return ScheduledNotificationRenderingRestrictionsUtil.didIntervalPass(this.notificationLocalStore.getRefreshedTimestamp(), jobTriggerIntervalMs, System.currentTimeMillis());
    }

    public static boolean didIntervalPass(long lastShownTimestamp, long minTriggerInterval, long currentTime) {
        return currentTime - lastShownTimestamp > minTriggerInterval;
    }

    public boolean isNotificationBlockedByUser() {
        boolean isBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(this.context, "Scheduled News");
        boolean isBlockedBySystem = this.sharedLocalStorage.isNotificationBlockBySystem();
        this.analyticsManager.sendCheckNotificationDisabledStatusEvent(isBlockedByUser);
        this.sharedLocalStorage.setIsNotificationBlockBySystem(isBlockedByUser);
        if (isBlockedByUser) {
            if (!isBlockedBySystem) {
                this.analyticsManager.sendNotificationDisabledBySystemEvent();
                this.sharedLocalStorage.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (isBlockedBySystem) {
            this.analyticsManager.sendNotificationEnabledBySystemEvent();
            this.sharedLocalStorage.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    private boolean areNetworkRestrictionsMet(boolean wifiOnlyModeConfigFlag) {
        Boolean wifiOnlyModeRuntimeFlag = this.notificationLocalStore.isWifiOnlyModeRuntimeFlag();
        if (wifiOnlyModeRuntimeFlag != null) {
            if (wifiOnlyModeRuntimeFlag.booleanValue()) {
                return this.isWifiConnectionAvailable();
            }
            return true;
        }
        if (wifiOnlyModeConfigFlag) {
            return this.isWifiConnectionAvailable();
        }
        return true;
    }

    private boolean isWifiConnectionAvailable() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.isWifiConnectionAvailableAfterOreo();
        }
        return this.isWifiConnectionAvailableBeforeOreo();
    }

    @RequiresApi(api=23)
    private boolean isWifiConnectionAvailableAfterOreo() {
        Network network;
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (cm != null && (network = cm.getActiveNetwork()) != null) {
            NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
            if (capabilities != null) {
                Log.i((String)TAG, (String)("isWifiConnectionAvailableAfterOreo: " + capabilities.toString()));
            }
            return capabilities != null && capabilities.hasTransport(1);
        }
        return false;
    }

    @RequiresApi(api=21)
    private boolean isWifiConnectionAvailableBeforeOreo() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (cm != null) {
            NetworkInfo info = cm.getActiveNetworkInfo();
            return info != null && info.isConnected() && info.getType() == 1;
        }
        return false;
    }

    public static boolean isTriggerPerDayMaxCountReached(int maxAllowedCount, int alreadyShownCount) {
        if (maxAllowedCount == -1) {
            return false;
        }
        return alreadyShownCount >= maxAllowedCount;
    }
}

