/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.layout_model;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.plus.notifications.scheduled.layout_model.AbstractNotificationsLayoutModel;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreNotificationsLayoutConfig;

public class ReadMoreLayoutModel
extends AbstractNotificationsLayoutModel {
    private static final String TAG = ReadMoreLayoutModel.class.getSimpleName();
    private static final String LAYOUT_COLLAPSED_READ_MORE_STRING = "layout_collapsed_read_more";
    private static final String LAYOUT_EXPANDED_READ_MORE_STRING = "layout_expanded_read_more";
    private static final int MIN_ITEMS_COUNT = 1;
    private static final int MAX_ITEMS_COUNT = 1;
    private CollapsedLayout collapsedLayout;
    private ExpandedLayout expandedLayout;
    private ReadMoreNotificationsLayoutConfig.LayoutSpecificProperties layoutSpecificConfigs;
    private boolean isReadMoreFeatureEnabled;

    public static ReadMoreLayoutModel determineNotificationLayout(@NonNull ReadMoreNotificationsLayoutConfig config, @IntRange(from=1L) int availableItemCount, boolean isReadMoreFeatureEnabled) {
        if (availableItemCount < 1) {
            throw new IllegalArgumentException("Item count must be greater than 0");
        }
        ReadMoreLayoutModel readMoreLayoutModel = new ReadMoreLayoutModel();
        readMoreLayoutModel.setLayoutSpecificConfigs(config.getLayoutSpecificProperties());
        readMoreLayoutModel.setReadMoreFeatureEnabled(isReadMoreFeatureEnabled);
        CollapsedLayout preferredCollapsedLayout = CollapsedLayout.parseLayout(config.getPreferredCollapsedReadMoreLayout());
        ExpandedLayout preferredExpandedLayout = ExpandedLayout.parseLayout(config.getPreferredExpandedReadMoreLayout());
        if (preferredCollapsedLayout.getMinNumberOfItems() <= availableItemCount && preferredExpandedLayout.getMinNumberOfItems() <= availableItemCount) {
            readMoreLayoutModel.setCollapsedLayout(preferredCollapsedLayout);
            readMoreLayoutModel.setExpandedLayout(preferredExpandedLayout);
            return readMoreLayoutModel;
        }
        readMoreLayoutModel.setCollapsedLayout(CollapsedLayout.getDefaultLayout());
        readMoreLayoutModel.setExpandedLayout(ExpandedLayout.getDefaultLayout());
        return readMoreLayoutModel;
    }

    @Override
    @NonNull
    JsonElement getJsonObject() {
        JsonObject jsonElement = new JsonObject();
        jsonElement.add("collapsedLayout", this.collapsedLayout.getJsonObject());
        jsonElement.add("expandedLayout", this.expandedLayout.getJsonObject());
        jsonElement.add("collapseLayoutSpecificConfig", this.gson.toJsonTree((Object)this.getLayoutSpecificConfigs().getLayoutCollapsedReadMore()));
        jsonElement.add("expandedLayoutSpecificConfig", this.gson.toJsonTree((Object)this.getLayoutSpecificConfigs().getLayoutExpandedReadMore()));
        return jsonElement;
    }

    public CollapsedLayout getCollapsedLayout() {
        return this.collapsedLayout;
    }

    private void setCollapsedLayout(CollapsedLayout collapsedLayout) {
        this.collapsedLayout = collapsedLayout;
    }

    public ExpandedLayout getExpandedLayout() {
        return this.expandedLayout;
    }

    private void setExpandedLayout(ExpandedLayout expandedLayout) {
        this.expandedLayout = expandedLayout;
    }

    public ReadMoreNotificationsLayoutConfig.LayoutSpecificProperties getLayoutSpecificConfigs() {
        return this.layoutSpecificConfigs;
    }

    private void setLayoutSpecificConfigs(ReadMoreNotificationsLayoutConfig.LayoutSpecificProperties layoutSpecificConfigs) {
        this.layoutSpecificConfigs = layoutSpecificConfigs;
    }

    public boolean isReadMoreFeatureEnabled() {
        return this.isReadMoreFeatureEnabled;
    }

    private void setReadMoreFeatureEnabled(boolean readMoreFeatureEnabled) {
        this.isReadMoreFeatureEnabled = readMoreFeatureEnabled;
    }

    public static enum ExpandedLayout {
        ReadMoreExpanded("layout_expanded_read_more");

        private final String layoutStringKey;
        private final int minNumberOfItems;
        private final int maxNumberOfItems;

        private ExpandedLayout(String layoutStringKey) {
            this.layoutStringKey = layoutStringKey;
            this.minNumberOfItems = 1;
            this.maxNumberOfItems = 1;
        }

        static ExpandedLayout parseLayout(String preferredExpandedLayoutString) {
            if (ReadMoreLayoutModel.LAYOUT_EXPANDED_READ_MORE_STRING.equals(preferredExpandedLayoutString)) {
                return ReadMoreExpanded;
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Expanded layout key. Using default");
            return ExpandedLayout.getDefaultLayout();
        }

        static ExpandedLayout getDefaultLayout() {
            return ReadMoreExpanded;
        }

        public String getLayoutStringKey() {
            return this.layoutStringKey;
        }

        int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        @NonNull
        public String toString() {
            return this.getLayoutStringKey();
        }

        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty("layout", this.layoutStringKey);
            jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
            jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
            return jsonElement;
        }
    }

    public static enum CollapsedLayout {
        ReadMoreCollapsed("layout_collapsed_read_more");

        private final String layoutStringKey;
        private final int minNumberOfItems;
        private final int maxNumberOfItems;

        private CollapsedLayout(String layoutStringKey) {
            this.layoutStringKey = layoutStringKey;
            this.minNumberOfItems = 1;
            this.maxNumberOfItems = 1;
        }

        static CollapsedLayout parseLayout(String preferredCollapsedLayoutString) {
            if (ReadMoreLayoutModel.LAYOUT_COLLAPSED_READ_MORE_STRING.equals(preferredCollapsedLayoutString)) {
                return ReadMoreCollapsed;
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
            return CollapsedLayout.getDefaultLayout();
        }

        static CollapsedLayout getDefaultLayout() {
            return ReadMoreCollapsed;
        }

        public String getLayoutStringKey() {
            return this.layoutStringKey;
        }

        int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        @NonNull
        public String toString() {
            return this.getLayoutStringKey();
        }

        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty("layout", this.layoutStringKey);
            jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
            jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
            return jsonElement;
        }
    }
}

