/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementTypeAdapter;
import com.taboola.android.plus.common.AbstractLocalStorage;
import com.taboola.android.plus.notifications.scheduled.NotificationContentState;
import com.taboola.android.plus.notifications.scheduled.TBContent;
import com.taboola.android.utils.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScheduledNotificationsLocalStorage
extends AbstractLocalStorage {
    private static final String TAG = ScheduledNotificationsLocalStorage.class.getSimpleName();
    public static final String SCHEDULED_NOTIFICATIONS_SHARED_PREFS_FILE_NAME = "tb_notification_manager";
    private static final String SHARED_PREFS_KEY_TB_CONTENT = "tb_notification_content";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE = "notification_content_state";
    private static final String SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP = "tb_notification_refreshed_timestamp";
    private static final String SHARED_PREFS_KEY_PREVIOUS_STATE = "previous_state";
    private static final String SHARED_PREFS_KEY_UI_MODE = "ui_mode";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "notification_blocked_by_config_event";
    public static final String SHARED_PREFS_KEY_SCHEDULED_NOTIFICATIONS_EXTRA_PROPERTIES = "taboola_plus_extra_properties";
    public static final String SHARED_PREFS_KEY_TB_ICON_ID = "tb_notification_icon_id";
    public static final String SHARED_PREFS_KEY_APPLICATION_NAME = "tb_notification_application_name";
    private static final String SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME = "last_content_refresh_event_time";
    private static final String SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME = "last_auto_next_item_event_time";
    private static final String SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME = "last_render_event_time";
    private static final String SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME = "last_failed_to_render_event_time";
    private static final String LAST_DISMISS_EVENT_TIMESTAMP = "lastDismissEventTimestamp";
    public static final String SHARED_PREFS_KEY_ONLY_WIFI_MODE = "tb_only_wifi_mode";
    public static final String SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED = "tb_notification_enabled";
    public static final String SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES = "tb_notification_categories";
    private static final String LAST_RUNNING_NOTIFICATION_TIME = "last_running_notification_time";
    private static final String COUNT_OF_RENDERED_NOTIFICATIONS_TODAY = "max_notification_trigger_count_per_day";
    private static final String UNENGAGED_ACTIONS_COUNT = "unengaged_actions_count";
    private static final String ENGAGED_ACTIONS_COUNT = "engaged_actions_count";
    private static final String CURRENT_ENGAGED_GROUP_NAME = "current_engaged_group_type";
    private static final String SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "should_send_event_user_assigned_to_notification_engagement_group";
    private static final String LAST_ACTIONS_COUNT_TIMESTAMP = "last_actions_count_timestamp";
    static final int SHARED_PREFS_KEY_ENABLED_STATE = 1;
    static final int SHARED_PREFS_KEY_DISABLED_STATE = 0;
    public static final String SCHEDULED_NOTIFICATIONS_LOCAL_STORAGE_SCHEMA_VERSION = "scheduled_notifications_storage_schema_version";
    private TBContent cachedContent;
    private NotificationContentState notificationContentState;
    private final Gson gson = new Gson();

    public ScheduledNotificationsLocalStorage(Context context) {
        super(context, SCHEDULED_NOTIFICATIONS_SHARED_PREFS_FILE_NAME);
    }

    public void setNotificationAppIconId(int iconId) {
        this.putInt(SHARED_PREFS_KEY_TB_ICON_ID, iconId);
    }

    public int getNotificationAppIconId() {
        return this.getInt(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    public void removeNotificationIcon() {
        this.removeKey(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    @Nullable
    public String getNotificationAppNameLabel() {
        return this.getString(SHARED_PREFS_KEY_APPLICATION_NAME);
    }

    public void setNotificationAppNameLabel(String applicationName) {
        this.putString(SHARED_PREFS_KEY_APPLICATION_NAME, applicationName);
    }

    long getLastAutoNextItemEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME);
    }

    void setLastAutoNextItemEventTime(long lastTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME, lastTime);
    }

    public long getLastShownNotificationTimestamp() {
        return this.sharedPreferences.getLong(LAST_RUNNING_NOTIFICATION_TIME, 0L);
    }

    public void setLastShownNotificationTime(long time) {
        this.sharedPreferences.edit().putLong(LAST_RUNNING_NOTIFICATION_TIME, time).apply();
    }

    public int getCountOfRenderedNotificationsToday() {
        return this.sharedPreferences.getInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, 0);
    }

    public void setCountOfRenderedNotificationsToday(int counter) {
        this.sharedPreferences.edit().putInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, counter).apply();
    }

    void setLastContentRefreshEventTime(long lastContentRefreshEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME, lastContentRefreshEventTime);
    }

    long getLastContentRefreshEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME);
    }

    void setLastRenderEventTimestamp(long lastRenderEventTimestamp) {
        this.putLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME, lastRenderEventTimestamp);
    }

    long getLastRenderEventTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME);
    }

    void setLastDismissEventTimestamp(long lastDismissEventTimestamp) {
        this.putLong(LAST_DISMISS_EVENT_TIMESTAMP, lastDismissEventTimestamp);
    }

    long getLastDismissEventTimestamp() {
        return this.getLong(LAST_DISMISS_EVENT_TIMESTAMP);
    }

    void setLastFailedToRenderEventTime(long lastFailedToRenderEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME, lastFailedToRenderEventTime);
    }

    long getLastFailedToRenderEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME);
    }

    public long getRefreshedTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP);
    }

    public void setRefreshedTimestamp(long refreshedTimestamp) {
        this.putLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP, refreshedTimestamp);
    }

    public void setEnabled(boolean isEnabled) {
        this.putBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED, isEnabled);
    }

    public boolean isNotificationEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED);
    }

    void setNotificationCategories(@NonNull List<String> notificationCategories) {
        HashSet<String> categoriesSet = new HashSet<String>(notificationCategories);
        this.sharedPreferences.edit().putStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, categoriesSet).apply();
    }

    @NonNull
    public List<String> getNotificationCategories() {
        Set categoriesSet = this.sharedPreferences.getStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, new HashSet());
        return new ArrayList<String>(categoriesSet);
    }

    void setWifiOnlyModeRuntimeFlag(Boolean isOnlyWifi) {
        try {
            String isOnlyWifiJson = this.gson.toJson((Object)isOnlyWifi);
            this.sharedPreferences.edit().putString(SHARED_PREFS_KEY_ONLY_WIFI_MODE, isOnlyWifiJson).apply();
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("setWifiOnlyModeRuntimeFlag: error " + e), (Throwable)e);
        }
    }

    @Nullable
    public Boolean isWifiOnlyModeRuntimeFlag() {
        String json = this.sharedPreferences.getString(SHARED_PREFS_KEY_ONLY_WIFI_MODE, null);
        return (Boolean)this.gson.fromJson(json, Boolean.class);
    }

    void setPreviousState(int previousState) {
        this.putInt(SHARED_PREFS_KEY_PREVIOUS_STATE, previousState);
    }

    int getPreviousState() {
        return this.getInt(SHARED_PREFS_KEY_PREVIOUS_STATE);
    }

    void setUiMode(String UiMode) {
        this.putString(SHARED_PREFS_KEY_UI_MODE, UiMode);
    }

    String getUiMode() {
        return this.getString(SHARED_PREFS_KEY_UI_MODE);
    }

    void setSendNotificationBlockedByConfigEvent() {
        this.putBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, true);
    }

    boolean isNotificationBlockedByConfigEventAlreadySend() {
        return this.getBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT);
    }

    void setScheduledNotificationsExtraProperties(@Nullable Map<String, String> extraProperties) {
        try {
            String value = this.gson.toJson(extraProperties);
            this.putString(SHARED_PREFS_KEY_SCHEDULED_NOTIFICATIONS_EXTRA_PROPERTIES, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("setScheduledNotificationsExtraProperties: error " + e), (Throwable)e);
        }
    }

    @Nullable
    public HashMap<String, String> getScheduledNotificationsExtraProperties() {
        String currentPropertiesStr = this.getString(SHARED_PREFS_KEY_SCHEDULED_NOTIFICATIONS_EXTRA_PROPERTIES);
        if (!TextUtils.isEmpty((CharSequence)currentPropertiesStr)) {
            Type type = new TypeToken<HashMap<String, String>>(){}.getType();
            return (HashMap)this.gson.fromJson(currentPropertiesStr, type);
        }
        return null;
    }

    public void setContent(TBContent content) {
        this.cachedContent = content;
        try {
            String contentJson = this.gson.toJson((Object)content);
            this.putString(SHARED_PREFS_KEY_TB_CONTENT, contentJson);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("setContent error" + e), (Throwable)e);
        }
    }

    @Nullable
    public TBContent getContent() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        String currentContentStr = this.getString(SHARED_PREFS_KEY_TB_CONTENT);
        if (!TextUtils.isEmpty((CharSequence)currentContentStr)) {
            try {
                Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(TBPlacement.class, (Object)new TBPlacementTypeAdapter()).create();
                this.cachedContent = (TBContent)gsonWithAdapter.fromJson(currentContentStr, TBContent.class);
                return this.cachedContent;
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("getContent error" + e), (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public NotificationContentState getNotificationContentState() {
        if (this.notificationContentState != null) {
            return this.notificationContentState;
        }
        String contentStateJson = this.getString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE);
        if (contentStateJson != null) {
            this.notificationContentState = (NotificationContentState)this.gson.fromJson(contentStateJson, NotificationContentState.class);
            return this.notificationContentState;
        }
        return null;
    }

    public void setNotificationContentState(NotificationContentState notificationContentState) {
        this.notificationContentState = notificationContentState;
        try {
            String contentStateJson = this.gson.toJson((Object)notificationContentState);
            this.putString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE, contentStateJson);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("setNotificationContentState: error " + e), (Throwable)e);
        }
    }

    void setCountOfUnengagedActions(int actionsCount) {
        this.sharedPreferences.edit().putInt(UNENGAGED_ACTIONS_COUNT, actionsCount).apply();
    }

    int getCountOfUnengagedActions() {
        return this.sharedPreferences.getInt(UNENGAGED_ACTIONS_COUNT, 0);
    }

    void setCountOfEngagedActions(int actionsCount) {
        this.sharedPreferences.edit().putInt(ENGAGED_ACTIONS_COUNT, actionsCount).apply();
    }

    int getCountOfEngagedActions() {
        return this.sharedPreferences.getInt(ENGAGED_ACTIONS_COUNT, 0);
    }

    void setCurrentEngagedGroupName(String groupName) {
        this.sharedPreferences.edit().putString(CURRENT_ENGAGED_GROUP_NAME, groupName).apply();
    }

    String getCurrentEngagedGroupName() {
        return this.sharedPreferences.getString(CURRENT_ENGAGED_GROUP_NAME, "Default");
    }

    void setShouldSendUserAssignedToNotificationEngagementGroupEvent(boolean shouldSendEvent) {
        this.sharedPreferences.edit().putBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, shouldSendEvent).apply();
    }

    boolean shouldSendUserAssignedToNotificationEngagementGroupEvent() {
        return this.sharedPreferences.getBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, true);
    }

    void setLastUserActionsCountIntervalMs(long timestamp) {
        this.sharedPreferences.edit().putLong(LAST_ACTIONS_COUNT_TIMESTAMP, timestamp).apply();
    }

    long getLastUserActionsCountIntervalMs() {
        return this.sharedPreferences.getLong(LAST_ACTIONS_COUNT_TIMESTAMP, 0L);
    }
}

