/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.plus.common.AbstractAnalyticsManager;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.core.TBLPushManager;
import com.taboola.android.plus.notifications.push.TBPushNotificationsEventProperties;
import com.taboola.android.plus.notifications.push.models.BreakingNotificationContent;
import com.taboola.android.plus.notifications.push.models.TBPushRawData;
import com.taboola.android.utils.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

@RequiresApi(api=21)
public class TBPushNotificationsAnalyticsManager
extends AbstractAnalyticsManager<TBPushNotificationsEventProperties> {
    private static final String TAG = TBPushNotificationsAnalyticsManager.class.getSimpleName();
    private static final String PUSH_REMOTE_RCV = "PushRemoteMsgRcv";
    private static final String PUSH_DELIVERED_TO_SDK = "PushHandle";
    private static final String PUSH_ANY_RECEIVED_EVENT = "PushReceived";
    private static final String PUSH_MANUAL = "PushManualDlvrd";
    private static final String FAILED_TO_INIT_PUSH = "PushInitFail";
    private static final String PUSH_BREAKING_PRE_RENDER_EVENT = "PushBrkngPreRender";
    private static final String PUSH_BREAKING_RENDER_EVENT = "PushBrkngRender";
    private static final String PUSH_BREAKING_FAILED_TO_RENDER_EVENT = "PushBrkngRenderFail";
    private static final String TAP_PUSH_BREAKING_EVENT = "TapPushBrkngNotif";
    private static final String PUSH_BREAKING_DISMISSED_EVENT = "PushBrkngDismiss";
    private static final String PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT = "PushBrkngOpenScss";
    private static final String INVALID_ANY_PUSH_NOTIFICATION_ITEM = "InvalidPushItem";
    private static final String PUSH_TRACKING_DATA_UPDATE = "PushTrkDataUpdte";
    private static final String CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3 = "ChkNotifDsbldStatus";
    private static final String NOTIFICATION_DISABLED_BY_SYSTEM_EVENT = "NotifDsbldBySys";
    private static final String NOTIFICATION_ENABLED_BY_SYSTEM_EVENT = "NotifEnbldBySys";

    TBPushNotificationsAnalyticsManager(SdkPlusCore sdkPlusCore) {
        super(sdkPlusCore);
    }

    void sendPushReceivedEvent(@Nullable String title, @Nullable String messageId, @Nullable String pushType, @Nullable String pushObjString) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_ANY_RECEIVED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(title).setMessageId(messageId).setPushType(pushType).setCustomData(pushObjString).build();
        this.sendEvent(eventProperties, false);
    }

    void sendPushBreakingPreRenderEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_PRE_RENDER_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, false);
    }

    void sendPushManualDeliveredEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_MANUAL, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, false);
    }

    void sendPushBreakingRenderEvent(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_RENDER_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingRenderEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_RENDER_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingFailedToRenderEvent(BreakingNotificationContent breakingNotificationContent, String errorMessage) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_FAILED_TO_RENDER_EVENT, false).setError(errorMessage)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingFailedToRenderEvent(TBPushRawData tbPushRawData, String errorMessage) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_FAILED_TO_RENDER_EVENT, false).setError(errorMessage)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, true);
    }

    void sendInitFailedEvent(Exception e) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(FAILED_TO_INIT_PUSH, false).setError(e.getMessage())).setExceptionMessage(e.getMessage())).setExceptionStackTrace(Arrays.toString(e.getStackTrace()))).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, false);
    }

    void sendTapPushBreakingEvent(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(TAP_PUSH_BREAKING_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, true);
    }

    void sendTapPushBreakingEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(TAP_PUSH_BREAKING_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingOpenedSuccessfullyEvent(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingOpenedSuccessfullyEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingOpenedSuccessfullyEvent(String notificationUrl) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationUrl(notificationUrl).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingDismissedEvent(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_DISMISSED_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingDismissedEvent(TBPushRawData tbPushRawData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_DISMISSED_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(tbPushRawData.getTitle()).setNotificationDescription(tbPushRawData.getDescription()).setNotificationImage(tbPushRawData.getImageUrl()).setNotificationUrl(tbPushRawData.getUrl()).setCustomData(this.getCustomDataJson(tbPushRawData)).build();
        this.sendEvent(eventProperties, true);
    }

    private String getCustomDataJson(TBPushRawData tbPushRawData) {
        Map<String, String> customData = tbPushRawData.getCustomData();
        if (customData != null && !customData.isEmpty()) {
            JsonObject event = new JsonObject();
            for (String key : customData.keySet()) {
                event.addProperty(key, customData.get(key));
            }
            return String.valueOf(event);
        }
        return "";
    }

    void sendInvalidPushItemEvent(String errorMessage, String errorDetails, String messageId) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(INVALID_ANY_PUSH_NOTIFICATION_ITEM, false).setErrorMessage(errorMessage)).setError(errorDetails)).setMessageId(messageId).build();
        this.sendEvent(eventProperties, false);
    }

    void sendTrackingDataUpdateEvent(@NonNull String trackingData) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_TRACKING_DATA_UPDATE, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setCustomData(trackingData).build();
        this.sendEvent(eventProperties, false);
    }

    void sendTrackingDataRemoveEvent(@NonNull String trackingDataKey) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_TRACKING_DATA_UPDATE, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setCustomData(trackingDataKey).build();
        this.sendEvent(eventProperties, false);
    }

    void sendCheckNotificationDisabledStatusEvent(boolean isBlocked) {
        long lastCheckNotificationDisabledStatusEventTime = this.sharedLocalStorage.getLastCheckNotificationDisabledStatusEventTime();
        if (System.currentTimeMillis() - lastCheckNotificationDisabledStatusEventTime > 86400000L && isBlocked) {
            TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3, false).setIsBlocked(true)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
            this.sendEvent(eventProperties, false);
            this.sharedLocalStorage.setLastCheckNotificationDisabledStatusEventTime(System.currentTimeMillis());
        }
    }

    void sendNotificationDisabledBySystemEvent() {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(NOTIFICATION_DISABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    void sendNotificationEnabledBySystemEvent() {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(NOTIFICATION_ENABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    void sendPushBreakingPreRenderEvent(@NonNull BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_BREAKING_PRE_RENDER_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setNotificationTitle(breakingNotificationContent.getTitle()).setNotificationDescription(breakingNotificationContent.getDescription()).setNotificationImage(breakingNotificationContent.getImage()).setNotificationUrl(breakingNotificationContent.getUrl()).setNotificationBrand(breakingNotificationContent.getBrand()).setMessageId(breakingNotificationContent.getId()).build();
        this.sendEvent(eventProperties, false);
    }

    void sendPushDeliveredToSdksEvent(@NonNull RemoteMessage remoteMessage, boolean isPushFeatureEnabled) {
        String customData = this.parseRemoteMessage(remoteMessage, isPushFeatureEnabled);
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_DELIVERED_TO_SDK, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setMessageId(remoteMessage.getMessageId()).setCustomData(customData).build();
        Logger.d((String)TAG, (String)("sendPushDeliveredToSdksEvent() called with: remoteMessage = [" + customData + "], isPushFeatureEnabled = [" + isPushFeatureEnabled + "]"));
        this.sendEvent(eventProperties, false);
    }

    void sendRemoteMessageReceivedEvent(@NonNull RemoteMessage remoteMessage) {
        String customData = this.parseRemoteMessage(remoteMessage, null);
        TBPushNotificationsEventProperties eventProperties = ((TBPushNotificationsEventProperties.Builder)new TBPushNotificationsEventProperties.Builder(PUSH_REMOTE_RCV, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setMessageId(remoteMessage.getMessageId()).setCustomData(customData).build();
        this.sendEvent(eventProperties, false);
    }

    private String parseRemoteMessage(@NonNull RemoteMessage remoteMessage, Boolean isPushFeatureEnabled) {
        String parsedRemoteMessage;
        try {
            boolean isTaboolaMessage = TBLPushManager.isTaboolaMessage(remoteMessage);
            if (isTaboolaMessage) {
                JSONObject data = new JSONObject(remoteMessage.getData());
                JSONObject notification = new JSONObject(data.getString("notification").trim());
                JsonObject remoteMessageJson = new JsonObject();
                this.parseJson(notification.getJSONObject("n"), remoteMessageJson);
                HashMap customDataMap = (HashMap)this.gson.fromJson(notification.getString("c"), new TypeToken<HashMap<String, String>>(){}.getType());
                if (customDataMap != null && !customDataMap.isEmpty()) {
                    for (String key : customDataMap.keySet()) {
                        remoteMessageJson.addProperty(key, (String)customDataMap.get(key));
                    }
                }
                remoteMessageJson.addProperty("title", notification.optString("title"));
                remoteMessageJson.addProperty("isTaboolaMessage", Boolean.valueOf(true));
                if (isPushFeatureEnabled != null) {
                    remoteMessageJson.addProperty("isPushFeatureEnabled", isPushFeatureEnabled);
                }
                parsedRemoteMessage = String.valueOf(remoteMessageJson);
            } else {
                parsedRemoteMessage = remoteMessage.getData().toString();
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("parseRemoteMessage: " + e), (Throwable)e);
            parsedRemoteMessage = "";
        }
        return parsedRemoteMessage;
    }

    private void parseJson(JSONObject src, JsonObject output) {
        Iterator keys = src.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = src.opt(key);
            if (value instanceof JSONObject) {
                JsonObject inner = new JsonObject();
                this.parseJson((JSONObject)value, inner);
                output.add(key, (JsonElement)inner);
                continue;
            }
            if (value == null) continue;
            output.addProperty(key, value.toString());
        }
    }

    @Override
    public void broadcastEvent(@NonNull TBPushNotificationsEventProperties pushNotificationsEventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction("tb.analytics.action.name");
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra("key_event_name", pushNotificationsEventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, pushNotificationsEventProperties.getError(), pushNotificationsEventProperties.isBlocked(), pushNotificationsEventProperties.isDeviceLocked(), pushNotificationsEventProperties.getExceptionMessage(), pushNotificationsEventProperties.getExceptionStackTrace(), pushNotificationsEventProperties.getErrorMessage(), pushNotificationsEventProperties.getNotificationTitle(), pushNotificationsEventProperties.getNotificationDescription(), pushNotificationsEventProperties.getNotificationImage(), pushNotificationsEventProperties.getNotificationUrl(), pushNotificationsEventProperties.getNotificationUrl(), pushNotificationsEventProperties.getCustomData(), pushNotificationsEventProperties.getMessageId(), pushNotificationsEventProperties.getPushType());
            intent.putExtra("key_event_properties", eventsProperties.toString());
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra("key_user_properties", userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public Map<String, String> getEventMap(@NonNull Context appContext, @NonNull TBPushNotificationsEventProperties pushNotificationsEventProperties) {
        String notificationUrl;
        String notificationImage;
        String notificationDescription;
        String notificationTitle;
        Map<String, String> map = super.getEventMap(appContext, pushNotificationsEventProperties);
        String pushType = pushNotificationsEventProperties.getPushType();
        if (!TextUtils.isEmpty((CharSequence)pushType)) {
            map.put("pushType", pushType);
        }
        if (!TextUtils.isEmpty((CharSequence)(notificationTitle = pushNotificationsEventProperties.getNotificationTitle()))) {
            map.put("notificationTitle", notificationTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)(notificationDescription = pushNotificationsEventProperties.getNotificationDescription()))) {
            map.put("notificationDescription", notificationDescription);
        }
        if (!TextUtils.isEmpty((CharSequence)(notificationImage = pushNotificationsEventProperties.getNotificationImage()))) {
            map.put("notificationImage", notificationImage);
        }
        if (!TextUtils.isEmpty((CharSequence)(notificationUrl = pushNotificationsEventProperties.getNotificationUrl()))) {
            map.put("notificationUrl", notificationUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationBrand())) {
            map.put("notificationBrand", pushNotificationsEventProperties.getNotificationBrand());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getMessageId())) {
            map.put("messageId", pushNotificationsEventProperties.getMessageId());
        }
        return map;
    }

    @Override
    public JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull TBPushNotificationsEventProperties pushNotificationsEventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        JsonObject event = super.getJsonObjectForKusto(appContext, pushNotificationsEventProperties, sharedLocalStorage);
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationTitle())) {
            event.addProperty("notificationTitle", pushNotificationsEventProperties.getNotificationTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationDescription())) {
            event.addProperty("notificationDescription", pushNotificationsEventProperties.getNotificationDescription());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationImage())) {
            event.addProperty("notificationImage", pushNotificationsEventProperties.getNotificationImage());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationUrl())) {
            event.addProperty("notificationUrl", pushNotificationsEventProperties.getNotificationUrl());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getNotificationBrand())) {
            event.addProperty("notificationBrand", pushNotificationsEventProperties.getNotificationBrand());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getMessageId())) {
            event.addProperty("messageId", pushNotificationsEventProperties.getMessageId());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getPushType())) {
            event.addProperty("pushType", pushNotificationsEventProperties.getPushType());
        }
        if (!TextUtils.isEmpty((CharSequence)pushNotificationsEventProperties.getChannelId())) {
            event.addProperty("channelId", pushNotificationsEventProperties.getChannelId());
        }
        return event;
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable String error, Boolean isBlocked, Boolean isDeviceLocked, String exceptionMessage, String exceptionStackTrace, String errorMessage, String notificationTitle, String notificationDescription, String notificationImage, String notificationUrl, String notificationBrand, String customData, String messageId, String pushType) {
        JSONObject eventProperties = this.getCommonEventProperties(appContext, error, isBlocked, isDeviceLocked, exceptionMessage, exceptionStackTrace, errorMessage);
        try {
            if (!TextUtils.isEmpty((CharSequence)notificationTitle)) {
                eventProperties.put("notificationTitle", (Object)notificationTitle);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationDescription)) {
                eventProperties.put("notificationDescription", (Object)notificationDescription);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationImage)) {
                eventProperties.put("notificationImage", (Object)notificationImage);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationUrl)) {
                eventProperties.put("notificationUrl", (Object)notificationUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationBrand)) {
                eventProperties.put("notificationBrand", (Object)notificationBrand);
            }
            if (!TextUtils.isEmpty((CharSequence)customData)) {
                eventProperties.put("customData", (Object)customData);
            }
            if (!TextUtils.isEmpty((CharSequence)messageId)) {
                eventProperties.put("messageId", (Object)messageId);
            }
            if (!TextUtils.isEmpty((CharSequence)pushType)) {
                eventProperties.put("pushType", (Object)pushType);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }

    @Override
    protected String getCustomData(@NonNull TBPushNotificationsEventProperties eventProperties) {
        return eventProperties.getCustomData();
    }
}

