/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.taboola.android.plus.core.TaboolaSdkPlus;
import com.taboola.android.plus.notifications.push.IPushNotificationsInternal;
import com.taboola.android.plus.notifications.push.PushNotificationsConfig;
import com.taboola.android.plus.notifications.push.PushNotificationsUtil;
import com.taboola.android.plus.notifications.push.TBPushNotificationsAnalyticsManager;
import com.taboola.android.plus.notifications.push.models.TBPushRawData;

@RequiresApi(api=21)
public class TBPushManualBiReporting {
    private static final String TAG = TBPushManualBiReporting.class.getSimpleName();

    public static boolean sendPushBreakingPreRenderEvent(@NonNull TBPushRawData tbPushRawData) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingPreRenderEvent(tbPushRawData);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendPushBreakingRenderEvent(@NonNull TBPushRawData tbPushRawData) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingRenderEvent(tbPushRawData);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendPushBreakingDismissedEvent(@NonNull TBPushRawData tbPushRawData) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingDismissedEvent(tbPushRawData);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendTapPushBreakingEvent(@NonNull TBPushRawData tbPushRawData) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendTapPushBreakingEvent(tbPushRawData);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendPushBreakingOpenedSuccessfullyEvent(@NonNull TBPushRawData tbPushRawData) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingOpenedSuccessfullyEvent(tbPushRawData);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendPushBreakingOpenedSuccessfullyEvent(@NonNull String notificationUrl) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingOpenedSuccessfullyEvent(notificationUrl);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendPushBreakingFailedToRenderEvent(@NonNull TBPushRawData tbPushRawData, @NonNull String errorMessage) {
        TBPushNotificationsAnalyticsManager manager = TBPushManualBiReporting.getAnalyticsManager();
        if (manager != null) {
            manager.sendPushBreakingFailedToRenderEvent(tbPushRawData, errorMessage);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    public static boolean sendRemoteMessageReceivedEvent(RemoteMessage remoteMessage) {
        TBPushNotificationsAnalyticsManager analyticsManager = null;
        IPushNotificationsInternal manager = TBPushManualBiReporting.getPushNotificationsManager();
        if (manager != null) {
            analyticsManager = manager.getAnalyticsManagerInternal();
        }
        if (analyticsManager != null) {
            analyticsManager.sendRemoteMessageReceivedEvent(remoteMessage);
            return true;
        }
        Log.d((String)TAG, (String)"Manual reporting is not allowed");
        return false;
    }

    private static boolean isManualReportingAllowed(IPushNotificationsInternal tbPushNotificationsManager) {
        if (tbPushNotificationsManager == null) {
            return false;
        }
        PushNotificationsConfig config = tbPushNotificationsManager.getPushNotificationsConfig();
        return PushNotificationsUtil.shouldAllowManualReporting(config);
    }

    @Nullable
    private static TBPushNotificationsAnalyticsManager getAnalyticsManager() {
        IPushNotificationsInternal manager = TBPushManualBiReporting.getPushNotificationsManager();
        return TBPushManualBiReporting.isManualReportingAllowed(manager) ? manager.getAnalyticsManagerInternal() : null;
    }

    @Nullable
    private static IPushNotificationsInternal getPushNotificationsManager() {
        return (IPushNotificationsInternal)TaboolaSdkPlus.getPushNotificationManager();
    }
}

