/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.plus.common.AbstractLocalStorage;

public class PushNotificationsLocalStorage
extends AbstractLocalStorage {
    public static final String PUSH_NOTIFICATIONS_SHARED_PREFS_FILE_NAME = "push_notifications_local_storage";
    public static final String PUSH_NOTIFICATIONS_LOCAL_STORAGE_SCHEMA_VERSION = "push_notifications_storage_schema_version";
    private static final String SHARED_PREFS_KEY_TB_ICON_ID = "push_notifications_notification_icon_id";
    private static final String SHARED_PREFS_KEY_APPLICATION_NAME = "push_notifications_application_name";
    private static final String SHARED_PREFS_KEY_FIREBASE_TOKEN = "push_notifications_firebase_token";

    PushNotificationsLocalStorage(Context context) {
        this(context, PUSH_NOTIFICATIONS_SHARED_PREFS_FILE_NAME);
    }

    private PushNotificationsLocalStorage(@NonNull Context applicationContext, @NonNull String sharedPrefsFileName) {
        super(applicationContext, sharedPrefsFileName);
    }

    public void setNotificationAppIconId(int iconId) {
        this.putInt(SHARED_PREFS_KEY_TB_ICON_ID, iconId);
    }

    public int getNotificationAppIconId() {
        return this.getInt(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    public void removeNotificationIcon() {
        this.removeKey(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    @Nullable
    public String getNotificationAppNameLabel() {
        return this.getString(SHARED_PREFS_KEY_APPLICATION_NAME);
    }

    public void setNotificationAppNameLabel(String applicationName) {
        this.putString(SHARED_PREFS_KEY_APPLICATION_NAME, applicationName);
    }

    void setFirebaseToken(String token) {
        this.putString(SHARED_PREFS_KEY_FIREBASE_TOKEN, token);
    }

    String getFirebaseToken() {
        return this.getString(SHARED_PREFS_KEY_FIREBASE_TOKEN);
    }
}

