/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.common.BaseConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PushNotificationsConfig
extends BaseConfig
implements Parcelable {
    static final String PUSH_NOTIFICATIONS_LAYOUT = "pushNotificationsLayout";
    private static final String PUSH_NOTIFICATIONS_FEATURE_ENABLED = "isPushNotificationsFeatureEnabled";
    private static final String MANUAL_RENDERING_ENABLED = "isManualRenderingEnabled";
    private static final String MANUAL_REPORTING_ENABLED = "isManualReportingEnabled";
    private static final String MANUAL_CLICK_HANDLING_ENABLED = "isManualClickHandlingEnabled";
    private static final String PUSH_NOTIFICATIONS_API_KEY = "pushNotificationsApiKey";
    @SerializedName(value="isPushNotificationsFeatureEnabled")
    private boolean isPushNotificationsEnabled = false;
    @SerializedName(value="isManualRenderingEnabled")
    private boolean isManualRenderingEnabled = false;
    @SerializedName(value="isManualReportingEnabled")
    private boolean isManualReportingEnabled = false;
    @SerializedName(value="isManualClickHandlingEnabled")
    private boolean isManualClickHandlingEnabled = false;
    @SerializedName(value="pushNotificationsApiKey")
    private Map<String, String> pushApiKey = new HashMap<String, String>();
    @SerializedName(value="pushNotificationsLayout")
    private PushNotificationsLayout pushNotificationsLayout;
    public static final Parcelable.Creator<PushNotificationsConfig> CREATOR = new Parcelable.Creator<PushNotificationsConfig>(){

        public PushNotificationsConfig createFromParcel(Parcel source) {
            return new PushNotificationsConfig(source);
        }

        public PushNotificationsConfig[] newArray(int size) {
            return new PushNotificationsConfig[size];
        }
    };

    public static ArrayList<String> getRequiredFields() {
        return new ArrayList<String>(Arrays.asList(PUSH_NOTIFICATIONS_FEATURE_ENABLED, PUSH_NOTIFICATIONS_API_KEY, PUSH_NOTIFICATIONS_LAYOUT));
    }

    boolean isPushNotificationsFeatureEnabled() {
        return this.isPushNotificationsEnabled;
    }

    boolean isManualRenderingEnabled() {
        return this.isManualRenderingEnabled;
    }

    boolean isManualReportingEnabled() {
        return this.isManualReportingEnabled;
    }

    boolean isManualClickHandlingEnabled() {
        return this.isManualClickHandlingEnabled;
    }

    Map<String, String> getPushApiKey() {
        return this.pushApiKey;
    }

    @NonNull
    PushNotificationsLayout getPushNotificationsLayout() {
        return this.pushNotificationsLayout;
    }

    @Nullable
    String getApiKey(Context appContext) {
        return this.pushApiKey.isEmpty() ? null : this.pushApiKey.get(appContext.getPackageName());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.isPushNotificationsEnabled ? (byte)1 : 0);
        dest.writeByte(this.isManualRenderingEnabled ? (byte)1 : 0);
        dest.writeByte(this.isManualReportingEnabled ? (byte)1 : 0);
        dest.writeByte(this.isManualClickHandlingEnabled ? (byte)1 : 0);
        dest.writeMap(this.pushApiKey);
        dest.writeParcelable((Parcelable)this.pushNotificationsLayout, flags);
    }

    public PushNotificationsConfig() {
    }

    protected PushNotificationsConfig(Parcel in) {
        this.isPushNotificationsEnabled = in.readByte() != 0;
        this.isManualRenderingEnabled = in.readByte() != 0;
        this.isManualReportingEnabled = in.readByte() != 0;
        this.isManualClickHandlingEnabled = in.readByte() != 0;
        in.readMap(this.pushApiKey, String.class.getClassLoader());
        this.pushNotificationsLayout = (PushNotificationsLayout)in.readParcelable(PushNotificationsLayout.class.getClassLoader());
    }

    static class LayoutSpecificConfigs
    implements Parcelable {
        static final String LAYOUT_COLLAPSED_BREAKING = "layout_collapsed_breaking";
        static final String LAYOUT_EXPANDED_BREAKING = "layout_expanded_breaking";
        @SerializedName(value="layout_collapsed_breaking")
        private CollapsedBreaking collapsedBreaking = new CollapsedBreaking();
        @SerializedName(value="layout_expanded_breaking")
        private ExpandedBreaking expandedBreaking = new ExpandedBreaking();
        public static final Parcelable.Creator<LayoutSpecificConfigs> CREATOR = new Parcelable.Creator<LayoutSpecificConfigs>(){

            public LayoutSpecificConfigs createFromParcel(Parcel source) {
                return new LayoutSpecificConfigs(source);
            }

            public LayoutSpecificConfigs[] newArray(int size) {
                return new LayoutSpecificConfigs[size];
            }
        };

        public static ArrayList<String> getRequiredFields() {
            return new ArrayList<String>(Arrays.asList(LAYOUT_COLLAPSED_BREAKING, LAYOUT_EXPANDED_BREAKING));
        }

        public CollapsedBreaking getCollapsedBreaking() {
            return this.collapsedBreaking;
        }

        public ExpandedBreaking getExpandedBreaking() {
            return this.expandedBreaking;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.collapsedBreaking, flags);
            dest.writeParcelable((Parcelable)this.expandedBreaking, flags);
        }

        public LayoutSpecificConfigs() {
        }

        protected LayoutSpecificConfigs(Parcel in) {
            this.collapsedBreaking = (CollapsedBreaking)in.readParcelable(CollapsedBreaking.class.getClassLoader());
            this.expandedBreaking = (ExpandedBreaking)in.readParcelable(ExpandedBreaking.class.getClassLoader());
        }

        static class ExpandedBreaking
        implements Parcelable {
            static final String BREAKING_LABEL_STRING_ID = "breakingLabelStringId";
            @SerializedName(value="breakingLabelStringId")
            private String breakingLabelStringId;
            public static final Parcelable.Creator<ExpandedBreaking> CREATOR = new Parcelable.Creator<ExpandedBreaking>(){

                public ExpandedBreaking createFromParcel(Parcel source) {
                    return new ExpandedBreaking(source);
                }

                public ExpandedBreaking[] newArray(int size) {
                    return new ExpandedBreaking[size];
                }
            };

            public String getBreakingLabelStringId() {
                return this.breakingLabelStringId;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.breakingLabelStringId);
            }

            public ExpandedBreaking() {
            }

            protected ExpandedBreaking(Parcel in) {
                this.breakingLabelStringId = in.readString();
            }
        }

        static class CollapsedBreaking
        implements Parcelable {
            static final String BREAKING_LABEL_STRING_ID = "breakingLabelStringId";
            @SerializedName(value="breakingLabelStringId")
            private String breakingLabelStringId;
            public static final Parcelable.Creator<CollapsedBreaking> CREATOR = new Parcelable.Creator<CollapsedBreaking>(){

                public CollapsedBreaking createFromParcel(Parcel source) {
                    return new CollapsedBreaking(source);
                }

                public CollapsedBreaking[] newArray(int size) {
                    return new CollapsedBreaking[size];
                }
            };

            public String getBreakingLabelStringId() {
                return this.breakingLabelStringId;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.breakingLabelStringId);
            }

            public CollapsedBreaking() {
            }

            protected CollapsedBreaking(Parcel in) {
                this.breakingLabelStringId = in.readString();
            }
        }
    }

    static class PushNotificationsLayout
    implements Parcelable {
        static final String LAYOUT_SPECIFIC_PROPERTIES = "layoutSpecificProperties";
        private static final String APPLICATION_NAME_LABEL = "applicationNameLabel";
        @SerializedName(value="applicationNameLabel")
        private String applicationNameLabel;
        @SerializedName(value="layoutSpecificProperties")
        private LayoutSpecificConfigs specificConfigs = new LayoutSpecificConfigs();
        public static final Parcelable.Creator<PushNotificationsLayout> CREATOR = new Parcelable.Creator<PushNotificationsLayout>(){

            public PushNotificationsLayout createFromParcel(Parcel source) {
                return new PushNotificationsLayout(source);
            }

            public PushNotificationsLayout[] newArray(int size) {
                return new PushNotificationsLayout[size];
            }
        };

        public static ArrayList<String> getRequiredFields() {
            return new ArrayList<String>(Collections.singletonList(LAYOUT_SPECIFIC_PROPERTIES));
        }

        LayoutSpecificConfigs getSpecificConfigs() {
            return this.specificConfigs;
        }

        public String getApplicationNameLabel() {
            return this.applicationNameLabel;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.applicationNameLabel);
            dest.writeParcelable((Parcelable)this.specificConfigs, flags);
        }

        public PushNotificationsLayout() {
        }

        protected PushNotificationsLayout(Parcel in) {
            this.applicationNameLabel = in.readString();
            this.specificConfigs = (LayoutSpecificConfigs)in.readParcelable(LayoutSpecificConfigs.class.getClassLoader());
        }
    }
}

