/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget.util;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.common.BaseConfigValidator;
import com.taboola.android.plus.home.screen.widget.WidgetConfig;

public class WidgetConfigValidator
extends BaseConfigValidator {
    private static final String TAG = WidgetConfigValidator.class.getSimpleName();

    @Override
    public boolean isConfigValid(@NonNull JsonElement config) {
        try {
            if (WidgetConfigValidator.isObjectValid(config, WidgetConfig.getRequiredFields())) {
                JsonElement widgetContent = config.getAsJsonObject().get("widgetContentConfig");
                if (widgetContent != null) {
                    JsonElement categoryToPlacementMap = widgetContent.getAsJsonObject().get("categoryToPlacement");
                    if (categoryToPlacementMap != null) {
                        if (!categoryToPlacementMap.getAsJsonObject().entrySet().isEmpty()) {
                            return true;
                        }
                        Log.e((String)TAG, (String)"isConfigValid: category for placement map is empty");
                        return false;
                    }
                    Log.e((String)TAG, (String)"isConfigValid: category to placement map is missing");
                    return false;
                }
                Log.e((String)TAG, (String)"isConfigValid: widget content config is missing");
                return false;
            }
            Log.e((String)TAG, (String)"isConfigValid: widget config is invalid");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public <T extends BaseConfig> T parseConfig(@NonNull JsonElement config, @NonNull Class<T> type) {
        try {
            return (T)((BaseConfig)type.cast(this.gson.fromJson(config, WidgetConfig.class)));
        }
        catch (Exception e) {
            return null;
        }
    }
}

