/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget;

import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.core.CoreConfig;
import com.taboola.android.plus.core.InternalFeatureInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.home.screen.widget.IWidgetManager;
import com.taboola.android.plus.home.screen.widget.TBHomeScreenWidget;
import com.taboola.android.plus.home.screen.widget.TBWidgetAnalyticsManager;
import com.taboola.android.plus.home.screen.widget.WidgetConfig;
import com.taboola.android.plus.home.screen.widget.WidgetLocalStorage;
import com.taboola.android.plus.home.screen.widget.content.WidgetContentRepository;
import com.taboola.android.plus.home.screen.widget.job.WidgetRefreshJob;
import com.taboola.android.plus.home.screen.widget.util.WidgetConfigValidator;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(api=21)
public class WidgetManager
extends IWidgetManager {
    private static final String TAG = WidgetManager.class.getSimpleName();
    public static final String WIDGET_PLACEMENT_KEY = "widget_placement";
    public static final String WIDGET_CLICKED_ITEM_POSITION_KEY = "widget_clicked_item_position";
    private static final int INVALID_ITEM_POSITION = -1;
    private Context appContext;
    private boolean isWidgetInitialized = false;
    private WidgetConfig widgetConfig;
    private WidgetLocalStorage widgetLocalStorage;
    private SharedLocalStorage sharedLocalStorage;
    private TBWidgetAnalyticsManager tbWidgetAnalyticsManager;

    @Override
    public void enableWidget(@NonNull Context context) {
        Log.i((String)"TBAppWidget", (String)"enableWidget: ");
        PackageManager packageManager = context.getPackageManager();
        packageManager.setComponentEnabledSetting(new ComponentName(context, TBHomeScreenWidget.class), 1, 1);
    }

    @Override
    public void disableWidget(@NonNull Context context) {
        Log.i((String)TAG, (String)"disableWidget: ");
        PackageManager packageManager = context.getPackageManager();
        packageManager.setComponentEnabledSetting(new ComponentName(context, TBHomeScreenWidget.class), 2, 1);
    }

    @Override
    public void handleClick(@NonNull Bundle bundle, @NonNull Context activityContext) {
        try {
            boolean isPlacementValid;
            TBPlacement placement = (TBPlacement)bundle.getParcelable(WIDGET_PLACEMENT_KEY);
            int itemIndex = bundle.getInt(WIDGET_CLICKED_ITEM_POSITION_KEY);
            boolean bl = isPlacementValid = placement != null && !placement.getItems().isEmpty();
            if (isPlacementValid) {
                if (itemIndex != -1) {
                    TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(itemIndex);
                    if (item != null) {
                        this.handleItemClick((TBRecommendationItem)placement.getItems().get(itemIndex), activityContext);
                    } else {
                        Logger.e((String)TAG, (String)"recommendation item is invalid");
                    }
                } else {
                    Logger.e((String)TAG, (String)"clicked index is invalid");
                }
            } else {
                Logger.e((String)TAG, (String)"placement is invalid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fetchContent(WidgetContentRepository.OnContentFetchCallback onContentFetchCallback) {
        String viewId = String.valueOf(System.currentTimeMillis());
        WidgetConfig.WidgetContentConfig contentConfig = this.widgetConfig.getWidgetContentConfig();
        HashMap<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> categorizedPlacementMap = this.getValidCategorizedPlacementMap(contentConfig.getCategorizedPlacements());
        if (!categorizedPlacementMap.isEmpty()) {
            new WidgetContentRepository().execute(this.tbWidgetAnalyticsManager, categorizedPlacementMap, this.sharedLocalStorage.getUserUnifiedId(), viewId, onContentFetchCallback);
        } else {
            Log.e((String)TAG, (String)"fetchContent: cannot fetch the content, valid placements map is empty");
        }
    }

    private HashMap<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> getValidCategorizedPlacementMap(HashMap<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> placementsMap) {
        HashMap<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> validPlacementsMap = new HashMap<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem>();
        for (Map.Entry<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> entry : placementsMap.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getValue().placementName)) continue;
            validPlacementsMap.put(entry.getKey(), entry.getValue());
        }
        return validPlacementsMap;
    }

    private void handleItemClick(@NonNull TBRecommendationItem item, Context activityContext) {
        if (TaboolaApi.getInstance().isInitialized()) {
            item.handleClick(activityContext);
        } else {
            Log.e((String)TAG, (String)"cannot handle widget item click, TaboolaApi is not initialized");
        }
    }

    @Override
    public void init(SdkPlusCore sdkPlusCore, Map<String, String> scheduledNotificationExtraProperties, InternalFeatureInitCallback internalFeatureInitCallback) {
        WidgetConfigValidator validator = new WidgetConfigValidator();
        JsonElement widgetElement = sdkPlusCore.getSdkPlusConfig().getWidgetConfig();
        if (widgetElement != null) {
            if (!validator.isConfigValid(widgetElement)) {
                internalFeatureInitCallback.onFeatureInitFailed(PlusFeature.APP_WIDGET, new IllegalStateException("widget config is invalid"));
            } else {
                this.appContext = sdkPlusCore.getApplicationContext();
                WidgetConfig config = validator.parseConfig(widgetElement, WidgetConfig.class);
                this.widgetConfig = config != null ? config : new WidgetConfig();
                this.widgetConfig = validator.parseConfig(widgetElement, WidgetConfig.class);
                this.tbWidgetAnalyticsManager = new TBWidgetAnalyticsManager(sdkPlusCore);
                this.widgetLocalStorage = new WidgetLocalStorage(this.appContext);
                this.sharedLocalStorage = new SharedLocalStorage(this.appContext);
                CoreConfig coreConfig = sdkPlusCore.getSdkPlusConfig().getCoreConfig();
                if (!TaboolaApi.getInstance().isInitialized()) {
                    this.initTaboolaApi(coreConfig.getTaboolaApiKey(), sdkPlusCore.getLocalizedPublisherName(), scheduledNotificationExtraProperties, this.widgetConfig.getWidgetContentConfig().getExtraProperties());
                }
                this.isWidgetInitialized = true;
                internalFeatureInitCallback.onFeatureInitSuccessful(PlusFeature.APP_WIDGET);
            }
        } else {
            internalFeatureInitCallback.onFeatureInitFailed(PlusFeature.APP_WIDGET, new IllegalStateException("widget config is missing"));
        }
    }

    private void initTaboolaApi(String taboolaApiKey, String localizedPublisherName, Map<String, String> taboolaPlusExtraProperties, Map<String, String> widgetExtraProperties) {
        HashMap<String, String> mergedExtraProperties = new HashMap<String, String>();
        if (taboolaPlusExtraProperties != null) {
            mergedExtraProperties.putAll(taboolaPlusExtraProperties);
        }
        if (widgetExtraProperties != null && !widgetExtraProperties.isEmpty()) {
            mergedExtraProperties.putAll(widgetExtraProperties);
        }
        mergedExtraProperties.put("enableFullRawDataResponse", "true");
        TaboolaApi.getInstance().init(this.appContext, localizedPublisherName, taboolaApiKey, mergedExtraProperties);
    }

    @Override
    public boolean isWidgetInstanceExist() {
        ComponentName componentName;
        AppWidgetManager appWidgetManager = AppWidgetManager.getInstance((Context)this.appContext);
        int[] activeWidgetIds = appWidgetManager.getAppWidgetIds(componentName = new ComponentName(this.appContext, TBHomeScreenWidget.class));
        return activeWidgetIds.length != 0;
    }

    @Override
    public void rescheduleJobIfNeeded() {
        if (this.widgetConfig.isAppWidgetFeatureEnabled()) {
            if (!this.isWidgetInstanceExist()) {
                Log.i((String)TAG, (String)"rescheduleJobIfNeeded: there are no active widgets, no actions needed");
            } else if (WidgetRefreshJob.isJobRunning(this.appContext)) {
                Log.i((String)TAG, (String)"rescheduleJobIfNeeded: job is already scheduled, no actions needed");
            } else {
                WidgetRefreshJob.scheduleWidgetUpdate(this.appContext, this.widgetConfig.getWidgetRefreshIntervalMs());
                Log.i((String)TAG, (String)"rescheduleJobIfNeeded: rescheduleJobIfNeeded: successfully restored notification refresh job");
            }
        } else {
            Log.d((String)TAG, (String)"rescheduleJobIfNeeded: Scheduled notifications are disabled");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isWidgetInitialized;
    }

    @Override
    public Context getApplicationContext() {
        return this.appContext;
    }

    @Override
    public WidgetConfig widgetConfig() {
        return this.widgetConfig;
    }

    @Override
    public TBWidgetAnalyticsManager getTbWidgetAnalyticsManager() {
        return this.tbWidgetAnalyticsManager;
    }

    @Override
    public WidgetLocalStorage getWidgetLocalStorage() {
        return this.widgetLocalStorage;
    }

    @Override
    public void setWidgetIconId(int iconId) {
        if (ResourcesUtil.isResourceValid(this.appContext, iconId)) {
            this.widgetLocalStorage.setWidgetIconId(iconId);
        }
    }

    @Override
    public void setWidgetTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.widgetLocalStorage.setWidgetTitle(title);
        }
    }
}

