/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import android.widget.RemoteViews;
import android.widget.Toast;
import com.google.gson.JsonElement;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.R;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.PlacementSharedUtil;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.InternalSdkPlusCoreInitCallback;
import com.taboola.android.plus.home.screen.widget.IWidgetManager;
import com.taboola.android.plus.home.screen.widget.TBWidgetAnalyticsManager;
import com.taboola.android.plus.home.screen.widget.TBWidgetService;
import com.taboola.android.plus.home.screen.widget.WidgetBridgeInternal;
import com.taboola.android.plus.home.screen.widget.WidgetConfig;
import com.taboola.android.plus.home.screen.widget.WidgetLocalStorage;
import com.taboola.android.plus.home.screen.widget.WidgetManager;
import com.taboola.android.plus.home.screen.widget.job.WidgetRefreshJob;
import com.taboola.android.plus.home.screen.widget.util.WidgetConfigValidator;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class TBHomeScreenWidget
extends AppWidgetProvider {
    private static final String TAG = TBHomeScreenWidget.class.getSimpleName();
    private static final String WIDGET_ITEM_ACTION_CLICK = "widget_item_click_action";
    private static final String OPEN_APP_ACTION = "open_app_action";
    public static final String WIDGET_REFRESH_REASON = "widget_refresh_reason";
    public static final String NO_CONTENT_REASON = "no content";
    public static final String NO_INTERNET_REASON = "no internet";
    public static boolean isNoContentState = true;

    static void updateAppWidget(final Context context, final AppWidgetManager appWidgetManager, final int appWidgetId) {
        final int defaultIcon = context.getApplicationInfo().icon;
        final RemoteViews widgetRemoteView = new RemoteViews(context.getPackageName(), R.layout.layout_widget);
        TBHomeScreenWidget.getIntents(context, appWidgetId, widgetRemoteView);
        WidgetBridgeInternal.getWidgetManagerAsync(new IWidgetManager.WidgetManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IWidgetManager manager) {
                Log.d((String)TAG, (String)("updateAppWidget: is initialized: " + manager.isInitialized()));
                WidgetLocalStorage widgetLocalStorage = manager.getWidgetLocalStorage();
                WidgetConfig config = manager.widgetConfig();
                int widgetIconId = widgetLocalStorage.getWidgetIconId();
                String widgetTitle = TBHomeScreenWidget.getCorrectNameForWidget(context, config.getWidgetLabel(), widgetLocalStorage.getWidgetTitle());
                if (widgetIconId == -1) {
                    widgetRemoteView.setImageViewResource(R.id.app_logoIv, defaultIcon);
                } else {
                    widgetRemoteView.setImageViewResource(R.id.app_logoIv, widgetIconId);
                }
                widgetRemoteView.setTextViewText(R.id.appLabelTv, (CharSequence)widgetTitle);
                if (!ConditionCheckUtil.isNetworkAvailable(context)) {
                    widgetRemoteView.setViewVisibility(R.id.no_contentContainer, 0);
                    widgetRemoteView.setViewVisibility(R.id.tbWidgetList, 8);
                } else if (isNoContentState) {
                    widgetRemoteView.setViewVisibility(R.id.no_contentContainer, 0);
                    widgetRemoteView.setTextViewText(R.id.widget_messageTv, (CharSequence)"No new items are available, please refresh");
                    widgetRemoteView.setViewVisibility(R.id.tbWidgetList, 8);
                } else {
                    widgetRemoteView.setViewVisibility(R.id.no_contentContainer, 8);
                    widgetRemoteView.setViewVisibility(R.id.tbWidgetList, 0);
                }
                appWidgetManager.updateAppWidget(appWidgetId, widgetRemoteView);
                WidgetRefreshJob.scheduleWidgetUpdate(context, config.getWidgetRefreshIntervalMs());
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                Log.e((String)TAG, (String)("updateAppWidget: " + t.getMessage()));
            }
        });
    }

    private static void getIntents(Context context, int appWidgetId, RemoteViews widgetRemoteView) {
        PendingIntent pendingIntent = TBHomeScreenWidget.getPendingIntentForItemClick(context);
        widgetRemoteView.setPendingIntentTemplate(R.id.tbWidgetList, pendingIntent);
        widgetRemoteView.setRemoteAdapter(R.id.tbWidgetList, TBHomeScreenWidget.getWidgetListAdapterIntent(context, appWidgetId));
        PendingIntent openPendingIntent = TBHomeScreenWidget.getOpenAppPendingIntent(context, appWidgetId);
        widgetRemoteView.setOnClickPendingIntent(R.id.all_storiesContainer, openPendingIntent);
        PendingIntent refreshPendingIntent = TBHomeScreenWidget.getRefreshPendingIntent(context, appWidgetId);
        widgetRemoteView.setOnClickPendingIntent(R.id.widget_refreshBtn, refreshPendingIntent);
    }

    private static Intent getWidgetListAdapterIntent(Context context, int appWidgetId) {
        Intent adapter = new Intent(context, TBWidgetService.class);
        adapter.putExtra("appWidgetId", appWidgetId);
        adapter.setData(Uri.parse((String)adapter.toUri(1)));
        return adapter;
    }

    private static PendingIntent getPendingIntentForItemClick(Context context) {
        Intent listCLickListenerIntent = new Intent(context, TBHomeScreenWidget.class);
        listCLickListenerIntent.setAction(WIDGET_ITEM_ACTION_CLICK);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)listCLickListenerIntent, (int)0);
    }

    private static PendingIntent getOpenAppPendingIntent(Context context, int appWidgetId) {
        Intent openAppIntent = new Intent(context, TBHomeScreenWidget.class);
        openAppIntent.setAction(OPEN_APP_ACTION);
        return PendingIntent.getBroadcast((Context)context, (int)appWidgetId, (Intent)openAppIntent, (int)0);
    }

    private static PendingIntent getRefreshPendingIntent(Context context, int appWidgetId) {
        Intent refreshAppIntent = new Intent(context, TBHomeScreenWidget.class);
        refreshAppIntent.setAction("android.appwidget.action.APPWIDGET_UPDATE");
        String reason = ConditionCheckUtil.isNetworkAvailable(context) ? NO_CONTENT_REASON : NO_INTERNET_REASON;
        refreshAppIntent.putExtra(WIDGET_REFRESH_REASON, reason);
        return PendingIntent.getBroadcast((Context)context, (int)appWidgetId, (Intent)refreshAppIntent, (int)0);
    }

    public static void sendRefreshBroadcast(Context context) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setComponent(new ComponentName(context, TBHomeScreenWidget.class));
        context.sendBroadcast(intent);
    }

    private static String getCorrectNameForWidget(@NonNull Context context, @Nullable String configLabel, @Nullable String localStorageLabel) {
        String widgetLabelText = configLabel;
        if (TextUtils.isEmpty((CharSequence)widgetLabelText)) {
            widgetLabelText = localStorageLabel;
        }
        if (TextUtils.isEmpty((CharSequence)widgetLabelText)) {
            try {
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo info = packageManager.getApplicationInfo(context.getPackageName(), 128);
                widgetLabelText = (String)packageManager.getApplicationLabel(info);
            }
            catch (Exception e) {
                e.printStackTrace();
                widgetLabelText = "";
            }
        }
        return widgetLabelText;
    }

    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        WidgetLocalStorage localStorage = new WidgetLocalStorage(context);
        localStorage.setLastWidgetRefreshTimestamp(System.currentTimeMillis());
        for (int appWidgetId : appWidgetIds) {
            TBHomeScreenWidget.updateAppWidget(context, appWidgetManager, appWidgetId);
        }
    }

    public void onEnabled(final Context context) {
        BridgeInternalCore.getSdkPlusCoreAsync(new InternalSdkPlusCoreInitCallback(){

            @Override
            public void onSdkPlusCoreInitSuccessful(ISdkPlusCore sdkPlusCore) {
                JsonElement widgetConfigElement = sdkPlusCore.getSdkPlusConfig().getWidgetConfig();
                WidgetManager widgetManager = new WidgetManager();
                TBWidgetAnalyticsManager tbWidgetAnalyticsManager = new TBWidgetAnalyticsManager(sdkPlusCore);
                if (widgetConfigElement != null) {
                    WidgetConfigValidator validator = new WidgetConfigValidator();
                    if (validator.isConfigValid(widgetConfigElement)) {
                        WidgetConfig widgetConfig = validator.parseConfig(widgetConfigElement, WidgetConfig.class);
                        if (widgetConfig == null) {
                            widgetConfig = new WidgetConfig();
                        }
                        if (widgetConfig.isAppWidgetFeatureEnabled()) {
                            Log.i((String)TAG, (String)"onSdkPlusCoreInitSuccessful: widget is enabled in remote config, enabled");
                            widgetManager.enableWidget(context);
                            tbWidgetAnalyticsManager.sendWidgetEnabledEvent();
                        } else {
                            Log.e((String)TAG, (String)"onSdkPlusCoreInitSuccessful: widget is disabled in remote config");
                            TBHomeScreenWidget.this.disableWidgetIfNeeded(widgetManager, context);
                            tbWidgetAnalyticsManager.sendWidgetDisabledEvent();
                        }
                    } else {
                        Log.e((String)TAG, (String)"onSdkPlusCoreInitSuccessful: invalid widget config disable widget");
                        TBHomeScreenWidget.this.disableWidgetIfNeeded(widgetManager, context);
                        tbWidgetAnalyticsManager.sendWidgetDisabledEvent();
                    }
                } else {
                    Log.e((String)TAG, (String)"onSdkPlusCoreInitSuccessful: widget config is missing");
                    TBHomeScreenWidget.this.disableWidgetIfNeeded(widgetManager, context);
                    tbWidgetAnalyticsManager.sendWidgetDisabledEvent();
                }
            }

            @Override
            public void onSdkPlusCoreInitFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("onSdkPlusCoreInitFailed: " + throwable.getMessage()));
                TBHomeScreenWidget.this.disableWidgetIfNeeded(new WidgetManager(), context);
            }
        });
    }

    private void disableWidgetIfNeeded(WidgetManager widgetManager, Context context) {
        widgetManager.disableWidget(context);
        Toast.makeText((Context)context, (CharSequence)"home screen widget is not available", (int)1).show();
    }

    public void onDisabled(Context context) {
        WidgetRefreshJob.cancelScheduledJob(context);
    }

    public void onReceive(final Context context, final Intent intent) {
        super.onReceive(context, intent);
        WidgetBridgeInternal.getWidgetManagerAsync(new IWidgetManager.WidgetManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IWidgetManager manager) {
                TBHomeScreenWidget.this.handleIntent(context, intent, manager);
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                Log.e((String)TAG, (String)"onManagerRetrieveFailed: cannot handle intent, failed to get widget manager");
            }
        });
    }

    private void handleIntent(Context context, Intent intent, IWidgetManager widgetManager) {
        TBWidgetAnalyticsManager analyticsManager = widgetManager.getTbWidgetAnalyticsManager();
        if ("android.appwidget.action.APPWIDGET_UPDATE".equals(intent.getAction())) {
            ComponentName componentName;
            AppWidgetManager appWidgetManager = AppWidgetManager.getInstance((Context)context);
            int[] appWidgetIds = appWidgetManager.getAppWidgetIds(componentName = new ComponentName(context, TBHomeScreenWidget.class));
            if (appWidgetIds != null && appWidgetIds.length > 0) {
                Log.i((String)TAG, (String)"onReceive: trigger widget update");
                appWidgetManager.notifyAppWidgetViewDataChanged(appWidgetIds, R.id.tbWidgetList);
                this.onUpdate(context, appWidgetManager, appWidgetIds);
            }
            if (intent.getStringExtra(WIDGET_REFRESH_REASON) != null) {
                String reasonMessage = intent.getStringExtra(WIDGET_REFRESH_REASON);
                if (reasonMessage.equals(NO_CONTENT_REASON)) {
                    analyticsManager.sendWidgetAppRefreshEvent(NO_CONTENT_REASON);
                } else if (reasonMessage.equals(NO_INTERNET_REASON)) {
                    analyticsManager.sendWidgetAppRefreshEvent(NO_INTERNET_REASON);
                }
            }
        }
        if (WIDGET_ITEM_ACTION_CLICK.equals(intent.getAction())) {
            Bundle extras = intent.getExtras();
            Intent openWidgetItemIntent = new Intent("com.taboola.android.plus.home.screen.widget.ITEM_CLICK_ACTION");
            if (extras != null) {
                openWidgetItemIntent.putExtras(extras);
            }
            openWidgetItemIntent.setFlags(0x34000000);
            PackageManager manager = context.getApplicationContext().getPackageManager();
            if (intent.resolveActivity(manager) != null) {
                context.startActivity(openWidgetItemIntent);
            } else {
                Log.d((String)TAG, (String)"No Activity available to handle action");
            }
            this.sendClickEvent(analyticsManager, extras);
        }
        if (OPEN_APP_ACTION.equals(intent.getAction())) {
            PackageManager manager = context.getApplicationContext().getPackageManager();
            Intent openAppIntent = manager.getLaunchIntentForPackage(context.getApplicationContext().getPackageName());
            if (openAppIntent != null) {
                context.startActivity(openAppIntent);
            } else {
                Logger.e((String)TAG, (String)"Unable to launch main activity");
            }
            analyticsManager.sendWidgetOpenAppEvent();
        }
    }

    private void sendClickEvent(TBWidgetAnalyticsManager analyticsManager, Bundle extras) {
        TBRecommendationItem item;
        TBPlacement placement = (TBPlacement)extras.getParcelable("widget_placement");
        int itemIndex = extras.getInt("widget_clicked_item_position");
        if (placement != null && !placement.getItems().isEmpty() && itemIndex != -1 && itemIndex < placement.getItems().size() && (item = (TBRecommendationItem)placement.getItems().get(itemIndex)) != null) {
            String itemId = PlacementSharedUtil.getItemId(item);
            String clickUrl = PlacementSharedUtil.getItemClickUrl(item);
            String itemTitle = PlacementSharedUtil.getItemTitle(item);
            boolean isOrganic = PlacementSharedUtil.isItemOrganic(item);
            analyticsManager.sendClickOnWidgetItemEvent(placement, itemId, clickUrl, itemTitle, isOrganic);
        }
    }
}

