/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.news;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsBridgeInternal;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsConfig;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsLocalStorage;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsManager;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsRefreshJob;
import com.taboola.android.plus.home.screen.news.IHomeScreenNewsManager;

@RequiresApi(api=21)
public class HomeScreenNewsRetryReceiver
extends BroadcastReceiver {
    private static final String TAG = HomeScreenNewsRetryReceiver.class.getSimpleName();
    static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    static final int REQUEST_CODE_RESCHEDULE = 1000;

    public void onReceive(final Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"onReceive: Android version is less than LOLLIPOP. RetryReceiver Shouldn't have been launched.");
            return;
        }
        Log.d((String)TAG, (String)"onReceive() called ");
        int reqCode = intent.getIntExtra(INTENT_KEY_REQUEST_CODE, -1);
        if (reqCode != 1000) {
            throw new IllegalStateException("Illegal request code");
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Log.i((String)TAG, (String)"onReceive:  network is unavailable");
        } else {
            HomeScreenNewsBridgeInternal.getHomeScreenNewsManagerAsync(new IHomeScreenNewsManager.HomeScreenNewsManagerInternalCallback(){

                @Override
                public void onManagerRetrieved(IHomeScreenNewsManager manager) {
                    HomeScreenNewsConfig homeScreenNewsConfig = manager.getHomeScreenNewsConfig();
                    HomeScreenNewsRetryReceiver.this.onConfigFetched(context.getApplicationContext(), homeScreenNewsConfig);
                }

                @Override
                public void onManagerRetrieveFailed(Throwable t) {
                    Log.w((String)TAG, (String)"onManagerRetrieveFailed: ", (Throwable)t);
                }
            });
        }
    }

    private void onConfigFetched(Context appContext, HomeScreenNewsConfig homeScreenNewsConfig) {
        HomeScreenNewsLocalStorage homeScreenLocalStorage = new HomeScreenNewsLocalStorage(appContext);
        if (ConditionCheckUtil.didMinTriggerIntervalPass(homeScreenLocalStorage.getLastRunningHomeScreenTime(), homeScreenNewsConfig.getHomeScreenMinIntervalBetweenRenderMs(), System.currentTimeMillis())) {
            if (!ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenNewsConfig.getMaxTriggerCountPerDay(), homeScreenLocalStorage.getCountOfRunningHomeScreenToday())) {
                boolean wasShownSuccessfully = HomeScreenNewsManager.triggerHsnIfNeeded(appContext, homeScreenNewsConfig);
                if (wasShownSuccessfully) {
                    HomeScreenNewsRefreshJob.reschedulePeriodicInvitation(appContext, homeScreenNewsConfig.getHomeScreenRefreshIntervalMs());
                }
            } else {
                Log.i((String)TAG, (String)"onConfigsFetched: Daily limit is reached, not showing feed invitation");
            }
        } else {
            Log.i((String)TAG, (String)"onConfigsFetched: Min trigger interval isn't reached, not showing feed invitation");
        }
    }
}

