/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.news;

import android.annotation.SuppressLint;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsBridgeInternal;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsConfig;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsLocalRepository;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsLocalStorage;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsManager;
import com.taboola.android.plus.home.screen.news.IHomeScreenNewsManager;

@RequiresApi(api=21)
public class HomeScreenNewsRefreshJob
extends JobService {
    private static final String TAG = HomeScreenNewsRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 12558913;
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900001L;

    @SuppressLint(value={"JobSchedulerService"})
    static void schedulePeriodicInvitation(@NonNull Context context, long refreshIntervalMs) {
        Log.d((String)TAG, (String)"schedulePeriodicInvitation() called");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ComponentName componentName = new ComponentName(context, HomeScreenNewsRefreshJob.class);
        HomeScreenNewsLocalRepository.setLastUsedRunningHomeScreenIntervalMs(context, refreshIntervalMs);
        long actualRefreshInterval = Math.max(900001L, refreshIntervalMs);
        JobInfo.Builder builder = new JobInfo.Builder(12558913, componentName);
        builder.setPeriodic(actualRefreshInterval);
        builder.setPersisted(true);
        jobScheduler.schedule(builder.build());
    }

    static void reschedulePeriodicInvitation(Context context, long refreshIntervalMs) {
        HomeScreenNewsRefreshJob.cancelPeriodicInvitation(context);
        HomeScreenNewsRefreshJob.schedulePeriodicInvitation(context, refreshIntervalMs);
    }

    static void cancelPeriodicInvitation(Context context) {
        Log.d((String)TAG, (String)"cancelPeriodicInvitation() called");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(12558913);
        }
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        if (!ConditionCheckUtil.isNetworkAvailable(this.getApplicationContext())) {
            Log.i((String)TAG, (String)"onStartJob: network is unavailable");
            return false;
        }
        HomeScreenNewsBridgeInternal.getHomeScreenNewsManagerAsync(new IHomeScreenNewsManager.HomeScreenNewsManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IHomeScreenNewsManager manager) {
                HomeScreenNewsConfig homeScreenNewsConfig = manager.getHomeScreenNewsConfig();
                HomeScreenNewsRefreshJob.this.onConfigFetched(homeScreenNewsConfig);
                HomeScreenNewsRefreshJob.this.jobFinished(params, false);
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                Log.w((String)TAG, (String)"onManagerRetrieveFailed: ", (Throwable)t);
                HomeScreenNewsRefreshJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    private void onConfigFetched(HomeScreenNewsConfig homeScreenNewsConfig) {
        HomeScreenNewsLocalStorage homeScreenLocalStorage = new HomeScreenNewsLocalStorage(this.getApplicationContext());
        if (HomeScreenNewsManager.didRefreshIntervalPass(this.getApplicationContext(), homeScreenNewsConfig.getHomeScreenRefreshIntervalMs())) {
            if (ConditionCheckUtil.didMinTriggerIntervalPass(homeScreenLocalStorage.getLastRunningHomeScreenTime(), homeScreenNewsConfig.getHomeScreenMinIntervalBetweenRenderMs(), System.currentTimeMillis())) {
                if (!ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenNewsConfig.getMaxTriggerCountPerDay(), homeScreenLocalStorage.getCountOfRunningHomeScreenToday())) {
                    HomeScreenNewsManager.triggerHsnIfNeeded(this.getApplicationContext(), homeScreenNewsConfig);
                } else {
                    Log.i((String)TAG, (String)"onStartJob: Daily limit is reached, not showing feed invitation");
                }
            } else {
                Log.i((String)TAG, (String)"onStartJob:  Min trigger interval didn't pass, not showing feed invitation");
            }
        } else {
            Log.v((String)TAG, (String)"onStartJob: refresh interval didn't pass");
        }
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    static boolean isJobRunning(@NonNull Context context) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 12558913) continue;
                return true;
            }
        }
        return false;
    }
}

