/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.news;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.format.DateUtils;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.InternalFeatureInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsAnalyticsManager;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsConfig;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsLocalRepository;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsLocalStorage;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsRefreshJob;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsRetryReceiver;
import com.taboola.android.plus.home.screen.news.IHomeScreenNewsManager;
import com.taboola.android.plus.home.screen.news.utils.HomeScreenNewsConfigValidator;
import com.taboola.android.utils.Logger;
import java.util.List;

@Keep
@RequiresApi(api=21)
public class HomeScreenNewsManager
extends IHomeScreenNewsManager {
    private static final String TAG = HomeScreenNewsManager.class.getSimpleName();
    public static final String TB_HOME_SCREEN = "com.taboola.android.plus.home.screen.news.OPEN_HOME_SCREEN";
    public static final String HOME_SCREEN_URL_TO_OPEN = "home_screen_url_to_open";
    public static final String HOME_SCREEN_PLACEMENT_TO_OPEN = "home_screen_placement_to_open";
    private static final long DEFAULT_INVITATION_REFRESH_INTERVAL_MS = 900000L;
    private static final long RETRY_INTERVAL_MS = 60000L;
    private static final int IMPORTANCE_TOP_SLEEPING_28 = 325;
    private static HomeScreenNewsManager singleton = null;
    private static Context appContext;
    private boolean isHSNInitialized = false;
    private HomeScreenNewsLocalStorage homeScreenNewsLocalStorage;
    private HomeScreenNewsConfig homeScreenNewsConfig;
    private static HomeScreenNewsAnalyticsManager homeScreenNewsAnalyticsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HomeScreenNewsManager getInstance() {
        Log.d((String)TAG, (String)"getInstance() called");
        if (singleton != null) return singleton;
        Class<HomeScreenNewsManager> clazz = HomeScreenNewsManager.class;
        synchronized (HomeScreenNewsManager.class) {
            if (singleton != null) return singleton;
            singleton = new HomeScreenNewsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static void setApplicationContext(Context context) {
        appContext = context;
        if (appContext == null) {
            Log.e((String)TAG, (String)"setApplicationContext: context is null");
        } else {
            Log.d((String)TAG, (String)"setApplicationContext: context is not null");
        }
    }

    @Override
    public void init(SdkPlusCore sdkPlusCore, InternalFeatureInitCallback internalFeatureInitCallback) {
        Log.d((String)TAG, (String)("init() called with: appContext = [" + appContext + "]"));
        this.homeScreenNewsLocalStorage = new HomeScreenNewsLocalStorage(appContext);
        homeScreenNewsAnalyticsManager = new HomeScreenNewsAnalyticsManager(sdkPlusCore);
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"init: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        try {
            Log.d((String)TAG, (String)"configHomeScreenFeature() called");
            boolean isHomeScreenEnabled = this.homeScreenNewsLocalStorage.isHomeScreenEnabledByUser();
            HomeScreenNewsConfigValidator homeScreenNewsConfigValidator = new HomeScreenNewsConfigValidator();
            JsonElement homeScreenNewsConfigJsonElement = sdkPlusCore.getSdkPlusConfig().getHomeScreenNewsConfig();
            boolean isHSNConfigValid = homeScreenNewsConfigValidator.isConfigValid(homeScreenNewsConfigJsonElement);
            if (!isHSNConfigValid) {
                internalFeatureInitCallback.onFeatureInitFailed(PlusFeature.HOME_SCREEN_NEWS, new Exception("Home screen news config is invalid "));
                this.isHSNInitialized = false;
            } else {
                this.homeScreenNewsConfig = homeScreenNewsConfigValidator.parseConfig(homeScreenNewsConfigJsonElement, HomeScreenNewsConfig.class);
                if (this.homeScreenNewsConfig != null && this.homeScreenNewsConfig.isHomeScreenFeatureEnabled()) {
                    this.isHSNInitialized = true;
                    if (isHomeScreenEnabled) {
                        if (HomeScreenNewsRefreshJob.isJobRunning(appContext)) {
                            if (HomeScreenNewsLocalRepository.getLastUsedRunningHomeScreenIntervalMs(appContext) != this.homeScreenNewsConfig.getHomeScreenRefreshIntervalMs()) {
                                HomeScreenNewsRefreshJob.reschedulePeriodicInvitation(appContext, this.homeScreenNewsConfig.getHomeScreenRefreshIntervalMs());
                            }
                        } else {
                            HomeScreenNewsRefreshJob.schedulePeriodicInvitation(appContext, this.homeScreenNewsConfig.getHomeScreenRefreshIntervalMs());
                        }
                    } else {
                        Log.i((String)TAG, (String)"Home screen news is not enabled");
                        HomeScreenNewsRefreshJob.cancelPeriodicInvitation(appContext);
                    }
                } else {
                    Log.i((String)TAG, (String)"Home screen news is disabled in config or config is null");
                    HomeScreenNewsRefreshJob.cancelPeriodicInvitation(appContext);
                }
                internalFeatureInitCallback.onFeatureInitSuccessful(PlusFeature.HOME_SCREEN_NEWS);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("error while parsing home screen news config " + e));
            internalFeatureInitCallback.onFeatureInitFailed(PlusFeature.HOME_SCREEN_NEWS, new Exception("error while parsing home screen news config ", e));
        }
    }

    @Override
    public void rescheduleJobIfNeeded() {
        if (this.homeScreenNewsConfig.isHomeScreenFeatureEnabled()) {
            if (HomeScreenNewsRefreshJob.isJobRunning(appContext)) {
                Log.i((String)TAG, (String)"rescheduleJobIfNeeded: job is already scheduled, no actions needed");
            } else {
                HomeScreenNewsRefreshJob.schedulePeriodicInvitation(appContext, this.homeScreenNewsConfig.getHomeScreenRefreshIntervalMs());
                Log.i((String)TAG, (String)"rescheduleJobIfNeeded: rescheduleJobIfNeeded: successfully restored notification refresh job");
            }
        } else {
            Log.d((String)TAG, (String)"rescheduleJobIfNeeded: home Screen News feature is disabled");
        }
    }

    @Override
    public boolean isInitialized() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.d((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
            this.isHSNInitialized = false;
        }
        return this.isHSNInitialized;
    }

    @Override
    public boolean isHomeScreenEnabled() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.d((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
            return false;
        }
        if (this.isInitialized()) {
            Log.d((String)TAG, (String)"isHomeScreenEnabledByUser() called");
            return this.homeScreenNewsLocalStorage.isHomeScreenEnabledByUser();
        }
        Log.w((String)TAG, (String)"isHomeScreenEnabled: Home screen not Initialized");
        return false;
    }

    @Override
    public void setHomeScreenEnabled(boolean isEnabled) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"setHomeScreenEnabled: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        Log.d((String)TAG, (String)("onSwitchToggled() called with: isChecked = [" + isEnabled + "]"));
        if (this.isInitialized()) {
            this.homeScreenNewsLocalStorage.setIsHomeScreenEnabledByUser(isEnabled);
            if (!isEnabled) {
                HomeScreenNewsRefreshJob.cancelPeriodicInvitation(appContext);
                HomeScreenNewsManager.cancelInvitationRetry(appContext);
            } else if (this.homeScreenNewsConfig != null && ConditionCheckUtil.isNetworkAvailable(appContext)) {
                this.handleHomeScreenEnabled(this.homeScreenNewsConfig);
            } else {
                Log.e((String)TAG, (String)"home screen config is null or network is not available now");
                if (!HomeScreenNewsRefreshJob.isJobRunning(appContext)) {
                    Log.i((String)TAG, (String)"Home screen news config isn't available, scheduling job with default refresh interval");
                    HomeScreenNewsRefreshJob.schedulePeriodicInvitation(appContext, 900000L);
                }
            }
        } else {
            Log.w((String)TAG, (String)"setHomeScreenEnabled: Home screen not Initialized");
        }
    }

    private void handleHomeScreenEnabled(final HomeScreenNewsConfig homeScreenNewsConfig) {
        if (!homeScreenNewsConfig.isHomeScreenFeatureEnabled()) {
            Log.i((String)TAG, (String)"handleHomeScreenEnabled: home screen is disabled in config");
            HomeScreenNewsRefreshJob.cancelPeriodicInvitation(appContext);
            HomeScreenNewsManager.cancelInvitationRetry(appContext);
            return;
        }
        if (!ConditionCheckUtil.didMinTriggerIntervalPass(this.homeScreenNewsLocalStorage.getLastRunningHomeScreenTime(), homeScreenNewsConfig.getHomeScreenMinIntervalBetweenRenderMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"handleHomeScreenEnabled: Min trigger interval isn't reached, not showing HSN");
            return;
        }
        if (ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenNewsConfig.getMaxTriggerCountPerDay(), this.homeScreenNewsLocalStorage.getCountOfRunningHomeScreenToday())) {
            Log.i((String)TAG, (String)"handleHomeScreenEnabled: Daily limit is reached, not showing HSN");
            return;
        }
        HomeScreenNewsLocalRepository.setLastRunningHomeScreenTimestamp(appContext, 0L);
        HomeScreenNewsManager.triggerHsnIfNeeded(appContext, homeScreenNewsConfig);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HomeScreenNewsRefreshJob.schedulePeriodicInvitation(appContext, homeScreenNewsConfig.getHomeScreenRefreshIntervalMs());
            }
        }, 5000L);
    }

    @Override
    public void reportHomeScreenOpened() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"reportHomeScreenOpened: Android version is less than LOLLIPOP. HSN Couldn't have opened.");
            return;
        }
        Log.d((String)TAG, (String)"reportHomeScreenOpened() called");
        this.updateSuccessfulOpenCounter(this.homeScreenNewsLocalStorage.getLastRunningHomeScreenTime());
        this.homeScreenNewsLocalStorage.setLastRunningHomeScreenTime(System.currentTimeMillis());
        homeScreenNewsAnalyticsManager.sendHomeScreenNewsDisplayedEvent();
    }

    private void updateSuccessfulOpenCounter(long lastRunningHomeScreenTime) {
        if (!DateUtils.isToday((long)lastRunningHomeScreenTime)) {
            this.homeScreenNewsLocalStorage.setCountOfRunningHomeScreenToday(0);
        }
        int counter = this.homeScreenNewsLocalStorage.getCountOfRunningHomeScreenToday();
        this.homeScreenNewsLocalStorage.setCountOfRunningHomeScreenToday(++counter);
    }

    static boolean triggerHsnIfNeeded(@NonNull Context context, @NonNull HomeScreenNewsConfig homeScreenNewsConfig) {
        if (TBDeviceInfoUtil.isDeviceLocked(context)) {
            if (HomeScreenNewsManager.isAppAtTheTop(context)) {
                Log.i((String)TAG, (String)"Home Screen News is locked and invitation is already shown. No action needed");
            } else {
                Log.d((String)TAG, (String)" Home Screen News is locked and invitation is not yet shown");
                HomeScreenNewsManager.cancelInvitationRetry(context);
                if (ConditionCheckUtil.isBlockedByAllowedTimeWindows(homeScreenNewsConfig.getAllowedIntervals())) {
                    Log.i((String)TAG, (String)"Home Screen News is not shown because it is currently not within Allowed Time Windows");
                } else {
                    Log.d((String)TAG, (String)"Home Screen News trigger is allowed by Allowed Time Windows");
                    HomeScreenNewsManager.sendHomeScreenBroadcast(context, homeScreenNewsConfig.getUrlToOpen(), homeScreenNewsConfig.getPlacementToOpen());
                }
            }
            return true;
        }
        Log.i((String)TAG, (String)"Screen is not locked, not showing HSN");
        HomeScreenNewsManager.retryInvitationFaster(context);
        return false;
    }

    static boolean didRefreshIntervalPass(Context context, long refreshIntervalMs) {
        long timeSinceLastRefreshMs = System.currentTimeMillis() - HomeScreenNewsLocalRepository.getLastRunningHomeScreenTimestamp(context);
        return timeSinceLastRefreshMs >= refreshIntervalMs;
    }

    private static void retryInvitationFaster(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                alarmManager.setExactAndAllowWhileIdle(1, System.currentTimeMillis() + 60000L, HomeScreenNewsManager.getRetryIntent(context));
            } else {
                alarmManager.set(1, System.currentTimeMillis() + 60000L, HomeScreenNewsManager.getRetryIntent(context));
            }
        }
    }

    static void cancelInvitationRetry(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.cancel(HomeScreenNewsManager.getRetryIntent(context));
        }
    }

    private static PendingIntent getRetryIntent(Context context) {
        Intent rescheduledIntent = new Intent(context, HomeScreenNewsRetryReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt("intent_key_request_code", 1000);
        rescheduledIntent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)1000, (Intent)rescheduledIntent, (int)0x8000000);
    }

    private static boolean isAppAtTheTop(Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            return HomeScreenNewsManager.isAppAtTheTop28Plus(context);
        }
        return HomeScreenNewsManager.isAppAtTheTopBefore28(context);
    }

    @TargetApi(value=27)
    private static boolean isAppAtTheTopBefore28(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am != null) {
            List runningProcesses = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                Log.v((String)TAG, (String)("isAppAtTheTopBefore28: processInfo.importance = " + processInfo.importance));
                if (processInfo.importance != 100 && processInfo.importance != 230 && processInfo.importance != 325 && processInfo.importance != 130) continue;
                for (String activeProcess : processInfo.pkgList) {
                    if (!activeProcess.equals(context.getPackageName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @RequiresApi(api=28)
    private static boolean isAppAtTheTop28Plus(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
            Log.v((String)TAG, (String)("isAppAtTheTop28Plus: processInfo.importance = " + processInfo.importance));
            if (processInfo.importance != 100 && processInfo.importance != 325 && processInfo.importance != 230) continue;
            for (String activeProcess : processInfo.pkgList) {
                if (!activeProcess.equals(context.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void sendHomeScreenBroadcast(Context appContext, String urlToOpen, String placementName) {
        Intent intent = new Intent();
        intent.setAction(TB_HOME_SCREEN);
        intent.setPackage(appContext.getPackageName());
        intent.putExtra(HOME_SCREEN_URL_TO_OPEN, urlToOpen);
        intent.putExtra(HOME_SCREEN_PLACEMENT_TO_OPEN, placementName);
        homeScreenNewsAnalyticsManager.sendHomeScreenNewsTriggeredEvent();
        appContext.sendBroadcast(intent);
        Log.d((String)TAG, (String)"sendHomeScreenBroadcast: HSN trigger broadcast sent");
    }

    @Override
    public Context getApplicationContext() {
        return appContext;
    }

    @Override
    public HomeScreenNewsConfig getHomeScreenNewsConfig() {
        return this.homeScreenNewsConfig;
    }
}

