/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.news;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.notifications.scheduled.time_window.AllowedTimeWindows;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HomeScreenNewsConfig
extends BaseConfig
implements Parcelable {
    public static final String IS_HOME_SCREEN_FEATURE_ENABLED = "isHomeScreenFeatureEnabled";
    public static final String HOME_SCREEN_REFRESH_INTERVAL_MS = "refreshIntervalMs";
    public static final String HOME_SCREEN_MIN_INTERVAL_BETWEEN_RENDER_MS = "minIntervalBetweenRenderMs";
    public static final String HOME_SCREEN_TRIGGER_PER_DAY = "maxTriggerCountPerDay";
    public static final String HOME_SCREEN_ALLOWED_TIME_WINDOWS = "allowedTimeWindows";
    private static final String URL_TO_OPEN = "urlToOpen";
    public static final String PLACEMENT_TO_OPEN = "placementToOpen";
    @SerializedName(value="refreshIntervalMs")
    private long homeScreenRefreshIntervalMs = 900000L;
    @SerializedName(value="placementToOpen")
    @NonNull
    @Size(min=0L)
    private String placementToOpen = "";
    @SerializedName(value="urlToOpen")
    @NonNull
    @Size(min=0L)
    private String urlToOpen = "";
    @SerializedName(value="minIntervalBetweenRenderMs")
    private long minIntervalBetweenRenderMs = 1200000L;
    @SerializedName(value="maxTriggerCountPerDay")
    private int maxTriggerCountPerDay = 1;
    @SerializedName(value="isHomeScreenFeatureEnabled")
    private boolean isHomeScreenFeatureEnabled;
    @SerializedName(value="allowedTimeWindows")
    @NonNull
    @Size(min=0L)
    private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();
    public static final Parcelable.Creator<HomeScreenNewsConfig> CREATOR = new Parcelable.Creator<HomeScreenNewsConfig>(){

        public HomeScreenNewsConfig createFromParcel(Parcel source) {
            return new HomeScreenNewsConfig(source);
        }

        public HomeScreenNewsConfig[] newArray(int size) {
            return new HomeScreenNewsConfig[size];
        }
    };

    public static ArrayList<String> getRequiredFields() {
        return new ArrayList<String>(Arrays.asList(IS_HOME_SCREEN_FEATURE_ENABLED, HOME_SCREEN_REFRESH_INTERVAL_MS, HOME_SCREEN_MIN_INTERVAL_BETWEEN_RENDER_MS, HOME_SCREEN_TRIGGER_PER_DAY, HOME_SCREEN_ALLOWED_TIME_WINDOWS));
    }

    protected HomeScreenNewsConfig(Parcel in) {
        this.homeScreenRefreshIntervalMs = in.readLong();
        this.placementToOpen = in.readString();
        this.urlToOpen = in.readString();
        this.minIntervalBetweenRenderMs = in.readLong();
        this.maxTriggerCountPerDay = in.readInt();
        this.isHomeScreenFeatureEnabled = in.readByte() != 0;
        ArrayList allowedIntervalsFromCreator = in.createTypedArrayList(AllowedTimeWindows.CREATOR);
        this.allowedIntervals = allowedIntervalsFromCreator != null ? allowedIntervalsFromCreator : new ArrayList();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.homeScreenRefreshIntervalMs);
        dest.writeString(this.placementToOpen);
        dest.writeString(this.urlToOpen);
        dest.writeLong(this.minIntervalBetweenRenderMs);
        dest.writeInt(this.maxTriggerCountPerDay);
        dest.writeByte(this.isHomeScreenFeatureEnabled ? (byte)1 : 0);
        dest.writeTypedList(this.allowedIntervals);
    }

    public long getHomeScreenRefreshIntervalMs() {
        return this.homeScreenRefreshIntervalMs;
    }

    public int getMaxTriggerCountPerDay() {
        return Math.max(this.maxTriggerCountPerDay, 1);
    }

    @Size(min=0L)
    @NonNull
    public String getPlacementToOpen() {
        return this.placementToOpen;
    }

    @NonNull
    @Size(min=0L)
    public String getUrlToOpen() {
        return this.urlToOpen;
    }

    public boolean isHomeScreenFeatureEnabled() {
        return this.isHomeScreenFeatureEnabled;
    }

    @NonNull
    @Size(min=0L)
    public List<AllowedTimeWindows> getAllowedIntervals() {
        return this.allowedIntervals;
    }

    public long getHomeScreenMinIntervalBetweenRenderMs() {
        return this.minIntervalBetweenRenderMs;
    }

    public int describeContents() {
        return 0;
    }
}

