/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.support.annotation.RequiresApi;
import com.google.firebase.messaging.RemoteMessage;
import com.ocamba.hoood.OcambaHoood;
import com.taboola.android.plus.core.AbsPushManager;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.IFeatureModule;
import com.taboola.android.plus.core.PushManagerCallback;
import com.taboola.android.plus.core.TaboolaSdkPlus;
import com.taboola.android.utils.Logger;
import java.util.Map;

@RequiresApi(api=21)
public abstract class TBLPushManager
implements IFeatureModule {
    private static final String TAG = TBLPushManager.class.getSimpleName();

    public abstract void removeUserTrackingDataKey(String var1);

    public abstract void sendUserTrackingData(Map<String, Object> var1);

    public abstract TBLPushManager setNotificationAppIconId(int var1);

    public abstract TBLPushManager setNotificationAppNameLabel(String var1);

    public static void handleTaboolaPush(final RemoteMessage remoteMessage) {
        Logger.d((String)TAG, (String)"handleTaboolaPush() called");
        BridgeInternalCore.getPushNotificationManagerAsync(new PushManagerCallback(){

            @Override
            public void onManagerRetrieved(AbsPushManager pushNotificationsManager) {
                pushNotificationsManager.handleTaboolaPushInternal(remoteMessage);
            }

            @Override
            public void onManagerRetrieveFailed(Throwable throwable) {
                Logger.e((String)TAG, (String)throwable.toString(), (Throwable)throwable);
            }
        });
    }

    public static void onNewFirebaseToken(String token) {
        Logger.d((String)TAG, (String)("onNewFirebaseToken() called with: token = [" + token + "]"));
        TaboolaSdkPlus.getCoreProvider().getPushNotificationsManager().onNewFirebaseTokenInternal(token);
    }

    public static boolean isTaboolaMessage(RemoteMessage remoteMessage) {
        return remoteMessage != null && !remoteMessage.getData().isEmpty() && OcambaHoood.notification().isOcambaMessage(remoteMessage);
    }
}

