/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.common.BaseConfigValidator;
import com.taboola.android.plus.core.CoreConfig;
import com.taboola.android.plus.core.kill_switch.KillSwitchConfig;

class CoreConfigValidator
extends BaseConfigValidator {
    private static final String TAG = CoreConfigValidator.class.getSimpleName();

    CoreConfigValidator() {
    }

    @Override
    public boolean isConfigValid(@NonNull JsonElement coreConfig) {
        JsonElement killSwitch = coreConfig.getAsJsonObject().get("killSwitch");
        if (!CoreConfigValidator.isObjectValid(coreConfig, CoreConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: core config is invalid");
            return false;
        }
        if (!CoreConfigValidator.isObjectValid(killSwitch, KillSwitchConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: kill switch config is invalid");
            return false;
        }
        return true;
    }

    @Override
    public <T extends BaseConfig> T parseConfig(@NonNull JsonElement config, @NonNull Class<T> type) {
        return (T)((BaseConfig)type.cast(this.gson.fromJson(config, CoreConfig.class)));
    }
}

