/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.core.AbsScheduledManager;
import com.taboola.android.plus.core.AbsWidgetManager;
import com.taboola.android.plus.core.HomeScreenNewsManagerCallback;
import com.taboola.android.plus.core.InternalSdkPlusCoreInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.PushManagerCallback;
import com.taboola.android.plus.core.ScheduledManagerCallback;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.core.TaboolaSdkPlus;
import com.taboola.android.plus.core.WidgetManagerCallback;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class BridgeInternalCore {
    private static final String TAG = "BridgeInternalCore";

    public static void onWakePushReceived(SdkPlusCore sdkPlusCore) {
        sdkPlusCore.rescheduleConfigJobIfNeeded();
        if (BridgeInternalCore.isFeatureActivated(PlusFeature.SCHEDULED_NOTIFICATIONS)) {
            Log.d((String)TAG, (String)"onWakePushReceived: scheduled notifications feature was activated during sdk+ init, checking if reschedule is required");
            BridgeInternalCore.getScheduledNotificationManagerAsync(new ScheduledManagerCallback(){

                @Override
                public void onManagerRetrieved(AbsScheduledManager scheduledNotificationManager) {
                    scheduledNotificationManager.onWakePushReceivedInternal();
                }

                @Override
                public void onManagerRetrieveFailed(Throwable throwable) {
                    Logger.e((String)BridgeInternalCore.TAG, (String)("onWakePushReceived | onManagerRetrieveFailed: " + throwable.toString()), (Throwable)throwable);
                }
            });
        } else {
            Log.i((String)TAG, (String)"onWakePushReceived: wake push ignored: scheduled notifications feature was not activated during sdk+ init");
        }
        if (BridgeInternalCore.isFeatureActivated(PlusFeature.APP_WIDGET)) {
            Log.d((String)TAG, (String)"onWakePushReceived: home screen widget feature was activated during sdk+ init, checking if reschedule is required");
            BridgeInternalCore.getWidgetManagerAsync(new WidgetManagerCallback(){

                @Override
                public void onManagerRetrieved(AbsWidgetManager manager) {
                    manager.rescheduleJobIfNeeded();
                }

                @Override
                public void onManagerFailed(Throwable t) {
                    Logger.e((String)BridgeInternalCore.TAG, (String)("onWakePushReceived | onManagerFailed: " + t.toString()), (Throwable)t);
                }
            });
        } else {
            Log.i((String)TAG, (String)"onWakePushReceived: wake push ignored: home screen feature was not activated during sdk+ init");
        }
    }

    public static boolean isFeatureActivated(PlusFeature plusFeature) {
        return TaboolaSdkPlus.isFeatureActivated(plusFeature);
    }

    public static void getSdkPlusCoreAsync(InternalSdkPlusCoreInitCallback callback) {
        TaboolaSdkPlus.getSdkPlusCoreAsync(callback);
    }

    public static void getScheduledNotificationManagerAsync(ScheduledManagerCallback callback) {
        TaboolaSdkPlus.getScheduledNotificationManagerAsync(callback);
    }

    public static void getPushNotificationManagerAsync(PushManagerCallback callback) {
        TaboolaSdkPlus.getPushNotificationManagerAsync(callback);
    }

    public static void getWidgetManagerAsync(WidgetManagerCallback callback) {
        TaboolaSdkPlus.getWidgetManagerAsync(callback);
    }

    public static void getHomeScreenNewsManagerAsync(HomeScreenNewsManagerCallback callback) {
        TaboolaSdkPlus.getHomeScreenNewsManagerAsync(callback);
    }
}

