/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.app.NotificationManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import com.taboola.android.plus.notifications.scheduled.time_window.AllowedTimeWindows;
import java.util.Calendar;
import java.util.List;

public class ConditionCheckUtil {
    private static final String TAG = ConditionCheckUtil.class.getSimpleName();

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean areNotificationChannelsSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public static boolean areNotificationsBlockedByUser(@NonNull Context appContext, @NonNull String channelId) {
        boolean areNotificationsBlocked;
        boolean bl = areNotificationsBlocked = !NotificationManagerCompat.from((Context)appContext).areNotificationsEnabled();
        if (areNotificationsBlocked) {
            return true;
        }
        if (ConditionCheckUtil.areNotificationChannelsSupported()) {
            NotificationManager androidNotificationManager = (NotificationManager)appContext.getSystemService("notification");
            if (androidNotificationManager != null) {
                return androidNotificationManager.getNotificationChannel(channelId).getImportance() == 0;
            }
            Log.e((String)TAG, (String)"areNotificationsBlockedByUser: notification service is null");
            return false;
        }
        return false;
    }

    public static boolean isBlockedByAllowedTimeWindows(@NonNull List<AllowedTimeWindows> timeIntervals) {
        return ConditionCheckUtil.isBlockedByAllowedTimeWindows(timeIntervals, System.currentTimeMillis());
    }

    public static boolean isBlockedByAllowedTimeWindows(@NonNull @Size(min=0L) List<AllowedTimeWindows> timeIntervals, long timeToCheck) {
        if (timeIntervals.isEmpty()) {
            Log.i((String)TAG, (String)"isBlockedByAllowedTimeWindows: allowed intervals list is empty");
            return false;
        }
        for (AllowedTimeWindows interval : timeIntervals) {
            if (interval.getStartHour().equals(interval.getEndHour()) && interval.getStartMin().equals(interval.getEndMin())) {
                return false;
            }
            Calendar startTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            startTime.set(11, Integer.parseInt(interval.getStartHour()));
            startTime.set(12, Integer.parseInt(interval.getStartMin()));
            endTime.set(11, Integer.parseInt(interval.getEndHour()));
            endTime.set(12, Integer.parseInt(interval.getEndMin()));
            if (timeToCheck <= startTime.getTimeInMillis() || timeToCheck >= endTime.getTimeInMillis()) continue;
            return false;
        }
        return true;
    }

    public static boolean didMinTriggerIntervalPass(long lastShownTimestamp, long minTriggerInterval, long currentTime) {
        return currentTime - lastShownTimestamp > minTriggerInterval;
    }

    public static boolean isTriggerPerDayMaxCountReached(int maxAllowedCount, int alreadyShownCount) {
        if (maxAllowedCount == -1) {
            return false;
        }
        return alreadyShownCount >= maxAllowedCount;
    }
}

