/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.monitor.MonitorHelper;
import com.taboola.android.monitor.MonitorParser;
import com.taboola.android.monitor.TBSdkFeature;
import java.util.Map;

class MonitorHandler
extends Handler {
    private static final String TAG = "MonitorHandler";
    private final MonitorHelper monitorHelper;

    MonitorHandler(MonitorHelper monitorHelper) {
        super(Looper.getMainLooper());
        this.monitorHelper = monitorHelper;
    }

    public void handleMessage(Message msg) {
        Bundle data = msg.getData();
        if (msg.what == 232) {
            try {
                String sdkFeaturesString = data.getString("MONITOR_FEATURE_SET_LIST");
                if (!TextUtils.isEmpty((CharSequence)sdkFeaturesString)) {
                    Map<Integer, TBSdkFeature> sdkFeatures = MonitorParser.parseSdkFeatures(sdkFeaturesString, true);
                    this.monitorHelper.setSdkFeatures(sdkFeatures, true);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"error while try to parse sdk features", (Throwable)e);
            }
        }
    }
}

