/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationStateReceiver;
import com.taboola.android.plus.notifications.scheduled.TBNotificationRefreshJob;
import java.util.List;

@RequiresApi(api=21)
class NotificationBackgroundJobsManager {
    private final Context applicationContext;
    private final PendingIntent autoSwitchPendingIntent;

    NotificationBackgroundJobsManager(Context applicationContext) {
        this.applicationContext = applicationContext;
        this.autoSwitchPendingIntent = this.getPendingIntentForAutoSwitch(applicationContext);
    }

    void scheduleNotificationsRefreshJob(@NonNull List<String> categories, long refreshIntervalMs) {
        if (categories != null && !categories.isEmpty()) {
            TBNotificationRefreshJob.scheduleNotificationRefreshJob(this.applicationContext, categories, refreshIntervalMs);
        }
    }

    public boolean isScheduledNotificationsRefreshJobRunning() {
        return TBNotificationRefreshJob.isJobRunning(this.applicationContext);
    }

    void scheduleContentSwitchTimer(long switchContentIntervalMs) {
        AlarmManager alarmManager = (AlarmManager)this.applicationContext.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(1, System.currentTimeMillis() + switchContentIntervalMs, this.autoSwitchPendingIntent);
        }
    }

    void stopAllBackgroundTasks() {
        this.cancelAutoSwitchTimer();
        this.cancelScheduledNotificationsRefreshJob();
    }

    void cancelAutoSwitchTimer() {
        AlarmManager alarmManager = (AlarmManager)this.applicationContext.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.cancel(this.autoSwitchPendingIntent);
        }
    }

    private void cancelScheduledNotificationsRefreshJob() {
        TBNotificationRefreshJob.cancelNotificationRefreshJob(this.applicationContext);
    }

    private PendingIntent getPendingIntentForAutoSwitch(Context context) {
        Intent intent = new Intent(context, ScheduledNotificationStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt("intent_key_request_code", 3500);
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)3500, (Intent)intent, (int)0x8000000);
    }
}

