/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.InternalFeatureInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.core.SdkPlusExecutors;
import com.taboola.android.plus.core.TBLPushManager;
import com.taboola.android.plus.notifications.push.IPushNotificationsInternal;
import com.taboola.android.plus.notifications.push.PushNotificationsConfig;
import com.taboola.android.plus.notifications.push.PushNotificationsConfigValidator;
import com.taboola.android.plus.notifications.push.PushNotificationsLocalStorage;
import com.taboola.android.plus.notifications.push.PushNotificationsUtil;
import com.taboola.android.plus.notifications.push.PushValidationUtil;
import com.taboola.android.plus.notifications.push.TBPushNotificationRenderer;
import com.taboola.android.plus.notifications.push.TBPushNotificationsAnalyticsManager;
import com.taboola.android.plus.notifications.push.models.BreakingNotificationContent;
import com.taboola.android.plus.notifications.push.models.TBPushRawData;
import com.taboola.android.plus.notifications.push.models.WakeUpContent;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@RequiresApi(api=21)
public class TBPushNotificationsManager
extends IPushNotificationsInternal {
    private static final String TAG = TBPushNotificationsManager.class.getSimpleName();
    private SdkPlusCore sdkPlusCore;
    private Context appContext;
    private SharedLocalStorage sharedLocalStorage;
    private TBPushNotificationRenderer renderer;
    private SdkPlusExecutors sdkPlusExecutors;
    private AdvertisingIdInfo advertisingId;
    private PushNotificationsLocalStorage pushLocalStorage;
    private Gson gson;
    private PushNotificationsUtil pushNotificationsUtil;
    private HashSet<String> reservedTrackDataKeys = new HashSet();
    private TBPushNotificationsAnalyticsManager analyticsManager;
    private PushNotificationsConfig pushNotificationsConfig;
    private LocalizationStrings localizationStrings;
    private boolean isInitialized;

    public TBPushNotificationsManager(Context appContext) {
        this.appContext = appContext;
        this.pushLocalStorage = new PushNotificationsLocalStorage(appContext);
    }

    @Override
    public void handleTaboolaPushInternal(@NonNull RemoteMessage remoteMessage) {
        Logger.d((String)TAG, (String)"handleTaboolaPushInternal: ");
        if (this.isInitialized()) {
            PushNotificationsConfig pushNotificationsConfig = this.getPushNotificationsConfig();
            boolean isPushFeatureEnabled = false;
            if (Build.VERSION.SDK_INT >= 21) {
                isPushFeatureEnabled = PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig, this.appContext);
            }
            this.analyticsManager.sendPushDeliveredToSdksEvent(remoteMessage, isPushFeatureEnabled);
            if (isPushFeatureEnabled) {
                OcambaHoood.notification().onMessageReceived(remoteMessage);
            } else {
                Logger.v((String)TAG, (String)"handleTaboolaPush: Push message ignored because push notifications feature is disabled");
            }
        } else {
            Logger.e((String)TAG, (String)"handleTaboolaPush: push manager is not initialized");
        }
    }

    @Override
    public void onNewFirebaseTokenInternal(String token) {
        boolean isPushFeatureEnabled = false;
        if (this.isInitialized()) {
            PushNotificationsConfig pushNotificationsConfig = this.getPushNotificationsConfig();
            isPushFeatureEnabled = PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig, this.appContext);
        }
        Logger.d((String)TAG, (String)("onNewFirebaseTokenInternal() called with: token = [" + token + "]"));
        if (isPushFeatureEnabled) {
            this.sendFirebaseToken(token);
        } else {
            this.cacheFirebaseToken(token);
        }
    }

    @Override
    public void handleClick(@NonNull Bundle extras, @NonNull Context activityContext) {
        String clickUrl;
        BreakingNotificationContent content = (BreakingNotificationContent)extras.getParcelable("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT");
        String string = clickUrl = content != null ? content.getUrl() : null;
        if (!TextUtils.isEmpty((CharSequence)clickUrl)) {
            if (this.pushNotificationsConfig.isManualClickHandlingEnabled()) {
                this.handleManualClick(content, activityContext);
            } else {
                PushNotificationsUtil.openBreakingUrl(this.getAnalyticsManagerInternal(), content, activityContext, clickUrl);
            }
        } else {
            Logger.e((String)TAG, (String)"handleClick: Click url is empty");
        }
    }

    private void handleManualClick(BreakingNotificationContent content, Context activityContext) {
        try {
            Logger.d((String)TAG, (String)"handleManualClick");
            Intent intent = new Intent("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_CLICK");
            intent.putExtra("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_URL", content.getUrl());
            intent.setPackage(activityContext.getPackageName());
            intent.setFlags(0x34000000);
            activityContext.startActivity(intent);
            Logger.d((String)TAG, (String)"handleManualClick: url was sent to activity");
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.getMessage());
        }
    }

    @Override
    public TBPushNotificationsAnalyticsManager getAnalyticsManagerInternal() {
        return this.analyticsManager;
    }

    private void sendFirebaseToken(String token) {
        try {
            OcambaHoood.notification().pushToken(token);
            Logger.d((String)TAG, (String)("sendFirebaseToken() called with: token = [" + token + "]"));
            this.pushLocalStorage.setFirebaseToken(null);
        }
        catch (Exception e) {
            Logger.d((String)TAG, (String)("onNewFirebaseToken error " + e));
        }
    }

    private void sendOcambaTrackingData(SharedLocalStorage sharedLocalStorage, @NonNull Context appContext, @NonNull String nonLocalizedPublisher, @NonNull String localizedPublisherName, @NonNull String configVariant) {
        HashMap<String, String> trackData = new HashMap<String, String>();
        String device_id = this.advertisingId.getAdvertisingId();
        trackData.put("device_id", device_id);
        trackData.put("os_name", "Android");
        trackData.put("platform", "Android");
        trackData.put("os_version", Build.VERSION.RELEASE);
        trackData.put("device_model", TBDeviceInfoUtil.getDeviceName());
        trackData.put("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        trackData.put("appId", appContext.getPackageName());
        trackData.put("device_manufacturer", Build.MANUFACTURER);
        trackData.put("device_brand", Build.MANUFACTURER);
        trackData.put("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        trackData.put("language", Locale.getDefault().getLanguage().toUpperCase());
        trackData.put("adid", device_id);
        trackData.put("sdk+(TaboolaPlus)version", "2.0.4");
        trackData.put("sdk(TaboolaApi)version", "2.5.0");
        trackData.put("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, appContext).toUpperCase());
        trackData.put("publisher", nonLocalizedPublisher);
        trackData.put("localizedPublisher", localizedPublisherName);
        trackData.put("configVariant", configVariant);
        OcambaHoood.track(trackData);
        OcambaHoood.sendTrack();
        Logger.d((String)TAG, (String)("sendPushTrackingData() called with: = [" + trackData.toString() + "]"));
    }

    private void createReservedTrackDataKeys() {
        this.reservedTrackDataKeys = new HashSet();
        this.reservedTrackDataKeys.add("device_id");
        this.reservedTrackDataKeys.add("os_name");
        this.reservedTrackDataKeys.add("platform");
        this.reservedTrackDataKeys.add("os_version");
        this.reservedTrackDataKeys.add("device_model");
        this.reservedTrackDataKeys.add("app_version");
        this.reservedTrackDataKeys.add("appId");
        this.reservedTrackDataKeys.add("device_manufacturer");
        this.reservedTrackDataKeys.add("device_brand");
        this.reservedTrackDataKeys.add("carrier");
        this.reservedTrackDataKeys.add("language");
        this.reservedTrackDataKeys.add("adid");
        this.reservedTrackDataKeys.add("sdk+(TaboolaPlus)version");
        this.reservedTrackDataKeys.add("sdk(TaboolaApi)version");
        this.reservedTrackDataKeys.add("simCountry");
        this.reservedTrackDataKeys.add("publisher");
        this.reservedTrackDataKeys.add("localizedPublisher");
        this.reservedTrackDataKeys.add("configVariant");
    }

    private void cacheFirebaseToken(String token) {
        this.pushLocalStorage.setFirebaseToken(token);
        Logger.d((String)TAG, (String)("cacheFirebaseToken() called with: token = [" + token + "]"));
    }

    @Override
    public void removeUserTrackingDataKey(String key) {
        try {
            if (this.reservedTrackDataKeys.contains(key)) {
                Logger.e((String)TAG, (String)("removeUserTrackingDataKey can't remove key " + key));
                return;
            }
            OcambaHoood.track((String)key, (String)"");
            OcambaHoood.sendTrack();
            Logger.d((String)TAG, (String)("removeUserTrackingDataKey() called with: = [ " + key + "]"));
            this.analyticsManager.sendTrackingDataRemoveEvent(key);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("removeUserTrackingDataKey error " + e.toString()), (Throwable)e);
        }
    }

    @Override
    public void sendUserTrackingData(Map<String, Object> trackingData) {
        try {
            HashMap<String, Object> trackData = this.filterOutReservedKeys(trackingData);
            OcambaHoood.track(trackData);
            OcambaHoood.sendTrack();
            String trackingDataAsString = trackData.toString();
            Logger.d((String)TAG, (String)("sendUserTrackingData() called with: = [ " + trackingDataAsString + "]"));
            this.analyticsManager.sendTrackingDataUpdateEvent(trackingDataAsString);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendUserTrackingData error " + e.toString()), (Throwable)e);
        }
    }

    @CheckResult
    private HashMap<String, Object> filterOutReservedKeys(Map<String, Object> trackingDataMap) {
        if (trackingDataMap == null || trackingDataMap.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> newTrackingData = new HashMap<String, Object>();
        for (String key : trackingDataMap.keySet()) {
            Object value;
            if (this.reservedTrackDataKeys.contains(key) || (value = trackingDataMap.get(key)) == null) continue;
            newTrackingData.put(key, value);
        }
        return newTrackingData;
    }

    @Override
    public PushNotificationsConfig getPushNotificationsConfig() {
        return this.pushNotificationsConfig;
    }

    @Override
    public void renderBreakingNotification(BreakingNotificationContent breakingNotificationContent) {
        this.analyticsManager.sendPushBreakingPreRenderEvent(breakingNotificationContent);
        TBPushNotificationRenderer.RenderResult renderResult = this.renderer.renderNotification(breakingNotificationContent, this.pushNotificationsConfig);
        if (renderResult.isSuccessful()) {
            this.analyticsManager.sendPushBreakingRenderEvent(breakingNotificationContent);
        } else {
            Logger.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.analyticsManager.sendPushBreakingFailedToRenderEvent(breakingNotificationContent, renderResult.getErrorMessage());
        }
    }

    @Override
    public void dismissNotification() {
        try {
            Logger.v((String)TAG, (String)"dismissPushNotification");
            this.renderer.dismissNotification();
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("dismissNotification: " + e), (Throwable)e);
        }
    }

    @Override
    public boolean handleNotificationBlockByUser() {
        boolean isBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(this.appContext, "Breaking News");
        boolean isBlockedBySystem = this.sharedLocalStorage.isNotificationBlockBySystem();
        this.analyticsManager.sendCheckNotificationDisabledStatusEvent(isBlockedByUser);
        this.sharedLocalStorage.setIsNotificationBlockBySystem(isBlockedByUser);
        if (isBlockedByUser) {
            if (!isBlockedBySystem) {
                this.analyticsManager.sendNotificationDisabledBySystemEvent();
                this.sharedLocalStorage.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (isBlockedBySystem) {
            this.analyticsManager.sendNotificationEnabledBySystemEvent();
            this.sharedLocalStorage.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    @Override
    public LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void init(final @NonNull SdkPlusCore sdkPlusCore, final @NonNull String publisherName, final @NonNull InternalFeatureInitCallback callback) {
        String pushApiKey;
        this.sdkPlusCore = sdkPlusCore;
        this.analyticsManager = new TBPushNotificationsAnalyticsManager(sdkPlusCore);
        this.sharedLocalStorage = sdkPlusCore.getSharedLocalStorage();
        this.pushNotificationsUtil = new PushNotificationsUtil(this.pushLocalStorage, this.appContext);
        this.renderer = new TBPushNotificationRenderer(this.appContext, this, this.pushNotificationsUtil);
        this.sdkPlusExecutors = sdkPlusCore.getSdkPlusExecutors();
        this.advertisingId = sdkPlusCore.getAdvertisingIdInfo();
        this.gson = sdkPlusCore.getGson();
        this.createReservedTrackDataKeys();
        try {
            this.localizationStrings = sdkPlusCore.getLocalizationStrings();
            PushNotificationsConfigValidator pushValidator = new PushNotificationsConfigValidator();
            JsonElement pushNotificationsConfigJsonElement = sdkPlusCore.getSdkPlusConfig().getPushNotificationsConfig();
            boolean isPushConfigValid = pushValidator.isConfigValid(pushNotificationsConfigJsonElement);
            if (!isPushConfigValid) {
                callback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, new Exception("Push config is invalid "));
                return;
            }
            this.pushNotificationsConfig = pushValidator.parseConfig(pushNotificationsConfigJsonElement, PushNotificationsConfig.class);
            pushApiKey = this.pushNotificationsConfig.getApiKey(this.appContext);
            if (TextUtils.isEmpty((CharSequence)pushApiKey)) {
                callback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, new Exception("Push config is invalid "));
                return;
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("error while parsing push config " + e));
            callback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, new Exception("error while parsing push config ", e));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)publisherName)) {
            callback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, new IllegalStateException("Missing publisher_id to init push"));
            return;
        }
        final String configVariant = sdkPlusCore.getSdkPlusConfig().getCoreConfig().getConfigVariant();
        TBPushNotificationsManager.verifyPushNotificationsLocalStorage(this.pushLocalStorage, this.appContext);
        String savedFirebaseToken = this.pushLocalStorage.getFirebaseToken();
        if (!TextUtils.isEmpty((CharSequence)savedFirebaseToken)) {
            this.sendFirebaseToken(savedFirebaseToken);
        }
        OcambaHoood.push().setPushResponse(new OcambaResponseCallback(){

            public void onFailure(final Exception e) {
                Logger.e((String)TAG, (String)("initPushNotifications error while init push " + e.getLocalizedMessage()), (Throwable)e);
                TBPushNotificationsManager.this.analyticsManager.sendInitFailedEvent(e);
                TBPushNotificationsManager.this.isInitialized = false;
                TBPushNotificationsManager.this.sdkPlusExecutors.getMainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, e);
                    }
                });
            }

            public void onResponse(int code, String response) {
                Logger.d((String)TAG, (String)("initPushNotifications.onResponse() called with: code = [" + code + "], response = [" + response + "]"));
                OcambaHoood.notification().customLayout();
                TBPushNotificationsManager.this.sendOcambaTrackingData(TBPushNotificationsManager.this.sharedLocalStorage, TBPushNotificationsManager.this.appContext, publisherName, sdkPlusCore.getLocalizedPublisherName(), configVariant);
                TBPushNotificationsManager.this.isInitialized = true;
                TBPushNotificationsManager.this.sdkPlusExecutors.getMainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFeatureInitSuccessful(PlusFeature.PUSH_NOTIFICATIONS);
                    }
                });
            }
        }).init(pushApiKey);
        Logger.d((String)TAG, (String)("init: is called using pushApiKey " + pushApiKey));
        if (sdkPlusCore.getMonitorHelper().isSdkMonitorEnabled()) {
            this.logFirebaseServicesNamesToMonitor();
        }
    }

    private void logFirebaseServicesNamesToMonitor() {
        try {
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(this.appContext.getPackageName());
            List infoList = this.appContext.getPackageManager().queryIntentServices(intent, 0);
            HashSet<String> names = new HashSet<String>();
            for (ResolveInfo resolveInfo : infoList) {
                try {
                    String name = resolveInfo.serviceInfo.name;
                    names.add(name);
                }
                catch (Exception exception) {}
            }
            Logger.d((String)TAG, (String)("init: firebase services => " + ((Object)names).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public TBLPushManager setNotificationAppIconId(int iconId) {
        if (ResourcesUtil.isResourceValid(this.appContext, iconId)) {
            this.pushNotificationsUtil.setNotificationAppIconId(iconId);
        }
        return this;
    }

    @Override
    public TBLPushManager setNotificationAppNameLabel(String applicationName) {
        this.pushNotificationsUtil.setNotificationAppNameLabel(applicationName);
        return this;
    }

    private static void verifyPushNotificationsLocalStorage(@NonNull PushNotificationsLocalStorage pushNotificationsLocalStorage, @NonNull Context appContext) {
        if (!ResourcesUtil.isResourceValid(appContext, pushNotificationsLocalStorage.getNotificationAppIconId())) {
            pushNotificationsLocalStorage.removeNotificationIcon();
        }
    }

    @Override
    public void handleNotificationObject(OcambaNotificationObject notificationObject) {
        String pushAction = "";
        String messageId = "";
        String customDataString = notificationObject.getCustomData();
        HashMap customDataMap = null;
        if (!TextUtils.isEmpty((CharSequence)customDataString)) {
            try {
                customDataMap = (HashMap)this.gson.fromJson(customDataString, new TypeToken<HashMap<String, String>>(){}.getType());
                Logger.d((String)TAG, (String)("handleNotificationObject, customDataMap = [" + customDataMap.toString() + "]"));
                pushAction = PushNotificationsUtil.getActionFromCustomData(customDataMap);
                messageId = PushNotificationsUtil.getMessageIdFromCustomData(customDataMap);
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)("handleNotificationObject | fail to parse push custom data " + e.getMessage()), (Throwable)e);
                customDataMap = null;
            }
        }
        String pushObjString = PushValidationUtil.getPushObjString(notificationObject);
        if (customDataMap == null) {
            Logger.i((String)TAG, (String)"handleNotificationObject | isNotificationObjectValid: customDataContent is invalid");
            this.analyticsManager.sendInvalidPushItemEvent("Push object custom data is invalid", "Custom data from Ocamba notification object is null" + pushObjString, "");
        } else if (PushValidationUtil.isPushActionValid(pushAction)) {
            this.analyticsManager.sendPushReceivedEvent(notificationObject.getTitle(), messageId, pushAction, pushObjString);
            switch (pushAction) {
                case "breaking": {
                    if (this.allowManualRendering(this.pushNotificationsConfig)) {
                        this.handleManualRenderingByPublisher(notificationObject, this.appContext, customDataMap);
                        break;
                    }
                    this.handleRenderingPushBySdkPlus(notificationObject, messageId, customDataMap);
                    break;
                }
                case "wake": {
                    WakeUpContent wakeUpContent = PushNotificationsUtil.parseNotificationObjectIntoWake(messageId);
                    if (PushValidationUtil.isWakePushValid(wakeUpContent, this.analyticsManager)) {
                        PushNotificationsUtil.onWakePushReceived(this.sdkPlusCore);
                        break;
                    }
                    Logger.e((String)TAG, (String)"handleNotificationObject: Wake push validation failed, wake push will be ignored");
                    break;
                }
                default: {
                    Logger.d((String)TAG, (String)"handleNotificationObject | Unknown type of push notification");
                    break;
                }
            }
        } else {
            Logger.e((String)TAG, (String)"handleOcambaNotification: Invalid action, push notification will be ignored");
            this.analyticsManager.sendInvalidPushItemEvent("Invalid action", "Action: = " + pushAction + pushObjString, messageId);
        }
    }

    private void handleRenderingPushBySdkPlus(OcambaNotificationObject ocambaNotificationObject, String messageId, HashMap<String, String> customDataMap) {
        BreakingNotificationContent breakingNotificationContent = PushNotificationsUtil.parseNotificationObjectIntoBreaking(ocambaNotificationObject, customDataMap, messageId);
        if (PushValidationUtil.isBreakingPushValid(breakingNotificationContent, this.analyticsManager)) {
            this.renderBreakingNotification(breakingNotificationContent);
        } else {
            Logger.e((String)TAG, (String)"handleRenderingPushBySdkPlus: Breaking push validation failed, push notification won't be shown");
        }
    }

    private void handleManualRenderingByPublisher(@NonNull OcambaNotificationObject ocambaNotificationObject, @NonNull Context applicationContext, @NonNull HashMap<String, String> customDataMap) {
        TBPushRawData tbPushRawData = PushNotificationsUtil.parseNotificationObjectIntoTBPushRawData(ocambaNotificationObject, customDataMap);
        try {
            Intent intent = new Intent("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER");
            intent.putExtra("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER_RAW_DATA", (Parcelable)tbPushRawData);
            intent.setPackage(applicationContext.getPackageName());
            if (applicationContext.getPackageManager().resolveActivity(intent, 0) == null) {
                applicationContext.sendBroadcast(intent);
                Logger.d((String)TAG, (String)("handleManualRendering sendBroadcast" + tbPushRawData.toString()));
                this.analyticsManager.sendPushManualDeliveredEvent(tbPushRawData);
            } else {
                intent.setFlags(0x34000000);
                applicationContext.startActivity(intent);
                Logger.d((String)TAG, (String)("handleManualRendering startActivity" + tbPushRawData.toString()));
                this.analyticsManager.sendPushManualDeliveredEvent(tbPushRawData);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.getMessage());
        }
    }

    private boolean allowManualRendering(@NonNull PushNotificationsConfig pushNotificationsConfig) {
        return PushNotificationsUtil.shouldAllowManualRendering(pushNotificationsConfig);
    }
}

