/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.plus.common.EventProperties;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.common.network.SdkPlusNetworkManager;
import com.taboola.android.plus.core.SdkPlusExecutors;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.json.JSONObject;

@RequiresApi(api=21)
public abstract class AbstractAnalyticsManager<EventModule extends EventProperties> {
    private static final String TAG = AbstractAnalyticsManager.class.getSimpleName();
    public static final String TB_ANALYTICS_ACTION_NAME = "tb.analytics.action.name";
    public static final String TB_ANALYTICS_KEY_EVENT_NAME = "key_event_name";
    public static final String TB_ANALYTICS_KEY_EVENT_PROPERTIES = "key_event_properties";
    public static final String TB_ANALYTICS_KEY_USER_PROPERTIES = "key_user_properties";
    private static final String SDK_PLUS_TAG = "SDKPlus";
    private static final String ANDROID = "Android";
    private static final Object kustoCrashesDataLock = new Object();
    private static final int LAST_EVENT_INTERVAL = 300000;
    @NonNull
    protected final Context appContext;
    protected final Gson gson;
    @NonNull
    protected final SharedLocalStorage sharedLocalStorage;
    private final ISdkPlusCore sdkPlusCore;
    protected final SdkPlusNetworkManager sdkPlusNetworkManager;
    private final Executor networkExecutor;
    private final Executor mainThreadExecutor;
    private final AdvertisingIdInfo advertisingId;

    public AbstractAnalyticsManager(ISdkPlusCore sdkPlusCore) {
        this.sdkPlusCore = sdkPlusCore;
        this.appContext = sdkPlusCore.getApplicationContext();
        this.sharedLocalStorage = sdkPlusCore.getSharedLocalStorage();
        this.sdkPlusNetworkManager = sdkPlusCore.getSdkPlusNetworkManager();
        this.gson = sdkPlusCore.getGson();
        this.advertisingId = sdkPlusCore.getAdvertisingIdInfo();
        SdkPlusExecutors sdkPlusExecutors = sdkPlusCore.getSdkPlusExecutors();
        this.networkExecutor = sdkPlusExecutors.getNetworkExecutor();
        this.mainThreadExecutor = sdkPlusExecutors.getMainThreadExecutor();
    }

    protected void sendEvent(@NonNull EventModule eventProperties, final boolean shouldSentToTrc) {
        boolean isKustoEnabled = this.sharedLocalStorage.isKustoEnabled();
        if (isKustoEnabled) {
            this.networkExecutor.execute(new Runnable((EventProperties)eventProperties){
                final /* synthetic */ EventProperties val$eventProperties;
                {
                    this.val$eventProperties = eventProperties;
                }

                @Override
                public void run() {
                    AbstractAnalyticsManager.this.sendEventToKusto(AbstractAnalyticsManager.this.appContext, this.val$eventProperties);
                }
            });
        }
        this.mainThreadExecutor.execute(new Runnable((EventProperties)eventProperties){
            final /* synthetic */ EventProperties val$eventProperties;
            {
                this.val$eventProperties = eventProperties;
            }

            @Override
            public void run() {
                if (shouldSentToTrc) {
                    AbstractAnalyticsManager.this.sendEventToTrc(this.val$eventProperties);
                }
                AbstractAnalyticsManager.this.broadcastEvent(this.val$eventProperties);
            }
        });
    }

    @WorkerThread
    protected void sendEventToKusto(final @NonNull Context appContext, @NonNull EventModule eventProperties) {
        HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse((EventProperties)eventProperties){
            final /* synthetic */ EventProperties val$eventProperties;
            {
                this.val$eventProperties = eventProperties;
            }

            public void onResponse(HttpResponse httpResponse) {
            }

            public void onError(HttpError httpError) {
                JsonObject event = AbstractAnalyticsManager.this.getJsonObjectForKusto(appContext, this.val$eventProperties, AbstractAnalyticsManager.this.sharedLocalStorage);
                Logger.e((String)TAG, (String)("sendEventToKusto Event not reported, error: " + httpError + " event = " + event));
            }
        };
        boolean isDebug = ISdkPlusCore.isDebug();
        this.sendEventToKusto(appContext, eventProperties, (HttpManager.NetworkResponse)(isDebug ? networkResponse : null));
    }

    @WorkerThread
    protected void sendEventToKusto(@NonNull Context appContext, @NonNull EventModule eventProperties, @Nullable HttpManager.NetworkResponse networkResponse) {
        try {
            long lastEventTime = this.sharedLocalStorage.getLastEventTime();
            if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && ((EventProperties)eventProperties).isImplicitEvent()) {
                this.sharedLocalStorage.setLastEventTime(System.currentTimeMillis());
            }
            JsonObject event = this.getJsonObjectForKusto(appContext, eventProperties, this.sharedLocalStorage);
            this.sendCrashEventsToKustoIfNeed();
            String publisher = this.sharedLocalStorage.getPublisher();
            String customData = this.getCustomData(eventProperties);
            this.sdkPlusNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, String.valueOf(event), publisher, customData, networkResponse);
            Log.v((String)TAG, (String)("sent event to kusto " + ((EventProperties)eventProperties).getEventName()));
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendEventToKusto fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    protected String getCustomData(@NonNull EventModule eventProperties) {
        return null;
    }

    protected JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull EventModule eventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        String publisher;
        JsonObject event = new JsonObject();
        event.addProperty("event_type", ((EventProperties)eventProperties).getEventName());
        this.putSystemPropertiesIntoJsonObject(event);
        TBDeviceInfoUtil.setLocationData(appContext, event);
        if (((EventProperties)eventProperties).isImplicitEvent()) {
            event.addProperty("session_id", (Number)sharedLocalStorage.getLastEventTime());
        }
        AbstractAnalyticsManager abstractAnalyticsManager = this;
        event.addProperty("sdk+(TaboolaPlus)version", abstractAnalyticsManager.sdkPlusCore.getVersionName());
        event.addProperty("sdk(TaboolaApi)version", "2.5.0");
        event.addProperty("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, appContext));
        if (!TextUtils.isEmpty((CharSequence)((EventProperties)eventProperties).getError())) {
            event.addProperty("error_details", ((EventProperties)eventProperties).getError());
        }
        if (((EventProperties)eventProperties).isBlocked() != null) {
            event.addProperty("isBlocked", ((EventProperties)eventProperties).isBlocked());
        }
        if (((EventProperties)eventProperties).isDeviceLocked() != null) {
            event.addProperty("isDeviceLocked", ((EventProperties)eventProperties).isDeviceLocked());
        }
        if (!TextUtils.isEmpty((CharSequence)((EventProperties)eventProperties).getExceptionMessage())) {
            event.addProperty("exceptionMessage", ((EventProperties)eventProperties).getExceptionMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)((EventProperties)eventProperties).getExceptionStackTrace())) {
            event.addProperty("exceptionStackTrace", ((EventProperties)eventProperties).getExceptionStackTrace());
        }
        if (!TextUtils.isEmpty((CharSequence)((EventProperties)eventProperties).getErrorMessage())) {
            event.addProperty("errorMessage", ((EventProperties)eventProperties).getErrorMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)(publisher = sharedLocalStorage.getPublisher()))) {
            event.addProperty("publisher", publisher);
        }
        String configVariant = sharedLocalStorage.getConfigVariant();
        event.addProperty("configVariant", configVariant);
        if (!TextUtils.isEmpty((CharSequence)sharedLocalStorage.getUserUnifiedId())) {
            event.addProperty("user_unified_id", sharedLocalStorage.getUserUnifiedId());
        }
        return event;
    }

    @UiThread
    protected void sendEventToTrc(@NonNull EventModule eventProperties) {
        String type = ((EventProperties)eventProperties).getEventName();
        if (TextUtils.isEmpty((CharSequence)type)) {
            Logger.e((String)TAG, (String)"reportEvent missing type param");
        } else {
            Logger.d((String)TAG, (String)("sendEventToTrc EventName = " + type));
            Map<String, String> map = this.getEventMap(this.appContext, eventProperties);
            map.put("extraParam", type);
            TaboolaMobileEvent taboolaMobileEvent = new TaboolaMobileEvent("Generic", map);
            this.sdkPlusCore.reportMobileEvent(taboolaMobileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void sendCrashEventsToKustoIfNeed() {
        try {
            HashSet<String> crashEventsThatNeedSendToKusto;
            Iterator iterator = kustoCrashesDataLock;
            synchronized (iterator) {
                crashEventsThatNeedSendToKusto = new HashSet<String>(this.sharedLocalStorage.getCrashEventsThatNeedSendToKusto());
                this.sharedLocalStorage.clearCrashEventsThatNeedSendToKusto();
            }
            if (!crashEventsThatNeedSendToKusto.isEmpty()) {
                for (String event : crashEventsThatNeedSendToKusto) {
                    String crashEventFormatted = String.valueOf(new JsonParser().parse(event).getAsJsonObject());
                    this.sdkPlusNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, crashEventFormatted, this.sharedLocalStorage.getPublisher(), new HttpManager.NetworkResponse(){

                        public void onResponse(HttpResponse response) {
                            Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception reported, response: " + response));
                        }

                        public void onError(HttpError httpError) {
                            Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception not reported, error: " + httpError));
                        }
                    });
                    Log.v((String)TAG, (String)("sent event to kusto " + event));
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendCrashEventsToKustoIfNeed fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    @NonNull
    protected Map<String, String> getEventMap(@NonNull Context appContext, @NonNull EventModule eventProperties) {
        String publisher;
        long lastEventTime = this.sharedLocalStorage.getLastEventTime();
        if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && ((EventProperties)eventProperties).isImplicitEvent()) {
            this.sharedLocalStorage.setLastEventTime(System.currentTimeMillis());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("event_type", ((EventProperties)eventProperties).getEventName());
        this.putSystemPropertiesIntoMap(map);
        TBDeviceInfoUtil.setLocationData(appContext, map);
        if (((EventProperties)eventProperties).isImplicitEvent()) {
            map.put("session_id", String.valueOf(this.sharedLocalStorage.getLastEventTime()));
        }
        AbstractAnalyticsManager abstractAnalyticsManager = this;
        map.put("sdk+(TaboolaPlus)version", abstractAnalyticsManager.sdkPlusCore.getVersionName());
        map.put("sdk(TaboolaApi)version", "2.5.0");
        map.put("simCountry", TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
        if (((EventProperties)eventProperties).getError() != null) {
            map.put("error_details", ((EventProperties)eventProperties).getError());
        }
        if (((EventProperties)eventProperties).isBlocked() != null) {
            map.put("isBlocked", String.valueOf(((EventProperties)eventProperties).isBlocked()));
        }
        if (((EventProperties)eventProperties).isDeviceLocked() != null) {
            map.put("isDeviceLocked", String.valueOf(((EventProperties)eventProperties).isDeviceLocked()));
        }
        if (((EventProperties)eventProperties).getExceptionMessage() != null) {
            map.put("exceptionMessage", ((EventProperties)eventProperties).getExceptionMessage());
        }
        if (((EventProperties)eventProperties).getExceptionStackTrace() != null) {
            map.put("exceptionStackTrace", ((EventProperties)eventProperties).getExceptionStackTrace());
        }
        if (!TextUtils.isEmpty((CharSequence)(publisher = this.sharedLocalStorage.getPublisher()))) {
            map.put("publisher", publisher);
        }
        String configVariant = this.sharedLocalStorage.getConfigVariant();
        map.put("configVariant", configVariant);
        return map;
    }

    protected JSONObject getCommonEventProperties(@NonNull Context appContext, @Nullable String error, Boolean isBlocked, Boolean isDeviceLocked, String exceptionMessage, String exceptionStackTrace, String errorMessage) {
        JSONObject eventProperties = new JSONObject();
        try {
            String publisher;
            AbstractAnalyticsManager abstractAnalyticsManager = this;
            eventProperties.put("sdk+(TaboolaPlus)version", (Object)abstractAnalyticsManager.sdkPlusCore.getVersionName());
            eventProperties.put("sdk(TaboolaApi)version", (Object)"2.5.0");
            eventProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
            if (!TextUtils.isEmpty((CharSequence)error)) {
                eventProperties.put("error_details", (Object)error);
            }
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                eventProperties.put("errorMessage", (Object)errorMessage);
            }
            if (isBlocked != null) {
                eventProperties.put("isBlocked", (Object)isBlocked);
            }
            if (isDeviceLocked != null) {
                eventProperties.put("isDeviceLocked", (Object)isDeviceLocked);
            }
            if (!TextUtils.isEmpty((CharSequence)exceptionMessage)) {
                eventProperties.put("exceptionMessage", (Object)exceptionMessage);
            }
            if (!TextUtils.isEmpty((CharSequence)exceptionStackTrace)) {
                eventProperties.put("exceptionStackTrace", (Object)exceptionStackTrace);
            }
            if (!TextUtils.isEmpty((CharSequence)(publisher = this.sharedLocalStorage.getPublisher()))) {
                eventProperties.put("publisher", (Object)publisher);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getCommonEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }

    protected JSONObject getUserProperties(@NonNull Context appContext) {
        JSONObject userProperties = new JSONObject();
        try {
            userProperties.put("appId", (Object)appContext.getPackageName());
            userProperties.put("appVersion", (Object)TBDeviceInfoUtil.getAppVersion(appContext));
            AbstractAnalyticsManager abstractAnalyticsManager = this;
            userProperties.put("sdk+(TaboolaPlus)version", (Object)abstractAnalyticsManager.sdkPlusCore.getVersionName());
            userProperties.put("sdk(TaboolaApi)version", (Object)"2.5.0");
            userProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
            String publisher = this.sharedLocalStorage.getPublisher();
            if (!TextUtils.isEmpty((CharSequence)publisher)) {
                userProperties.put("publisher", (Object)publisher);
            }
            String abTestVariant = this.sharedLocalStorage.getConfigVariant();
            userProperties.put("configVariant", (Object)abTestVariant);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getUserProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return userProperties;
    }

    private void putSystemPropertiesIntoMap(@NonNull Map<String, String> map) {
        try {
            String device_id = this.advertisingId.getAdvertisingId();
            map.put("device_id", device_id);
            map.put("time", new Timestamp(System.currentTimeMillis()).toString());
            map.put("os_name", ANDROID);
            map.put("platform", ANDROID);
            map.put("os_version", Build.VERSION.RELEASE);
            map.put("device_model", TBDeviceInfoUtil.getDeviceName());
            map.put("app_version", TBDeviceInfoUtil.getAppVersion(this.appContext));
            map.put("appId", this.appContext.getPackageName());
            map.put("device_manufacturer", Build.MANUFACTURER);
            map.put("device_brand", Build.MANUFACTURER);
            map.put("carrier", TBDeviceInfoUtil.getCarrier(this.appContext));
            map.put("language", Locale.getDefault().getDisplayLanguage(Locale.US));
            map.put("adid", device_id);
            String localIpAddress = TBDeviceInfoUtil.getLocalIpAddress();
            if (!TextUtils.isEmpty((CharSequence)localIpAddress)) {
                map.put("ip", localIpAddress);
            }
        }
        catch (Throwable t) {
            Logger.e((String)TAG, (String)("Unable to put properties into map: " + t.getMessage()), (Throwable)t);
        }
    }

    private void putSystemPropertiesIntoJsonObject(@NonNull JsonObject event) {
        try {
            String device_id = this.advertisingId.getAdvertisingId();
            event.addProperty("device_id", device_id);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
            event.addProperty("time", sdf.format(new Date(System.currentTimeMillis())));
            event.addProperty("date_formatted", new Date().toString());
            event.addProperty("os_name", ANDROID);
            event.addProperty("platform", ANDROID);
            event.addProperty("os_version", Build.VERSION.RELEASE);
            event.addProperty("device_model", TBDeviceInfoUtil.getDeviceName());
            event.addProperty("app_version", TBDeviceInfoUtil.getAppVersion(this.appContext));
            event.addProperty("appId", this.appContext.getPackageName());
            event.addProperty("device_manufacturer", Build.MANUFACTURER);
            event.addProperty("device_brand", Build.MANUFACTURER);
            event.addProperty("carrier", TBDeviceInfoUtil.getCarrier(this.appContext));
            event.addProperty("language", Locale.getDefault().getDisplayLanguage(Locale.US));
            event.addProperty("adid", device_id);
        }
        catch (Throwable t) {
            Logger.e((String)TAG, (String)("Unable to put properties into json: " + t.getMessage()), (Throwable)t);
        }
    }

    @NonNull
    protected Executor getNetworkExecutor() {
        return this.networkExecutor;
    }

    protected abstract void broadcastEvent(@NonNull EventModule var1);
}

