/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.taboola.android.monitor.TBUrlParamsChange;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SecurityUtils;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(api=21)
public class ConfigHelper {
    private static final String TAG = "ConfigHelper";
    private static Map<String, String> externalQueryParameters;

    public static boolean forceMobileConfigUrlParams(TBUrlParamsChange paramsChange, String password) {
        String[] separated;
        String keyHash = SecurityUtils.getSHA256((String)password).toLowerCase();
        if (!keyHash.equalsIgnoreCase("376c21021b2800b444ae9214a5b251460c04490611dadf1585987e12ce0b6c21")) {
            Logger.e((String)TAG, (String)("forceMobileConfigUrlParams wrong password " + password));
            return false;
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (String param : separated = paramsChange.getParams().split("&")) {
            String[] keyV = param.split("=");
            queryParameters.put(keyV[0], keyV[1]);
        }
        externalQueryParameters = queryParameters;
        return true;
    }

    @NonNull
    public static Map<String, String> getConfigQueryParameters(@NonNull SharedLocalStorage sharedLocalStorage, @NonNull Context context) {
        return ConfigHelper.getConfigQueryParameters(sharedLocalStorage, context, null);
    }

    @NonNull
    public static Map<String, String> getConfigQueryParameters(@NonNull SharedLocalStorage sharedLocalStorage, @NonNull Context context, @Nullable String deviceId) {
        Map<String, String> queryParameters = ConfigHelper.getDeviceQueryParameters(sharedLocalStorage, context, deviceId);
        queryParameters.putAll(ConfigHelper.getExternalQueryParameters());
        return queryParameters;
    }

    @NonNull
    private static Map<String, String> getExternalQueryParameters() {
        return externalQueryParameters != null ? externalQueryParameters : new HashMap();
    }

    @NonNull
    private static Map<String, String> getDeviceQueryParameters(@NonNull SharedLocalStorage sharedLocalStorage, @NonNull Context context, @Nullable String deviceId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            map.put("deviceId", deviceId);
        }
        map.put("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, context));
        map.put("sdkPlusVersion", "2.0.4");
        map.put("appVersion", TBDeviceInfoUtil.getAppVersion(context));
        map.put("appId", context.getPackageName());
        map.put("phoneLocale", Resources.getSystem().getConfiguration().locale.getLanguage());
        map.put("androidVersion", String.valueOf(Build.VERSION.SDK_INT));
        return map;
    }
}

