/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.core.AbsPushManager;
import com.taboola.android.plus.core.AbsScheduledManager;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.PushManagerCallback;
import com.taboola.android.plus.core.ScheduledManagerCallback;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class TBLNotificationManager {
    private static final String TAG = TBLNotificationManager.class.getSimpleName();
    public static final String NOTIFICATION_CLICK_INTENT_ACTION = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT";
    public static final String NOTIFICATION_TYPE = "notification_type";

    public static void handleClick(@NonNull Intent intent, @NonNull Context activityContext) {
        Bundle extras = intent.getExtras();
        if (intent.getAction() != null && intent.getAction().equals(NOTIFICATION_CLICK_INTENT_ACTION) && extras != null) {
            String notificationsType;
            Log.d((String)TAG, (String)("handleClick() called with: intent = [" + intent + "], activityContext = [" + activityContext + "]"));
            if (ISdkPlusCore.isDebug()) {
                for (String key : extras.keySet()) {
                    Logger.i((String)TAG, (String)(key + " : " + (extras.get(key) != null ? extras.get(key) : "NULL")));
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(notificationsType = extras.getString(NOTIFICATION_TYPE)))) {
                switch (notificationsType) {
                    case "Scheduled": {
                        TBLNotificationManager.handleScheduledItem(extras, activityContext);
                        break;
                    }
                    case "breaking": {
                        TBLNotificationManager.handlePushItem(extras, activityContext);
                        break;
                    }
                    default: {
                        Log.d((String)TAG, (String)"handleClick: notificationsType not found");
                    }
                }
            }
        }
    }

    private static void handlePushItem(final @NonNull Bundle extras, final Context activityContext) {
        BridgeInternalCore.getPushNotificationManagerAsync(new PushManagerCallback(){

            @Override
            public void onManagerRetrieved(AbsPushManager pushNotificationsManager) {
                if (pushNotificationsManager != null) {
                    pushNotificationsManager.handleClick(extras, activityContext);
                } else {
                    Logger.e((String)TAG, (String)"handleClick: failed to handle request : getPushNotificationManagerAsync failed");
                }
            }

            @Override
            public void onManagerRetrieveFailed(Throwable throwable) {
                Logger.e((String)TAG, (String)("handleClick: failed to handle request : getPushNotificationManagerAsync failed : " + throwable.getMessage()));
            }
        });
    }

    private static void handleScheduledItem(final @NonNull Bundle extras, final Context activityContext) {
        BridgeInternalCore.getScheduledNotificationManagerAsync(new ScheduledManagerCallback(){

            @Override
            public void onManagerRetrieved(AbsScheduledManager iScheduledNotificationManager) {
                if (iScheduledNotificationManager != null) {
                    iScheduledNotificationManager.handleClick(extras, activityContext);
                } else {
                    Logger.e((String)TAG, (String)"handleClick: failed to handle request : getScheduledNotificationManagerAsync failed");
                }
            }

            @Override
            public void onManagerRetrieveFailed(Throwable throwable) {
                Logger.e((String)TAG, (String)("handleClick: failed to handle request : getScheduledNotificationManagerAsync failed : " + throwable.getMessage()));
            }
        });
    }
}

