/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.time_window;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.util.Log;
import com.taboola.android.plus.notifications.scheduled.time_window.AllowedTimeWindows;
import java.util.Calendar;
import java.util.List;

public class TimeWindowUtil {
    private static final String TAG = "TimeWindowUtil";

    public static boolean isBlockedByAllowedTimeWindows(@NonNull List<AllowedTimeWindows> timeIntervals) {
        return TimeWindowUtil.isBlockedByAllowedTimeWindows(timeIntervals, System.currentTimeMillis());
    }

    public static boolean isBlockedByAllowedTimeWindows(@NonNull @Size(min=0L) List<AllowedTimeWindows> timeIntervals, long timeToCheck) {
        if (timeIntervals.isEmpty()) {
            Log.i((String)TAG, (String)"isBlockedByAllowedTimeWindows: allowed intervals list is empty");
            return false;
        }
        for (AllowedTimeWindows interval : timeIntervals) {
            if (interval.getStartHour().equals(interval.getEndHour()) && interval.getStartMin().equals(interval.getEndMin())) {
                return false;
            }
            Calendar startTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            startTime.set(11, Integer.parseInt(interval.getStartHour()));
            startTime.set(12, Integer.parseInt(interval.getStartMin()));
            endTime.set(11, Integer.parseInt(interval.getEndHour()));
            endTime.set(12, Integer.parseInt(interval.getEndMin()));
            if (timeToCheck <= startTime.getTimeInMillis() || timeToCheck >= endTime.getTimeInMillis()) continue;
            return false;
        }
        return true;
    }
}

