/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.layout_model;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.layout_model.AbstractNotificationsLayoutModel;

public class MultipleNotificationsLayoutModel
extends AbstractNotificationsLayoutModel {
    private static final String TAG = MultipleNotificationsLayoutModel.class.getSimpleName();
    private static final String LAYOUT_COLLAPSED_MULTIPLE_THUMBNAILS_STRING = "layout_collapsed_multiple_thumbnails";
    private static final String LAYOUT_EXPANDED_MULTIPLE_THUMBNAILS_STRING = "layout_expanded_multiple_thumbnails";
    private static final int MIN_ITEMS_COUNT_EXPANDED = 2;
    private static final int MIN_ITEMS_COUNT_COLLAPSED = 2;
    private static final int MAX_ITEMS_COUNT_EXPANDED = 6;
    private static final int MAX_ITEMS_COUNT_COLLAPSED = 3;
    private MultipleCollapsedLayout multipleCollapsedLayout;
    private MultipleExpandedLayout multipleExpandedLayout;
    private ScheduledNotificationsConfig.ScheduledNotificationsLayout.MultipleItemNotificationsLayout.LayoutSpecificProperties layoutSpecificProperties;

    public static MultipleNotificationsLayoutModel determineNotificationsLayout(@NonNull ScheduledNotificationsConfig.ScheduledNotificationsLayout.MultipleItemNotificationsLayout config, @IntRange(from=1L) int availableItemsCount) {
        if (availableItemsCount < 1) {
            throw new IllegalArgumentException("Item count must be greater than 0");
        }
        MultipleNotificationsLayoutModel multipleNotificationsLayoutModel = new MultipleNotificationsLayoutModel();
        multipleNotificationsLayoutModel.setLayoutSpecificProperties(config.getLayoutSpecificProperties());
        MultipleCollapsedLayout preferredCollapsedLayout = MultipleCollapsedLayout.parseLayout(config.getPreferredCollapsedMultipleItemLayout());
        MultipleExpandedLayout preferredExpandedLayout = MultipleExpandedLayout.parseLayout(config.getPreferredExpandedMultipleItemLayout());
        multipleNotificationsLayoutModel.setMultipleCollapsedLayout(preferredCollapsedLayout);
        multipleNotificationsLayoutModel.setMultipleExpandedLayout(preferredExpandedLayout);
        return multipleNotificationsLayoutModel;
    }

    @Override
    @NonNull
    JsonElement getJsonObject() {
        JsonObject jsonElement = new JsonObject();
        jsonElement.add("collapsedLayout", this.multipleCollapsedLayout.getJsonObject());
        jsonElement.add("expandedLayout", this.multipleExpandedLayout.getJsonObject());
        return jsonElement;
    }

    public MultipleCollapsedLayout getMultipleCollapsedLayout() {
        return this.multipleCollapsedLayout;
    }

    private void setMultipleCollapsedLayout(MultipleCollapsedLayout multipleCollapsedLayout) {
        this.multipleCollapsedLayout = multipleCollapsedLayout;
    }

    public MultipleExpandedLayout getMultipleExpandedLayout() {
        return this.multipleExpandedLayout;
    }

    private void setMultipleExpandedLayout(MultipleExpandedLayout multipleExpandedLayout) {
        this.multipleExpandedLayout = multipleExpandedLayout;
    }

    public ScheduledNotificationsConfig.ScheduledNotificationsLayout.MultipleItemNotificationsLayout.LayoutSpecificProperties getLayoutSpecificProperties() {
        return this.layoutSpecificProperties;
    }

    private void setLayoutSpecificProperties(ScheduledNotificationsConfig.ScheduledNotificationsLayout.MultipleItemNotificationsLayout.LayoutSpecificProperties layoutSpecificProperties) {
        this.layoutSpecificProperties = layoutSpecificProperties;
    }

    public boolean isEnoughItems(int availableItemsCount) {
        return this.multipleCollapsedLayout.getMinNumberOfItems() <= availableItemsCount && this.multipleExpandedLayout.getMinNumberOfItems() <= availableItemsCount;
    }

    public static enum MultipleExpandedLayout {
        MultipleThumbnails("layout_expanded_multiple_thumbnails");

        private final String layoutStringKey;
        private final int minNumberOfItems;
        private final int maxNumberOfItems;

        private MultipleExpandedLayout(String layoutStringKey) {
            this.layoutStringKey = layoutStringKey;
            this.minNumberOfItems = 2;
            this.maxNumberOfItems = 6;
        }

        static MultipleExpandedLayout parseLayout(String preferredExpandedLayoutString) {
            if (MultipleNotificationsLayoutModel.LAYOUT_EXPANDED_MULTIPLE_THUMBNAILS_STRING.equals(preferredExpandedLayoutString)) {
                return MultipleThumbnails;
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Expanded layout key. Using default");
            return MultipleExpandedLayout.getDefaultLayout();
        }

        static MultipleExpandedLayout getDefaultLayout() {
            return MultipleThumbnails;
        }

        public String getLayoutStringKey() {
            return this.layoutStringKey;
        }

        int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        @NonNull
        public String toString() {
            return this.getLayoutStringKey();
        }

        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty("layout", this.layoutStringKey);
            jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
            jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
            return jsonElement;
        }
    }

    public static enum MultipleCollapsedLayout {
        MultipleThumbnails("layout_collapsed_multiple_thumbnails");

        private final String layoutStringKey;
        private final int minNumberOfItems;
        private final int maxNumberOfItems;

        private MultipleCollapsedLayout(String layoutStringKey) {
            this.layoutStringKey = layoutStringKey;
            this.minNumberOfItems = 2;
            this.maxNumberOfItems = 3;
        }

        static MultipleCollapsedLayout parseLayout(String preferredCollapsedLayoutString) {
            if (MultipleNotificationsLayoutModel.LAYOUT_COLLAPSED_MULTIPLE_THUMBNAILS_STRING.equals(preferredCollapsedLayoutString)) {
                return MultipleThumbnails;
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
            return MultipleCollapsedLayout.getDefaultLayout();
        }

        static MultipleCollapsedLayout getDefaultLayout() {
            return MultipleThumbnails;
        }

        public String getLayoutStringKey() {
            return this.layoutStringKey;
        }

        int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        @NonNull
        public String toString() {
            return this.getLayoutStringKey();
        }

        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty("layout", this.layoutStringKey);
            jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
            jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
            return jsonElement;
        }
    }
}

