/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.content;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.plus.notifications.scheduled.NotificationItem;
import com.taboola.android.plus.notifications.scheduled.TBContent;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.content.GetMultipleCategoriesInteractor;
import com.taboola.android.plus.notifications.scheduled.content.NotificationContentConfig;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreNotificationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
public class NotificationRemoteRepository {
    private static final String TAG = NotificationRemoteRepository.class.getSimpleName();
    static final String READ_MORE_PLACEMENT_KEY = "read_more";
    private final TBScheduledNotificationAnalyticsManager analyticsManager;

    public NotificationRemoteRepository(@NonNull TBScheduledNotificationAnalyticsManager analyticsManager) {
        this.analyticsManager = analyticsManager;
    }

    void getNotificationContent(@NonNull NotificationContentConfig notificationContentConfig, @NonNull @Size(min=1L) List<String> contentCategories, @Nullable String readMorePlacementName, @Nullable String userUnifiedId, final @NonNull OnNotificationContentFetchedCallback callback) {
        ArrayList<String> categorizedPlacementNames = new ArrayList<String>();
        Map<String, String> categoryToPlacement = notificationContentConfig.getCategoryToPlacement();
        for (String categoryName : contentCategories) {
            String categorizedPlacementName = categoryToPlacement.get(categoryName);
            if (TextUtils.isEmpty((CharSequence)categorizedPlacementName)) continue;
            categorizedPlacementNames.add(categorizedPlacementName);
        }
        if (categorizedPlacementNames.isEmpty()) {
            callback.onNotificationContentFailed(new Throwable("No valid categories selected"));
            Log.e((String)TAG, (String)"getNewContent: no valid categories were selected");
            return;
        }
        new GetMultipleCategoriesInteractor().execute(this.analyticsManager, categorizedPlacementNames, readMorePlacementName, userUnifiedId, notificationContentConfig.getItemsBatchSize(), new GetMultipleCategoriesInteractor.GetNewNotificationContentCallback(){

            @Override
            public void onContentFetched(@NonNull Map<String, List<TBPlacement>> contentFromRemote) {
                NotificationRemoteRepository.this.onContentFetched(contentFromRemote, callback);
            }

            @Override
            public void onContentFailed(Throwable throwable) {
                callback.onNotificationContentFailed(throwable);
            }
        });
    }

    private void onContentFetched(@NonNull Map<String, List<TBPlacement>> content, @NonNull OnNotificationContentFetchedCallback callback) {
        ReadMoreNotificationItem readMoreNotificationItem = null;
        List<TBPlacement> readMorePlacementContainer = content.get(READ_MORE_PLACEMENT_KEY);
        if (readMorePlacementContainer != null) {
            TBPlacement readMorePlacement;
            content.remove(READ_MORE_PLACEMENT_KEY);
            List<TBPlacement> contentPlacements = content.entrySet().iterator().next().getValue();
            if (readMorePlacementContainer.size() > 0 && contentPlacements.size() > 0 && (readMorePlacement = readMorePlacementContainer.get(0)) != null) {
                TBPlacement tBPlacement = contentPlacements.get(contentPlacements.size() - 1);
                contentPlacements.remove(tBPlacement);
                readMoreNotificationItem = new ReadMoreNotificationItem(tBPlacement, readMorePlacement);
            }
        }
        ArrayList allPlacements = new ArrayList();
        for (Map.Entry<String, List<TBPlacement>> entry : content.entrySet()) {
            allPlacements.addAll(entry.getValue());
        }
        ArrayList<NotificationItem> notificationItems = new ArrayList<NotificationItem>();
        for (TBPlacement item : allPlacements) {
            notificationItems.add(new NotificationItem(item));
        }
        TBContent tBContent = new TBContent(notificationItems, readMoreNotificationItem);
        callback.onNotificationContentFetched(tBContent);
    }

    public static interface OnNotificationContentFetchedCallback {
        public void onNotificationContentFetched(@NonNull TBContent var1);

        public void onNotificationContentFailed(Throwable var1);
    }
}

