/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.common.BaseConfigValidator;
import com.taboola.android.plus.notifications.push.PushNotificationsConfig;

class PushNotificationsConfigValidator
extends BaseConfigValidator {
    private static final String TAG = PushNotificationsConfigValidator.class.getSimpleName();

    PushNotificationsConfigValidator() {
    }

    @Override
    public boolean isConfigValid(@NonNull JsonElement pushConfig) {
        JsonElement layoutSpecific = null;
        JsonElement pushNotificationsLayout = pushConfig.getAsJsonObject().get("pushNotificationsLayout");
        if (pushNotificationsLayout != null) {
            layoutSpecific = pushNotificationsLayout.getAsJsonObject().get("layoutSpecificProperties");
        }
        if (!BaseConfigValidator.isObjectValid(pushConfig, PushNotificationsConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: push notifications config is invalid");
            return false;
        }
        if (!BaseConfigValidator.isObjectValid(pushNotificationsLayout, PushNotificationsConfig.PushNotificationsLayout.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: push notifications layout config is invalid");
            return false;
        }
        if (!BaseConfigValidator.isObjectValid(layoutSpecific, PushNotificationsConfig.LayoutSpecificConfigs.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: push notifications layout specific config is invalid");
            return false;
        }
        return true;
    }

    @Override
    public <T extends BaseConfig> T parseConfig(@NonNull JsonElement config, @NonNull Class<T> type) {
        return (T)((BaseConfig)type.cast(this.gson.fromJson(config, PushNotificationsConfig.class)));
    }
}

