/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common.network.handlers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.network.Callback;
import com.taboola.android.plus.common.network.ConfigApiService;
import com.taboola.android.plus.common.network.handlers.BaseHandler;
import com.taboola.android.plus.common.network.handlers.ConfigApiServiceImp;
import com.taboola.android.plus.common.network.handlers.ConfigApiServiceMonitorImp;
import com.taboola.android.plus.common.network.handlers.IConfigHandler;
import com.taboola.android.plus.core.LanguagesConfig;
import com.taboola.android.plus.core.SdkPlusConfig;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.Map;

public class ConfigHandler
extends BaseHandler
implements IConfigHandler {
    private static final String TAG = "ConfigHandler";
    private ConfigApiService configApiService;
    private Gson gson;
    private HttpManager httpManager;

    public ConfigHandler() {
        super(TAG);
    }

    @Override
    public void setHttpManager(HttpManager httpManager) {
        this.httpManager = httpManager;
        this.configApiService = new ConfigApiServiceImp(httpManager);
        this.gson = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();
    }

    @Override
    public void getConfig(@NonNull String pubId, @NonNull String configId, @NonNull Map<String, String> query, final @Nullable Callback<SdkPlusConfig> callback) {
        block5: {
            try {
                DynamicRequest request = this.configApiService.getConfigRequest(pubId, configId, query);
                this.sendUrlToMonitor(request.getFinalUrl());
                if (ISdkPlusCore.isDebug()) {
                    Logger.d((String)TAG, (String)("getConfigId " + request.getFinalUrl()));
                }
                HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse httpResponse) {
                        block5: {
                            try {
                                String response = httpResponse.mMessage;
                                SdkPlusConfig config = null;
                                if (!TextUtils.isEmpty((CharSequence)response)) {
                                    config = (SdkPlusConfig)ConfigHandler.this.gson.fromJson(response, SdkPlusConfig.class);
                                }
                                if (config == null) {
                                    throw new Exception("Config is null");
                                }
                                Logger.d((String)ConfigHandler.TAG, (String)("getConfigId success " + response));
                                if (callback != null) {
                                    callback.onResponse(config, httpResponse.toString());
                                }
                            }
                            catch (Throwable e) {
                                Logger.e((String)ConfigHandler.TAG, (String)("getConfigId: error " + e.getLocalizedMessage()), (Throwable)e);
                                if (callback == null) break block5;
                                callback.onFailure(new Throwable(e.getLocalizedMessage(), e));
                            }
                        }
                    }

                    public void onError(HttpError httpError) {
                        Log.e((String)ConfigHandler.TAG, (String)("getConfigId: error " + httpError));
                        if (callback != null) {
                            callback.onFailure(new Throwable(httpError.toString()));
                        }
                    }
                };
                if (this.monitorHelper != null && !TextUtils.isEmpty((CharSequence)this.monitorHelper.getOverrideConfigResponse())) {
                    Logger.d((String)TAG, (String)"getConfigId: fake response using monitor");
                    HttpResponse httpResponse = new HttpResponse(204, this.monitorHelper.getOverrideConfigResponse(), null);
                    networkResponse.onResponse(httpResponse);
                } else {
                    request.execute(networkResponse);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getConfigId: error " + e.getLocalizedMessage()), (Throwable)e);
                if (callback == null) break block5;
                callback.onFailure(new Throwable(e.getLocalizedMessage()));
            }
        }
    }

    @Override
    public void getLanguagesConfig(@NonNull String pubId, @NonNull Map<String, String> queryMap, final @Nullable Callback<LanguagesConfig> callback) {
        block3: {
            try {
                DynamicRequest request = this.configApiService.getLanguagesConfigRequest(pubId, queryMap);
                this.sendUrlToMonitor(request.getFinalUrl());
                if (ISdkPlusCore.isDebug()) {
                    Logger.d((String)TAG, (String)("getLanguagesConfig " + request.getFinalUrl()));
                }
                request.execute(new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse httpResponse) {
                        block5: {
                            try {
                                String response = httpResponse.mMessage;
                                LanguagesConfig languagesConfig = null;
                                if (!TextUtils.isEmpty((CharSequence)response)) {
                                    languagesConfig = (LanguagesConfig)ConfigHandler.this.gson.fromJson(response, LanguagesConfig.class);
                                }
                                if (languagesConfig == null) {
                                    throw new Exception("LanguagesConfig is null");
                                }
                                Logger.d((String)ConfigHandler.TAG, (String)("getLanguagesConfig success " + response));
                                if (callback != null) {
                                    callback.onResponse(languagesConfig, httpResponse.toString());
                                }
                            }
                            catch (Throwable e) {
                                Log.e((String)ConfigHandler.TAG, (String)("getLanguagesConfig: error " + e.getLocalizedMessage()));
                                if (callback == null) break block5;
                                callback.onFailure(new Throwable(e.getLocalizedMessage()));
                            }
                        }
                    }

                    public void onError(HttpError httpError) {
                        Log.e((String)ConfigHandler.TAG, (String)("getLanguagesConfig: error " + httpError));
                        if (callback != null) {
                            callback.onFailure(new Throwable(httpError.toString()));
                        }
                    }
                });
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getLanguagesConfig: error " + e.getLocalizedMessage()), (Throwable)e);
                if (callback == null) break block3;
                callback.onFailure(new Throwable(e.getLocalizedMessage()));
            }
        }
    }

    @Override
    public void enableMonitorMode() {
        this.configApiService = new ConfigApiServiceMonitorImp(this.httpManager, this.configApiService.getApiService(), this.monitorHelper);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }
}

