/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class LocalizationStrings
implements Serializable {
    private static final String ISO_COUNTRY = "iso_country";
    private static final String SPONSORED = "sponsored";
    private static final String LABEL_NOW = "label_now";
    private static final String NO_NETWORK_CONNECTION = "error_connection_not_available";
    private static final String defaultNotificationActionNextText = "Change";
    private static final String defaultNotificationActionOpenText = "Open";
    private static final String defaultNotificationActionReadMoreText = "Read More";
    private static final String defaultPushNotificationBreakingText = "Breaking";
    @SerializedName(value="iso_country")
    private String isoLanguage = "default";
    @SerializedName(value="sponsored")
    private String sponsored = "Sponsored";
    @SerializedName(value="label_now")
    private String nowLabel = "Now";
    @SerializedName(value="error_connection_not_available")
    private String noNetworkConnection = "No internet connection to display page";
    private Map<String, String> mutableLocalizationStringsHashMap = new HashMap<String, String>();
    private Map<String, String> mappingCache;

    private void setMutableLocalizationStringsHashMap(Map<String, String> mutableLocalizationStringsHashMap) {
        this.mutableLocalizationStringsHashMap = mutableLocalizationStringsHashMap;
    }

    public String getIsoLanguage() {
        return this.isoLanguage;
    }

    public String getSponsored() {
        return this.sponsored;
    }

    public String getNowLabel() {
        return this.nowLabel;
    }

    public String getNoNetworkConnection() {
        return this.noNetworkConnection;
    }

    public Map<String, String> getLocalizationStringsMap() {
        return this.mutableLocalizationStringsHashMap;
    }

    public String getDefaultNotificationActionNextText() {
        return defaultNotificationActionNextText;
    }

    public String getDefaultNotificationActionOpenText() {
        return defaultNotificationActionOpenText;
    }

    public String getDefaultNotificationActionReadMoreText() {
        return defaultNotificationActionReadMoreText;
    }

    public String getDefaultPushNotificationBreakingText() {
        return defaultPushNotificationBreakingText;
    }

    public static class LocalizationStringsJsonAdapter
    implements JsonDeserializer<ArrayList<LocalizationStrings>>,
    JsonSerializer<ArrayList<LocalizationStrings>> {
        public ArrayList<LocalizationStrings> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<LocalizationStrings> localizationStrings = new ArrayList<LocalizationStrings>();
            Gson gson = new Gson();
            for (JsonElement localizationItem : json.getAsJsonArray()) {
                LocalizationStrings localeItem = (LocalizationStrings)gson.fromJson(localizationItem, LocalizationStrings.class);
                Class type = new TypeToken<Map<String, String>>(){}.getRawType();
                ArrayList<String> immutableKeysList = new ArrayList<String>(Arrays.asList(LocalizationStrings.ISO_COUNTRY, LocalizationStrings.SPONSORED, LocalizationStrings.LABEL_NOW, LocalizationStrings.NO_NETWORK_CONNECTION));
                try {
                    Map stringMap = (Map)gson.fromJson(localizationItem, (Type)type);
                    localeItem.mappingCache = new HashMap(stringMap);
                    this.removeImmutableKeys(immutableKeysList, stringMap);
                    localeItem.setMutableLocalizationStringsHashMap(stringMap);
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
                localizationStrings.add(localeItem);
            }
            return localizationStrings;
        }

        private void removeImmutableKeys(ArrayList<String> immutableStringsList, Map<String, String> stringMap) {
            for (String item : immutableStringsList) {
                stringMap.remove(item);
            }
        }

        public JsonElement serialize(ArrayList<LocalizationStrings> src, Type typeOfSrc, JsonSerializationContext context) {
            try {
                Gson gson = new Gson();
                Class type = new TypeToken<Map<String, String>>(){}.getRawType();
                JsonArray array = new JsonArray();
                for (LocalizationStrings localizationObject : src) {
                    JsonElement element = gson.toJsonTree((Object)localizationObject.mappingCache, (Type)type);
                    array.add(element);
                }
                return array;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new JsonArray();
            }
        }
    }
}

