/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.app.NotificationManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;

public class ConditionCheckUtil {
    private static final String TAG = ConditionCheckUtil.class.getSimpleName();

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean areNotificationChannelsSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public static boolean areNotificationsBlockedByUser(@NonNull Context appContext, @NonNull String channelId) {
        boolean areNotificationsBlocked;
        boolean bl = areNotificationsBlocked = !NotificationManagerCompat.from((Context)appContext).areNotificationsEnabled();
        if (areNotificationsBlocked) {
            return true;
        }
        if (ConditionCheckUtil.areNotificationChannelsSupported()) {
            NotificationManager androidNotificationManager = (NotificationManager)appContext.getSystemService("notification");
            if (androidNotificationManager != null) {
                return androidNotificationManager.getNotificationChannel(channelId).getImportance() == 0;
            }
            Log.e((String)TAG, (String)"areNotificationsBlockedByUser: notification service is null");
            return false;
        }
        return false;
    }
}

