/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.taboola.android.plus.common.BaseConfig;
import java.util.ArrayList;

public abstract class BaseConfigValidator {
    protected final Gson gson = new Gson();

    protected static boolean isObjectValid(@Nullable JsonElement jsonElement, @NonNull ArrayList<String> requiredFields) {
        if (jsonElement == null) {
            return false;
        }
        for (String key : requiredFields) {
            if (jsonElement.getAsJsonObject().has(key)) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigValid(@NonNull String config) {
        JsonElement jsonElement = new JsonParser().parse(config);
        return this.isConfigValid(jsonElement);
    }

    public <T extends BaseConfig> T parseConfig(@NonNull String config, @NonNull Class<T> type) {
        JsonElement jsonElement = new JsonParser().parse(config);
        return this.parseConfig(jsonElement, type);
    }

    public abstract boolean isConfigValid(@NonNull JsonElement var1);

    public abstract <T extends BaseConfig> T parseConfig(@NonNull JsonElement var1, @NonNull Class<T> var2);
}

