/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.text.TextUtils;
import com.taboola.android.monitor.TBAbsSdkFeature;
import com.taboola.android.monitor.TBAuthenticationPlus;
import com.taboola.android.monitor.TBPlusFeaturesParams;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSuspendMonitorPlus;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

class MonitorParser {
    private static final String TAG = "Parser";
    private static final String FEATURE_PASSWORD = "376c21021b2800b444ae9214a5b251460c04490611dadf1585987e12ce0b6c21";
    private static final List<Class<? extends TBAbsSdkFeature>> CLASS_LIST = new ArrayList<Class<? extends TBAbsSdkFeature>>();

    MonitorParser() {
    }

    static Map<Integer, TBSdkFeature> parseSdkFeatures(String sdkFeaturesString, boolean validate) {
        HashMap<Integer, TBSdkFeature> sdkFeatures = new HashMap<Integer, TBSdkFeature>();
        boolean isAuthenticated = false;
        try {
            JSONObject sdkFeaturesJsonObject = new JSONObject(sdkFeaturesString);
            for (Class<? extends TBAbsSdkFeature> clazz : CLASS_LIST) {
                try {
                    int keyInt = clazz.getField("KEY").getInt(null);
                    JSONObject sdkFeatureJsonObject = sdkFeaturesJsonObject.optJSONObject(String.valueOf(keyInt));
                    if (sdkFeatureJsonObject == null) continue;
                    TBAbsSdkFeature tbSdkFeature = clazz.newInstance();
                    tbSdkFeature.initFromJSON(sdkFeatureJsonObject);
                    sdkFeatures.put(keyInt, tbSdkFeature);
                }
                catch (Exception e) {
                    Logger.e((String)TAG, (String)e.toString(), (Throwable)e);
                }
            }
            if (validate) {
                TBAuthenticationPlus tbAuthentication = (TBAuthenticationPlus)((Object)sdkFeatures.get(0));
                String password = tbAuthentication != null ? tbAuthentication.getPassword() : "";
                String keyHash = SecurityUtils.getSHA256((String)password).toLowerCase();
                isAuthenticated = TextUtils.equals((CharSequence)FEATURE_PASSWORD, (CharSequence)keyHash);
                sdkFeatures.remove(0);
            } else {
                isAuthenticated = true;
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.toString(), (Throwable)e);
        }
        if (!isAuthenticated) {
            sdkFeatures.clear();
            TBSuspendMonitorPlus tbSuspendMonitor = new TBSuspendMonitorPlus();
            tbSuspendMonitor.setShouldSuspend(true);
            sdkFeatures.put(2, tbSuspendMonitor);
        }
        return sdkFeatures;
    }

    static {
        CLASS_LIST.add(TBAuthenticationPlus.class);
        CLASS_LIST.add(TBPlusFeaturesParams.class);
        CLASS_LIST.add(TBSuspendMonitorPlus.class);
    }
}

