/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.content.Context;
import android.os.Handler;
import android.os.Messenger;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.taboola.android.MonitorManager;
import com.taboola.android.monitor.MonitorHandler;
import com.taboola.android.monitor.MonitorLocalStorage;
import com.taboola.android.monitor.TBPlusFeaturesParams;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSuspendMonitorPlus;
import com.taboola.android.plus.core.SdkPlusPublisherInfo;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.util.Map;

public class MonitorHelper {
    private static final String TAG = MonitorHelper.class.getSimpleName();
    private MonitorLocalStorage monitorLocalStorage;
    @Nullable
    private MonitorManager monitorManager;
    @Nullable
    private Map<Integer, TBSdkFeature> sdkFeatures;

    public MonitorHelper(Context applicationContext) {
        try {
            this.monitorLocalStorage = new MonitorLocalStorage(applicationContext);
            if (MonitorUtils.isSdkMonitorInstalled((Context)applicationContext)) {
                this.setSdkFeatures(this.monitorLocalStorage.getSdkFeatures(), false);
                this.monitorManager = MonitorManager.getInstance((String)SdkDetailsHelper.getApplicationName((Context)applicationContext));
                this.monitorManager.bindService(applicationContext);
                Messenger monitorMessenger = new Messenger((Handler)new MonitorHandler(this));
                this.monitorManager.sendGetFeatureSet(monitorMessenger, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean shouldInitFromMonitor(@NonNull Context context) {
        boolean shouldInitFromMonitor;
        try {
            shouldInitFromMonitor = MonitorUtils.isSdkMonitorInstalled((Context)context) && this.isSdkMonitorEnabled();
        }
        catch (Exception e) {
            Logger.d((String)TAG, (String)("shouldInitFromMonitor fail " + e));
            shouldInitFromMonitor = false;
        }
        return shouldInitFromMonitor;
    }

    public Pair<String, String> getInitParamsFromMonitor(@NonNull SdkPlusPublisherInfo info) {
        TBPlusFeaturesParams paramsChange = (TBPlusFeaturesParams)((Object)this.getFeature(8));
        String publisherName = info.getPublisherName();
        String configId = info.getConfigId();
        if (paramsChange != null && this.isSdkMonitorEnabled()) {
            String newPubId = paramsChange.getPublisherName();
            String newConfigId = paramsChange.getConfigId();
            if (!TextUtils.isEmpty((CharSequence)newPubId)) {
                publisherName = newPubId;
            }
            if (!TextUtils.isEmpty((CharSequence)newConfigId)) {
                configId = newConfigId;
            }
        }
        return new Pair((Object)publisherName, (Object)configId);
    }

    @Nullable
    public String getOverrideConfigResponse() {
        TBPlusFeaturesParams paramsChange = (TBPlusFeaturesParams)((Object)this.getFeature(8));
        if (paramsChange != null && this.isSdkMonitorEnabled()) {
            return paramsChange.getOverrideConfig();
        }
        return null;
    }

    @Nullable
    public Pair<String, String> getConfigUrlsFromMonitor() {
        TBPlusFeaturesParams paramsChange = (TBPlusFeaturesParams)((Object)this.getFeature(8));
        if (paramsChange != null && this.isSdkMonitorEnabled()) {
            return new Pair((Object)paramsChange.getConfigUrl(), (Object)paramsChange.getLangUrl());
        }
        return null;
    }

    public boolean shouldOverrideConfigUrls() {
        Pair<String, String> urls = this.getConfigUrlsFromMonitor();
        return urls != null && !TextUtils.isEmpty((CharSequence)((CharSequence)urls.first)) && !TextUtils.isEmpty((CharSequence)((CharSequence)urls.second));
    }

    public void sendNetworkCall(long time, String urlAfterDecode) {
        if (this.monitorManager != null && this.isSdkMonitorEnabled()) {
            this.monitorManager.sendNetworkCall(time, urlAfterDecode);
        }
    }

    void setSdkFeatures(@NonNull Map<Integer, TBSdkFeature> sdkFeatures, boolean saveToLocalStorage) {
        this.sdkFeatures = sdkFeatures;
        if (saveToLocalStorage) {
            this.monitorLocalStorage.setSdkFeatures(sdkFeatures);
        }
    }

    @Nullable
    private <T extends TBSdkFeature> T getFeature(Integer key) {
        if (this.sdkFeatures == null || this.sdkFeatures.size() == 0) {
            return null;
        }
        TBSdkFeature sdkFeature = this.sdkFeatures.get(key);
        if (sdkFeature != null) {
            return (T)sdkFeature;
        }
        return null;
    }

    public boolean isSdkMonitorEnabled() {
        TBSuspendMonitorPlus suspendMonitor = (TBSuspendMonitorPlus)((Object)this.getFeature(2));
        return suspendMonitor != null && !suspendMonitor.isShouldSuspend();
    }
}

