/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.util.Log;
import com.google.gson.Gson;
import com.taboola.android.plus.core.IStorageMigrationManager;
import java.util.HashSet;
import java.util.Map;

public class StorageMigrationManager
implements IStorageMigrationManager {
    private static final String TAG = StorageMigrationManager.class.getSimpleName();
    private static final int LOCAL_STORAGE_SCHEMA_VERSION_ONE = 1;
    private static final int LOCAL_STORAGE_SCHEMA_VERSION_TWO = 2;
    private static final int LOCAL_STORAGE_SCHEMA_VERSION_THREE = 3;
    private static final int LOCAL_STORAGE_SCHEMA_VERSION_LATEST = 3;

    @Override
    public boolean isMigrationRequired(Context context) {
        SharedPreferences sharedLocalStoragePreferences = context.getSharedPreferences("shared_local_storage", 0);
        int schemaVersion = sharedLocalStoragePreferences.getInt("local_storage_schema_version", 1);
        Log.i((String)TAG, (String)("is migration required? " + (schemaVersion < 3) + ", current version: " + schemaVersion));
        return schemaVersion < 3 || this.isCurrentVersionFakeV3(context);
    }

    @Override
    @UiThread
    public void migrate(@NonNull Context context) {
        int currentVersion = StorageMigrationManager.getCurrentLocalStorageSchemaVersion(context);
        if (currentVersion == 1) {
            StorageMigrationManager.migrateLocalStorageSchemaFrom1To2(context);
            currentVersion = 2;
        }
        if (currentVersion == 2) {
            StorageMigrationManager.migrateLocalStorageSchemaFrom2To3(context);
            currentVersion = 3;
        }
        boolean isCurrentVersionFakeV3 = this.isCurrentVersionFakeV3(context);
        if (currentVersion == 3 && isCurrentVersionFakeV3) {
            this.migrateLocalStorageSchemaFromFake3To3(context);
        }
    }

    private static int getCurrentLocalStorageSchemaVersion(Context context) {
        SharedPreferences sharedLocalStoragePreferences = context.getSharedPreferences("shared_local_storage", 0);
        return sharedLocalStoragePreferences.getInt("local_storage_schema_version", 1);
    }

    private boolean isCurrentVersionFakeV3(Context context) {
        SharedPreferences scheduledNotificationsSharedPreferences = context.getSharedPreferences("tb_notification_manager", 0);
        Map scheduledNotificationsMap = scheduledNotificationsSharedPreferences.getAll();
        return !(scheduledNotificationsMap.get("tb_only_wifi_mode") instanceof String);
    }

    private static void migrateLocalStorageSchemaFrom1To2(Context context) {
        SharedPreferences scheduledNotificationsSharedPreferences = context.getSharedPreferences("tb_notification_manager", 0);
        SharedPreferences.Editor sharedEditor = context.getSharedPreferences("shared_local_storage", 0).edit();
        sharedEditor.putBoolean("tb_notification_enabled", scheduledNotificationsSharedPreferences.getBoolean("tb_notification_enabled", false));
        sharedEditor.putBoolean("is_notification_block_by_system", scheduledNotificationsSharedPreferences.getBoolean("is_notification_block_by_system", false));
        sharedEditor.putBoolean("tb_only_wifi_mode", scheduledNotificationsSharedPreferences.getBoolean("tb_only_wifi_mode", false));
        sharedEditor.putBoolean("is_kibana_analytics_enabled", scheduledNotificationsSharedPreferences.getBoolean("is_kibana_analytics_enabled", false));
        sharedEditor.putInt("tb_notification_icon_id", scheduledNotificationsSharedPreferences.getInt("tb_notification_icon_id", -1));
        sharedEditor.putInt("local_storage_schema_version", 2);
        sharedEditor.putLong("last_check_notification_disabled_status_event_time", scheduledNotificationsSharedPreferences.getLong("last_check_notification_disabled_status_event_time", -1L));
        sharedEditor.putLong("tb_last_event_time", scheduledNotificationsSharedPreferences.getLong("tb_last_event_time", -1L));
        sharedEditor.putString("tb_notification_application_name", scheduledNotificationsSharedPreferences.getString("tb_notification_application_name", ""));
        sharedEditor.putString("tb_config_variant", scheduledNotificationsSharedPreferences.getString("tb_config_variant", ""));
        sharedEditor.putString("taboola_plus_extra_properties", scheduledNotificationsSharedPreferences.getString("taboola_plus_extra_properties", ""));
        sharedEditor.putString("tb_publisher", scheduledNotificationsSharedPreferences.getString("tb_publisher", ""));
        sharedEditor.putString("tb_config_id", scheduledNotificationsSharedPreferences.getString("tb_config_id", ""));
        sharedEditor.putString("sim_country", scheduledNotificationsSharedPreferences.getString("sim_country", ""));
        sharedEditor.putString("tb_previous_config", scheduledNotificationsSharedPreferences.getString("tb_previous_config", ""));
        sharedEditor.putString("tb_current_config", scheduledNotificationsSharedPreferences.getString("tb_current_config", ""));
        sharedEditor.putStringSet("crashes_events_need_to_send_to_kusto", scheduledNotificationsSharedPreferences.getStringSet("crashes_events_need_to_send_to_kusto", new HashSet()));
        sharedEditor.putStringSet("tb_notification_categories", scheduledNotificationsSharedPreferences.getStringSet("tb_notification_categories", new HashSet()));
        sharedEditor.apply();
    }

    private static void migrateLocalStorageSchemaFrom2To3(Context context) {
        StorageMigrationManager.updateCorePreferencesFrom2To3(context);
        StorageMigrationManager.updateScheduledNotificationsPreferencesFrom2To3(context);
        StorageMigrationManager.updatePushNotificationsPreferencesFrom2To3(context);
        SharedPreferences.Editor edit = context.getSharedPreferences("shared_local_storage", 0).edit();
        edit.putInt("local_storage_schema_version", 3);
        edit.apply();
    }

    private static void updateCorePreferencesFrom2To3(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor coreEditor = context.getSharedPreferences("core_local_storage", 0).edit();
        coreEditor.putString("tb_config_id", sharedPreferences.getString("tb_config_id", ""));
        coreEditor.putString("tb_current_config", sharedPreferences.getString("tb_current_config", ""));
        coreEditor.putString("tb_config_id", sharedPreferences.getString("tb_config_id", ""));
        coreEditor.putInt("core_storage_schema_version", 3);
        coreEditor.apply();
    }

    private static void updateScheduledNotificationsPreferencesFrom2To3(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor scheduledEditor = context.getSharedPreferences("tb_notification_manager", 0).edit();
        scheduledEditor.putString("taboola_plus_extra_properties", sharedPreferences.getString("taboola_plus_extra_properties", ""));
        scheduledEditor.putInt("tb_notification_icon_id", sharedPreferences.getInt("tb_notification_icon_id", 1));
        scheduledEditor.putString("tb_notification_application_name", sharedPreferences.getString("tb_notification_application_name", ""));
        scheduledEditor.putStringSet("tb_notification_categories", sharedPreferences.getStringSet("tb_notification_categories", new HashSet()));
        boolean isOnlyWifi = sharedPreferences.getBoolean("tb_only_wifi_mode", false);
        if (isOnlyWifi) {
            Gson gson = new Gson();
            String isOnlyWifiJson = gson.toJson((Object)true);
            scheduledEditor.putString("tb_only_wifi_mode", isOnlyWifiJson);
        } else {
            scheduledEditor.putString("tb_only_wifi_mode", null);
        }
        scheduledEditor.putBoolean("tb_notification_enabled", sharedPreferences.getBoolean("tb_notification_enabled", false));
        scheduledEditor.putInt("scheduled_notifications_storage_schema_version", 3);
        scheduledEditor.apply();
    }

    private static void updatePushNotificationsPreferencesFrom2To3(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor pushEditor = context.getSharedPreferences("push_notifications_local_storage", 0).edit();
        pushEditor.putInt("tb_notification_icon_id", sharedPreferences.getInt("tb_notification_icon_id", 1));
        pushEditor.putString("tb_notification_application_name", sharedPreferences.getString("tb_notification_application_name", ""));
        pushEditor.putInt("push_notifications_storage_schema_version", 3);
        pushEditor.apply();
    }

    private void migrateLocalStorageSchemaFromFake3To3(Context context) {
        StorageMigrationManager.updateCorePreferencesFromFake3To3(context);
        StorageMigrationManager.updateScheduledNotificationsPreferencesFromFake3To3(context);
        StorageMigrationManager.updatePushNotificationsPreferencesFromFake3To3(context);
        SharedPreferences.Editor edit = context.getSharedPreferences("shared_local_storage", 0).edit();
        edit.putInt("local_storage_schema_version", 3);
        edit.apply();
    }

    private static void updateCorePreferencesFromFake3To3(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor coreEditor = context.getSharedPreferences("core_local_storage", 0).edit();
        SharedPreferences coreSharedPreferences = context.getSharedPreferences("core_local_storage", 0);
        if (!coreSharedPreferences.contains("tb_config_id")) {
            coreEditor.putString("tb_config_id", sharedPreferences.getString("tb_config_id", ""));
        }
        if (!coreSharedPreferences.contains("tb_current_config")) {
            coreEditor.putString("tb_current_config", sharedPreferences.getString("tb_current_config", ""));
        }
        if (!coreSharedPreferences.contains("tb_config_id")) {
            coreEditor.putString("tb_config_id", sharedPreferences.getString("tb_config_id", ""));
        }
        coreEditor.putInt("core_storage_schema_version", 3);
        coreEditor.apply();
    }

    private static void updateScheduledNotificationsPreferencesFromFake3To3(Context context) {
        boolean isOnlyWifi;
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor scheduledEditor = context.getSharedPreferences("tb_notification_manager", 0).edit();
        SharedPreferences scheduledSharedPreferences = context.getSharedPreferences("tb_notification_manager", 0);
        if (!scheduledSharedPreferences.contains("taboola_plus_extra_properties")) {
            scheduledEditor.putString("taboola_plus_extra_properties", sharedPreferences.getString("taboola_plus_extra_properties", ""));
        }
        if (!scheduledSharedPreferences.contains("tb_notification_icon_id")) {
            scheduledEditor.putInt("tb_notification_icon_id", sharedPreferences.getInt("tb_notification_icon_id", 1));
        }
        if (!scheduledSharedPreferences.contains("tb_notification_application_name")) {
            scheduledEditor.putString("tb_notification_application_name", sharedPreferences.getString("tb_notification_application_name", ""));
        }
        if (!scheduledSharedPreferences.contains("tb_notification_categories")) {
            scheduledEditor.putStringSet("tb_notification_categories", sharedPreferences.getStringSet("tb_notification_categories", new HashSet()));
        }
        if (isOnlyWifi = sharedPreferences.getBoolean("tb_only_wifi_mode", false)) {
            Gson gson = new Gson();
            String isOnlyWifiJson = gson.toJson((Object)true);
            scheduledEditor.putString("tb_only_wifi_mode", isOnlyWifiJson);
        } else {
            scheduledEditor.putString("tb_only_wifi_mode", null);
        }
        if (!scheduledSharedPreferences.contains("tb_notification_enabled")) {
            scheduledEditor.putBoolean("tb_notification_enabled", sharedPreferences.getBoolean("tb_notification_enabled", false));
        }
        scheduledEditor.putInt("scheduled_notifications_storage_schema_version", 3);
        scheduledEditor.apply();
    }

    private static void updatePushNotificationsPreferencesFromFake3To3(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("shared_local_storage", 0);
        SharedPreferences.Editor pushEditor = context.getSharedPreferences("push_notifications_local_storage", 0).edit();
        SharedPreferences pushSharedPreferences = context.getSharedPreferences("push_notifications_local_storage", 0);
        if (!pushSharedPreferences.contains("tb_notification_icon_id")) {
            pushEditor.putInt("tb_notification_icon_id", sharedPreferences.getInt("tb_notification_icon_id", 1));
        }
        if (!pushSharedPreferences.contains("tb_notification_application_name")) {
            pushEditor.putString("tb_notification_application_name", sharedPreferences.getString("tb_notification_application_name", ""));
        }
        pushEditor.putInt("push_notifications_storage_schema_version", 3);
        pushEditor.apply();
    }
}

